      SUBROUTINE QFILES (MESSFL,FLNAME)
C
C     + + + PURPOSE + + +
C     Subroutine for seperate files of QUAL2E such as
C     observed DO data, uncertainty analysis specifications,
C     and local climatological data.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER      MESSFL
      CHARACTER*64 FLNAME
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     FLNAME - file name of base data set used from AN/QUAL interaction
C
C     + + + COMMON BLOCK + + +
      INCLUDE 'CQ2VAL.INC'
C
C     + + + LOCAL VARIABLES + + +
      INTEGER      I,I1,SCLU,SGRP,RESP,SUCIFL,RETCOD
      CHARACTER*1  SCHRBF(80)
      CHARACTER*64 BSFLNM
C
C     + + + EXTERNALS + + +
      EXTERNAL     QRESP, QLOCLI, QOBSDO, QUNCAS, QFOPEN, QFCLOS
      EXTERNAL     AQ2INI, AQ2REA, SCCLAL, ZSTCMA, ZGTRET
C
C     + + + END SPECIFICATIONS + + +
C
      I1  = 1
      SCLU= 19
C     make 'prev' available
      I= 4
      CALL ZSTCMA (I,I1)
C     try to open the old file
      SGRP= 1
      CALL QFOPEN (MESSFL,SCLU,SGRP,SUCIFL,RETCOD)
C     get exit command value
      CALL ZGTRET (I)
      IF (RETCOD.EQ.0 .AND. I.EQ.1) THEN
C       file opened ok, user wants to continue
        INQUIRE (SUCIFL,NAME=BSFLNM)
        IF (BSFLNM.NE.FLNAME) THEN
C         initialize common block
          CALL AQ2INI (MESSFL)
          IF (RETCOD.EQ.0) THEN
C           fill the annie/qual2 common blocks with values from old file
            CALL AQ2REA (MESSFL,SUCIFL)
          END IF
        END IF
        I= 0
        IF (RETCOD.EQ.0) CALL QFCLOS (SUCIFL,I)
C
 5      CONTINUE
          CALL SCCLAL
C         which file (OBSDO, LOCAL CLIM, or UNCAS)?
          SGRP= 2
          CALL QRESP (MESSFL,SCLU,SGRP,RESP)
          GO TO (10,20,30,40) RESP
C
 10       CONTINUE
C           local climatological data
            CALL QLOCLI (MESSFL,SCLU,MAXITR,MXTIM,METFLG)
            GO TO 50
C
 20       CONTINUE
C           observed DO data
            CALL QOBSDO (MESSFL,METFLG,NUMRCH,DAT2)
            GO TO 50
C
 30       CONTINUE
C           uncertainty analysis specifations file
            CALL QUNCAS (MESSFL,NUMRCH,NCMPEL)
            GO TO 50
C
 40       CONTINUE
C           all done
            GO TO 50
C
 50       CONTINUE
C
        IF (RESP.NE.4) GO TO 5
      END IF
C
      RETURN
      END
