      SUBROUTINE QLOCLI
     I                  (MESSFL,SCLU,MAXITR,MXTIM,METRIC)
C
C     + + + PURPOSE + + +
C     routine to create local climatology data file
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,
     1            MXTIM,METRIC
      REAL        MAXITR
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SCLU   - screen cluster number on message file for this file
C     MAXITR - maximum number of iterations for this run
C     MXTIM  - maximum number of iterations
C     METRIC - metric flag
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,J,I0,I1,I6,CVAL(1,3),SGRP,INUM,RNUM,LCLFIL,
     1            INONE,ITRDEF,MXRTIM,CLDTM(4,40),NROWS,RWS,SAVFG,
     2            TUNIT,NVALS,TSTEP,TIMNOW(6),TIMNEW(6),RESP,RETCOD
      REAL        RVAL,CLDAT(6,40),RNONE
      CHARACTER*1 SCHRBF(80,75)
C
C     + + + INTRINSICS + + +
      INTRINSIC   NINT
C
C     + + + EXTERNALS + + +
      EXTERNAL    QRESP, ZIPI, ZIPR, QFOPEN, LCLREA, LCLWRT
      EXTERNAL    QRESPI, QFCLOS, TIMADD, QRESCN
C
C     + + + END SPECIFICATIONS + + +
C
      I0    = 0
      I1    = 1
      I6    = 6
      INONE = -999
      RNONE = -999.
      ITRDEF= 0
C
C     initialize all parameters
      MXRTIM= I0
      CALL ZIPI (4*MXTIM,INONE,CLDTM)
      CALL ZIPR (6*MXTIM,RNONE,CLDAT)
      CALL ZIPI (I6,INONE,TIMNOW)
      CALL ZIPI (I6,INONE,TIMNEW)
C
C     check MAXITR to be sure data exists
      IF (MAXITR.LT.-900) THEN
C       undefined - continue?
        SGRP= 3
        CALL QRESP (MESSFL,SCLU,SGRP,RESP)
        ITRDEF= 1
      ELSE
C       defined - assign to local max iterations
        MXRTIM= NINT(MAXITR)
        RWS   = NINT(MXRTIM/3.0)
        RESP  = 2
      END IF
      IF (RESP.EQ.2) THEN
        SAVFG= 1
 5      CONTINUE
C         continue - setup, edit, or save?
          SGRP= 4
          CALL QRESP (MESSFL,SCLU,SGRP,RESP)
          IF (RESP.EQ.1) THEN
C           work from new file
            RETCOD= 1
          ELSE IF (RESP.EQ.2) THEN
C           try to open old file
            SGRP= 5
            CALL QFOPEN (MESSFL,SCLU,SGRP,LCLFIL,RETCOD)
            IF (RETCOD.EQ.0) THEN
C             fill in local clim common block with old file values
              CALL LCLREA (MXTIM,LCLFIL,
     M                     RETCOD,
     O                     NROWS,CLDTM,CLDAT)
              I= 0
              CALL QFCLOS (LCLFIL,I)
            END IF
            IF (RETCOD.EQ.0) THEN
C             file read o.k. - check maxit, tstep, and nrows
              IF (ITRDEF.EQ.1) THEN
C               get maximum number of iterations
                SGRP= 6
                CALL QRESPI (MESSFL,SCLU,SGRP,MXRTIM)
                RWS = NINT(MXRTIM/3.0)
                ITRDEF= 0
              END IF
              IF (RWS.GT.NROWS) THEN
C               not equal - adjust arrays to RWS
                CALL ZIPR (6*(RWS-NROWS),RNONE,CLDAT(1,NROWS+1))
              END IF
            END IF
          ELSE IF (RESP.EQ.3) THEN
C           try to open file for output
            SGRP= 7
            CALL QFOPEN (MESSFL,SCLU,SGRP,LCLFIL,RETCOD)
            IF (RETCOD.EQ.0) THEN
C             opened ok, write data to file
              CALL LCLWRT (MESSFL,SCLU,LCLFIL,RWS,CLDTM,CLDAT)
              I= 0
              CALL QFCLOS (LCLFIL,I)
              SAVFG= 1
            END IF
          ELSE IF (RESP.EQ.4) THEN
C           all done, is everything saved?
            IF (SAVFG.EQ.0) THEN
C             let user know files unsaved and verify exit
              SGRP= 8
              CALL QRESP (MESSFL,SCLU,SGRP,RESP)
              IF (RESP.EQ.1) THEN
C               dont exit, go back and save
                RESP= 3
              ELSE
C               want to exit no matter what
                RESP= 4
              END IF
            END IF
          END IF
C
          IF (RESP.EQ.1 .OR. RESP.EQ.2) THEN
C           do some editting
            SAVFG= 0
            IF (RETCOD.NE.0) THEN
C             new file, get starting date and hour
              SGRP= 9
              INUM= 4
              CALL QRESCN (MESSFL,SCLU,SGRP,INUM,I1,I1,I1,I1,
     M                     CLDTM,RVAL,CVAL,SCHRBF)
              IF (ITRDEF.EQ.1) THEN
C               get maximum route time
                SGRP= 6
                CALL QRESPI (MESSFL,SCLU,SGRP,MXRTIM)
                RWS = NINT(MXRTIM/3.0)
              END IF
            END IF
            IF (RETCOD.NE.0.OR.NROWS.NE.RWS) THEN
C             fill in dates and hour of day
              TUNIT= 3
              TSTEP= 3
              NVALS= 1
              DO 30 I= 1,RWS-1
                DO 10 J= 1,4
                  TIMNOW(J)= CLDTM(J,I)
 10             CONTINUE
                CALL TIMADD (TIMNOW,TUNIT,TSTEP,NVALS,TIMNEW)
                DO 20 J= 1,4
                  CLDTM(J,I+1)= TIMNEW(J)
 20             CONTINUE
 30           CONTINUE
            END IF
C
            IF (METRIC.NE.0 .AND. METRIC.NE.1)THEN
C             undefined, find out which units
              SGRP= 10
              CALL QRESP (MESSFL,SCLU,SGRP,METRIC)
              IF (METRIC.EQ.2) METRIC= 0
            END IF
C
C           get the local climatological data
            INUM= 4
            RNUM= 6
            SGRP= METRIC+ 11
            CALL QRESCN (MESSFL,SCLU,SGRP,INUM,RNUM,I1,RWS,I1,
     M                   CLDTM,CLDAT,CVAL,SCHRBF)
          END IF
C
        IF (RESP.NE.4) GO TO 5
      END IF
C
      RETURN
      END
