      SUBROUTINE QSETUP
     I                  (MESSFL,
     O                   IRET)
C
C     + + + PURPOSE + + +
C     input required parameter values for new input sequence
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   MESSFL,IRET
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     IRET   - user exit command from setup
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CQ2VAL.INC'
C
C     + + + LOCAL VARIABLES + + +
      INTEGER      I,I0,I1,SCLU,ISCRN,DONFG
      CHARACTER*22 SCNAME
C
C     + + + EXTERNALS + + +
      EXTERNAL     QSUCPR, QSURCH, QSUHDW, QSUJUN, QSUPTL, QSUCEL
      EXTERNAL     ZSTCMA, ZWNSET
C
C     + + + END SPECIFICATIONS + + +
C
      I0   = 0
      I1   = 1
      SCLU = 7
      ISCRN= 1
C     make 'Prev' available
      I= 4
      CALL ZSTCMA (I,I1)
C
      DONFG= 0
 5    CONTINUE
C       loop until set up complete
        GO TO (10,20,30,40,50,60), ISCRN
C
 10     CONTINUE
C         start set up, define needed control parameters
          CALL QSUCPR (MESSFL,SCLU,
     M                 QTITLE,BNAME,NUMRCH,NUMHDW,NUMPTL,
     M                 NUMJUN,METFLG,PCRVL(2),IRET)
          IF (IRET.EQ.2) THEN
C           user wants previous screen
            DONFG= 1
          ELSE
C           continue to next screen
            ISCRN= ISCRN+ 1
          END IF
          GO TO 100
C
 20     CONTINUE
C         continue set up, reach id screen
          CALL QSURCH (MESSFL,SCLU,NUMRCH,NUMHDW,METFLG,PCRVL(2),
     M                 RCHNAM,DAT2,DAT9,NCMPEL,CMPELF,IRET)
          IF (IRET.EQ.2) THEN
C           user wants previous screen
            ISCRN= ISCRN- 1
          ELSE
C           continue to next screen
            ISCRN= ISCRN+ 1
          END IF
          GO TO 100
C
 30     CONTINUE
C         continue set up, enter headwater names
          CALL QSUHDW (MESSFL,SCLU,NUMHDW,
     M                 HDWNAM,IRET)
          IF (IRET.EQ.2) THEN
C           user wants previous screen
            ISCRN= ISCRN- 1
          ELSE
C           continue to next screen
            ISCRN= ISCRN+ 1
          END IF
          GO TO 100
C
 40     CONTINUE
C         continue set up, set up junction data
          IF (NUMJUN.GT.0) THEN
C           junctions exist to be defined
            CALL QSUJUN (MESSFL,SCLU,NUMJUN,
     M                   JUNNAM,IRET) 
          END IF
          IF (IRET.EQ.2) THEN
C           user wants previous screen
            ISCRN= ISCRN- 1
          ELSE
C           continue to next screen
            ISCRN= ISCRN+ 1
          END IF
          GO TO 100
C
 50     CONTINUE
C         continue set up, set up point load data
          IF (NUMPTL.GT.0) THEN
C           point-loads exist to be defined 
            CALL QSUPTL (MESSFL,SCLU,NUMPTL,NUMRCH,DAT2,
     I                   NCMPEL,CMPELF,PCRVL(2),METFLG,
     M                   PTLNAM,IRET)
          END IF
          IF (IRET.EQ.2) THEN
C           user wants previous screen
            ISCRN= ISCRN- 1
          ELSE
C           continue to next screen
            ISCRN= ISCRN+ 1
          END IF
          GO TO 100
C
 60     CONTINUE
C         continue set up, verify computational elements are correct
          SCNAME= 'Computational Elements'
          CALL QSUCEL (MESSFL,NUMRCH,NCMPEL,
     I                 NUMHDW,NUMJUN,NUMPTL,SCNAME,
     M                 CMPELF,IRET)
          IF (IRET.EQ.2) THEN
C          user wants previous screen
            ISCRN= ISCRN- 1
          ELSE
C          all cone with set up screens
            DONFG= 1
          END IF
          GO TO 100
C
 100    CONTINUE
      IF (DONFG.EQ.0) GO TO 5
C
C     make 'Prev' unavailable
      I= 4
      CALL ZSTCMA (I,I0)
C
      RETURN
      END
