      SUBROUTINE QSUCEL
     I                  (MESSFL,NUMRCH,NCMPEL,
     I                   NUMHDW,NUMJUN,NUMPTL,SCNAME,
     M                   CMPELF,IRET)
C
C     + + + PURPOSE + + +
C     verify computational element flags as defined in Set Up
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   MESSFL,NUMRCH,NCMPEL(NUMRCH),NUMHDW,NUMJUN,NUMPTL,
     1          CMPELF(20,NUMRCH),IRET
      CHARACTER SCNAME*(*)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     NUMRCH - number of reaches
C     NCMPEL - number of computational
C     NUMHDW - number of headwaters
C     NUMJUN - number of junctions
C     NUMPTL - number of point loads
C     SCNAME - screen name
C     CMPELF - computational element flags
C     IRET   - user exit command from full screen
C
C     + + + LOCAL VARIABLES + + +
      INTEGER      I,J,K,I1,SCLU,SGRP,INUM,RNUM,
     1             IVAL(21,200),CVAL(1,3,200),LNMHDW,LNMPTL,
     2             UPSJUN,DWNJUN,MAXDSE,INIT,IWRT,LEN,IERR
C     1             IVAL(21,50),CVAL(1,3,50),LNMHDW,LNMPTL,
      REAL         RVAL(1,200)
C      REAL         RVAL(1,50)
      CHARACTER*1  TBUFF(80,200),BLNK
C      CHARACTER*1  TBUFF(80,50),BLNK
      CHARACTER*27 LSCNAM
C
C     + + + EXTERNALS + + +
      EXTERNAL     ZIPI, ZIPC, QRESCN, ZGTRET, GETTXT
      EXTERNAL     ZBLDWR, ZWNSET, PMXTXT
C
C     + + + END SPECIFICATIONS + + +
C
      I1  = 1
      SCLU= 7
      BLNK= ' '
C
C     init IBUFF
      I= 0
      INUM= 21
      CALL ZIPI (INUM*NUMRCH,I,IVAL)
C     fill arrays
      DO 20 I= 1,NUMRCH
C       fill in reach numbers
        RVAL(1,I)= I
C       fill in number of comp elements
        IVAL(1,I)= NCMPEL(I)
        DO 10 J= 1,NCMPEL(I)
C         fill in comp elements
          IVAL(J+1,I)= CMPELF(J,I)
 10     CONTINUE
 20   CONTINUE
C
C     show screen of comp elements to be modified if desired
      CALL ZWNSET (SCNAME)
      SGRP= 19
      RNUM= 1
      CALL QRESCN (MESSFL,SCLU,SGRP,INUM,RNUM,I1,NUMRCH,I1,
     M             IVAL,RVAL,CVAL,TBUFF)
C     get user exit command
      CALL ZGTRET(IRET) 
C
C     check to make sure any user changes are valid
      IERR= 0
      INIT= 1
      IWRT= 1
      LEN = 80
      CALL ZIPC (LEN,BLNK,TBUFF)
      LNMHDW= 0
      LNMPTL= 0
      UPSJUN= 0
      DWNJUN= 0
      MAXDSE= 0
      DO 40 I= 1,NUMRCH
        DO 30 J= 1,NCMPEL(I)
C         put value in CMPELF array
          CMPELF(J,I)= IVAL(J+1,I)
C         make sure value is ok where located
          IF (CMPELF(J,I).EQ.1) THEN
C           headwater
            LNMHDW= LNMHDW+ 1
C           must be first element
            IF (J.GT.1) IERR= 1
          ELSE IF (CMPELF(J,I).EQ.3) THEN
C           upstream junction element
            UPSJUN= UPSJUN+ 1
C           must be last element
            IF (J.LT.NCMPEL(I)) IERR= 2
          ELSE IF (CMPELF(J,I).EQ.4) THEN
C           downstream junction element
            DWNJUN= DWNJUN+ 1
C           must be first element
            IF (J.GT.1) IERR= 3
          ELSE IF (CMPELF(J,I).EQ.5) THEN
C           last element
            MAXDSE= MAXDSE+ 1
C           must be last element of all
            IF (I.NE.NUMRCH .OR. J.NE.NCMPEL(I)) IERR= 4
          ELSE IF (CMPELF(J,I).EQ.6 .OR. CMPELF(J,I).EQ.7) THEN
C           point-load or withdrawal
            LNMPTL= LNMPTL+ 1
          END IF
          IF (IERR.GT.0) THEN
C           found problem, get message
            LEN = 80
            SGRP= 19+ IERR
            CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
            CALL ZBLDWR (LEN,TBUFF,INIT,IWRT,K)
            INIT= 0
            IERR= 0
          END IF
 30     CONTINUE
 40   CONTINUE
C     check number of each type of element
      IF (LNMHDW.NE.NUMHDW) THEN
        LEN = 80
        SGRP= 24
        CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
        CALL ZBLDWR (LEN,TBUFF,INIT,IWRT,K)
        INIT= 0
      END IF
      IF (UPSJUN.NE.NUMJUN) THEN
        LEN = 80
        SGRP= 25
        CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
        CALL ZBLDWR (LEN,TBUFF,INIT,IWRT,K)
        INIT= 0
      END IF
      IF (DWNJUN.NE.NUMJUN) THEN
        LEN = 80
        SGRP= 26
        CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
        CALL ZBLDWR (LEN,TBUFF,INIT,IWRT,K)
        INIT= 0
      END IF
      IF (MAXDSE.GT.1) THEN
        LEN = 80
        SGRP= 27
        CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
        CALL ZBLDWR (LEN,TBUFF,INIT,IWRT,K)
        INIT= 0
      END IF
      IF (LNMPTL.NE.NUMPTL) THEN
        LEN = 80
        SGRP= 28
        CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
        CALL ZBLDWR (LEN,TBUFF,INIT,IWRT,K)
        INIT= 0
      END IF
      IF (INIT.EQ.0) THEN
C       a message was written, finish message with write and wait
        LSCNAM= 'Computational Element Flags'
        CALL ZWNSET (LSCNAM)
        INIT= -1
        SGRP= 29
        CALL PMXTXT (MESSFL,SCLU,SGRP,K,INIT)
      END IF
C
      RETURN
      END
