      SUBROUTINE QSUCPR
     I                  (MESSFL,SCLU,
     M                   QTITLE,BNAME,NUMRCH,NUMHDW,NUMPTL,
     M                   NUMJUN,METFLG,LCMPEL,IRET)
C
C     + + + PURPOSE + + +
C     set up control parameters
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,NUMRCH,NUMHDW,NUMPTL,NUMJUN,METFLG,IRET
      REAL        LCMPEL
      CHARACTER*1 QTITLE(59),BNAME(59)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     SCLU   - cluster number on message file
C     QTITLE - title for this run
C     BNAME  - basin name
C     NUMRCH - number of reaches
C     NUMHDW - number of headwaters
C     NUMPTL - number of point loads
C     NUMJUN - number of junctions
C     METFLG - input metric units flag (0 - no, 1 - yes)
C     LCMPEL - length of computational element
C     IRET   - user's exit command from full screen
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I1,SGRP,INUM,RNUM,CNUM,TLEN,IVAL(3,1),CVAL(3,3,1)
      REAL        RVAL(1,1)
      DOUBLE PRECISION DVAL(1,1)
      CHARACTER*1 TBUFF(150),BLNK
C
C     + + + EXTERNALS + + +
      EXTERNAL    ZIPC, QRESCZ, ZGTRET, CHRCHR
C
C     + + + END SPECIFICATIONS + + +
C
      I1  = 1
      BLNK= ' '
      TLEN= 150
      CALL ZIPC (TLEN,BLNK,TBUFF)
C     put current values in buffer
      TLEN= 59
      CALL CHRCHR (TLEN,QTITLE,TBUFF)
      CALL CHRCHR (TLEN,BNAME,TBUFF(60))
      IVAL(1,1)= NUMRCH
      IVAL(2,1)= NUMHDW
      IVAL(3,1)= NUMPTL 
      IF (METFLG.EQ.0) THEN
        CVAL(3,1,1)= 2
      ELSE
        CVAL(3,1,1)= METFLG
      END IF
      RVAL(1,1)= LCMPEL 
      TLEN= 150
      INUM= 3
      RNUM= 1
      CNUM= 3
      SGRP= 1
      CALL QRESCZ (MESSFL,SCLU,SGRP,INUM,RNUM,I1,CNUM,I1,I1,TLEN,
     M             IVAL,RVAL,DVAL,CVAL,TBUFF)
C     get user exit value
      CALL ZGTRET (IRET)
      IF (IRET.EQ.2) THEN
C       user selected previous screen
      ELSE
C       put values into variables
        TLEN= 59
C       title and basin name
        CALL CHRCHR (TLEN,TBUFF,QTITLE)
        CALL CHRCHR (TLEN,TBUFF(60),BNAME)
C       number of reaches, headwaters, point loads
        NUMRCH= IVAL(1,1)
        NUMHDW= IVAL(2,1)
        NUMPTL= IVAL(3,1)
C       number of junctions is number hdwtrs- 1
        NUMJUN= NUMHDW- 1
C       set metric units flag
        IF (CVAL(3,1,1).EQ.1) THEN
C         yes, input metric units
          METFLG= 1
        ELSE
C         no, use English units
          METFLG= 0
        END IF
C       set length of computational element
        LCMPEL= RVAL(1,1)
      END IF
C
      RETURN
      END
