      SUBROUTINE QSUHDW 
     I                  (MESSFL,SCLU,NUMHDW,
     M                   HDWNAM,IRET)
C
C     + + + PURPOSE + + +
C     set up headwater data
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,NUMHDW,IRET
      CHARACTER*1 HDWNAM(16,NUMHDW)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     SCLU   - cluster number on message file
C     NUMHDW - number of headwaters
C     HDWNAM - array of headwater names
C     IRET   - user's exit command from full screen
C
C     + + + LOCAL VARIABLES + + +
C-DWD
C-DWD ##### Begin change ############################
C-DWD Date: Monday, 28 October 1991.  Time: 07:41:15.
C-DWD -----------------------------------------------
C-DWD Modified parameter values to match QUAL2E MAIN.VAR file.
C-DWD
      INTEGER     I,I1,SGRP,TLEN,RNUM,CNUM,IVAL(1,20),CVAL(1,3,20)
      REAL        RVAL(1,20)
      DOUBLE PRECISION DVAL(1,20)
      CHARACTER*1 SCHRBF(22,20),BLNK
C      INTEGER     I,I1,SGRP,TLEN,RNUM,CNUM,IVAL(1,10),CVAL(1,3,10)
C      REAL        RVAL(1,10)
C      DOUBLE PRECISION DVAL(1,10)
C      CHARACTER*1 SCHRBF(22,10),BLNK
C-DWD
C-DWD ##### End change ##############################
C
C     + + + EXTERNALS + + +
      EXTERNAL    CHRCHR, QRESCZ, ZGTRET, ZIPC
C
C     + + + END SPECIFICATIONS + + +
C
      I1  = 1
      BLNK= ' '
C
C     init buffer
      TLEN= 22* NUMHDW
      CALL ZIPC (TLEN,BLNK,SCHRBF)
C     put current headwater order numbers and names in buffer
      DO 10 I= 1,NUMHDW
        RVAL(1,I)= I
        TLEN= 16
        CALL CHRCHR(TLEN,HDWNAM(1,I),SCHRBF(7,I))
 10   CONTINUE
      TLEN= 22
      RNUM= 1
      CNUM= 1
      SGRP= 11
      CALL QRESCZ (MESSFL,SCLU,SGRP,I1,RNUM,I1,CNUM,NUMHDW,I1,TLEN,
     M             IVAL,RVAL,DVAL,CVAL,SCHRBF)
C     get user exit command
      CALL ZGTRET(IRET) 
C     get headwater names from buffer
      TLEN= 16
      DO 20 I= 1, NUMHDW
        CALL CHRCHR(TLEN,SCHRBF(7,I),HDWNAM(1,I))
 20   CONTINUE
C
      RETURN
      END
