      SUBROUTINE QSUPTL 
     I                  (MESSFL,SCLU,NUMPTL,NUMRCH,DAT2,
     I                   NCMPEL,CMPELF,LCMPEL,METFLG,
     M                   PTLNAM,IRET)
C
C     + + + PURPOSE + + +
C     set up point load data
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,NUMPTL,NUMRCH,NCMPEL(NUMRCH),
     1            CMPELF(20,NUMRCH),METFLG,IRET
      REAL        DAT2(3,NUMRCH),LCMPEL
      CHARACTER*1 PTLNAM(12,NUMPTL)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     SCLU   - cluster number on message file
C     NUMPTL - number of point loads
C     NUMRCH - number of reaches
C     DAT2   - array containing river miles for head and end of reaches
C     NCMPEL - number of computational elements in each reach
C     CMPELF - array of computational elements for each reach
C     LCMPEL - length of computational element
C     METFLG - metric units flag
C     PTLNAM - point load name/identifier
C     IRET   - user exit command from full screen
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,I0,I1,J,K,SGRP,RNUM,CNUM,LEN,JUST,NMFLDS,
     1            IVAL(1,1),IDUM(1),UCCNT(4),UCDEF(2),ERRFLG,
     2            VLINFG(4),USTRLN(4),TMPPTC(2,3,200)
C     2            VLINFG(4),USTRLN(4),TMPPTC(2,3,50)
      REAL        TMPPTL(2,200),URMIN(2),URMAX(2),URDEF(2),RTMP(4)
C      REAL        TMPPTL(2,50),URMIN(2),URMAX(2),URDEF(2),RTMP(4)
      DOUBLE PRECISION DDUM(1)
      CHARACTER*1 UCSTR(80),SCHRBF(80,200),BLNK
C      CHARACTER*1 UCSTR(80),SCHRBF(80,50),BLNK
C
C     + + + INTRINSICS + + +
      INTRINSIC   INT
C
C     + + + EXTERNALS + + +
      EXTERNAL    ZIPR, ZIPI, ZIPC, GETTXT, QSCSET, QRESCX
      EXTERNAL    PMXTXR, PRNTXI, CHRCHR, DECCHR, ZGTRET
C
C     + + + END SPECIFICATIONS + + +
C
      I0  = 0
      I1  = 1
      JUST= 0
      BLNK= ' '
C
C     comp elem now calc with form 5, only need loc of pl/wi
      RTMP(1)= -999
      CALL ZIPR(NUMPTL*2,RTMP(1),TMPPTL)
      I= 1
      CALL ZIPI(NUMPTL*6,I,TMPPTC)
      CALL ZIPC(NUMPTL*80,BLNK,SCHRBF)
      K= 0
      DO 20 I= 1,NUMRCH
        DO 10 J= 1,NCMPEL(I)
          IF (CMPELF(J,I).EQ.6.OR.CMPELF(J,I).EQ.7) THEN
            K= K+ 1
            TMPPTL(1,K)= I
            TMPPTL(2,K)= DAT2(3,I)+ (NCMPEL(I)-J)*LCMPEL
            TMPPTC(2,1,K)= CMPELF(J,I)- 5
          END IF
 10     CONTINUE
 20   CONTINUE
      NMFLDS   = 4
      IDUM(1)  = 0
      DDUM(1)  = 0.
      URMIN(1) = 1
      URMAX(1) = NUMRCH
      URDEF(1) = -999.
      URMIN(2) = 0.
      URMAX(2) = DAT2(2,1)
      URDEF(2) = -999.
      VLINFG(1)= 0
      VLINFG(2)= 1
      VLINFG(3)= 0
      VLINFG(4)= 0
      UCCNT(1) = 0
      UCCNT(2) = 2
      UCCNT(3) = 0
      UCCNT(4) = 0
      UCDEF(1) = 0
      UCDEF(2) = 1
      USTRLN(1)= 0
      USTRLN(2)= 10
      USTRLN(3)= 0
      USTRLN(4)= 0
      SGRP= 18
      I   = 20
      CALL GETTXT (MESSFL,SCLU,SGRP,I,UCSTR)
      RNUM= 2
      CNUM= 2
      CALL QSCSET (I1,RNUM,I1,CNUM,NMFLDS,IDUM,IDUM,IDUM,
     I             URMIN,URMAX,URDEF,DDUM,DDUM,DDUM,
     I             VLINFG,UCCNT,UCDEF,USTRLN,UCSTR)
 30   CONTINUE
        DO 50 I= 1,NUMRCH
C         set any current loads to normal elements
          DO 40 J= 1,NCMPEL(I)
            IF (CMPELF(J,I).EQ.6.OR.CMPELF(J,I).EQ.7)
     1                                    CMPELF(J,I)= 2
  40      CONTINUE
  50    CONTINUE
        DO 55 I= 1,NUMPTL
C         put current data in buffer
          LEN= 12
          CALL CHRCHR (LEN,PTLNAM(1,I),SCHRBF(1,I))
          LEN= 6
          CALL DECCHR (TMPPTL(1,I),LEN,JUST,J,SCHRBF(23,I))
          CALL DECCHR (TMPPTL(2,I),LEN,JUST,J,SCHRBF(29,I))
 55     CONTINUE
        RNUM= 2
        SGRP= 14+ METFLG
        CALL QRESCX (MESSFL,SCLU,SGRP,I1,RNUM,CNUM,NUMPTL,I1,
     M               IVAL,TMPPTL,TMPPTC,SCHRBF)
C       get user exit command
        CALL ZGTRET(IRET)
        IF (IRET.EQ.1) THEN
C         user selected next, check to make sure point-loads make sense
          ERRFLG= 0
C         move point load/withdrawals to cmp el flags
          DO 60 I= 1, NUMPTL
C           get load name from buffer
            LEN= 12
            CALL CHRCHR (LEN,SCHRBF(1,I),PTLNAM(1,I))
C           set comp elements based on load locations entered
            J= TMPPTL(1,I)
            IF (TMPPTL(2,I).GT.DAT2(2,J).OR.
     1          TMPPTL(2,I).LT.DAT2(3,J)) THEN
C             river mile not in reach
              RNUM= 4
              RTMP(1)= TMPPTL(1,I)
              RTMP(2)= TMPPTL(2,I)
              RTMP(3)= DAT2(2,J)
              RTMP(4)= DAT2(3,J)
              SGRP= 16
              CALL PMXTXR (MESSFL,SCLU,SGRP,I1,I1,I0,RNUM,RTMP)
              ERRFLG= 1
            ELSE
C             which computation element
              K= NCMPEL(J)- INT((TMPPTL(2,I)-DAT2(3,J))/ LCMPEL)
              IF (K.EQ.0 .AND. J.GT.1) THEN
C               river mile at reach boundary, needs to be in previous reach
                RNUM= 4
                RTMP(1)= I
                RTMP(2)= J
                RTMP(3)= J-1
                RTMP(4)= J-1
                SGRP= 30
                CALL PMXTXR (MESSFL,SCLU,SGRP,I1,I1,I0,RNUM,RTMP)
                ERRFLG= 1
              ELSE IF (CMPELF(K,J).EQ.2) THEN
C               good spot for it
                CMPELF(K,J)= TMPPTC(2,1,I)+ 5
              ELSE
C               this element already in use
                SGRP= 17
                CALL PRNTXI (MESSFL,SCLU,SGRP,I)
                ERRFLG= 1
              END IF
            END IF
 60       CONTINUE
        END IF
      IF (ERRFLG.NE.0 .AND. IRET.EQ.1) GO TO 30
C
      RETURN
      END
