      PROGRAM QUAL2
C
C     + + + PURPOSE + + +
C    QUAL2E and QUAL2EU interactive data pre-processor program.
C    An AIDE appplication.
C
C     + + +   COMMON BLOCKS   + + +
      INCLUDE 'CQ2VAL.INC'
      INCLUDE 'AQUTIL.INC'
C
C     + + + PARAMETERS + + +
      INCLUDE 'PMESFL.INC'
C
C     + + +  LOCAL VARIABLES  + + +
      INTEGER      I,I0,I1,LEN,SGRP,SCLU,RESP,MXLIN,INIT,IWRT,
     1             FILFG,OUTFL,INPFL,IRET,RETCOD,SCNINI,CNUM,
     2             PARNUM,USRLEV,LINCNT
      INTEGER      VERLEN(1)
      CHARACTER*1  AQUVER(4)
      CHARACTER*1  NWFBUF(11),BLNK
      CHARACTER*8  APPNAM
      CHARACTER*64 FLNAME
      CHARACTER*78 STBUFF,CRBUFF,WNNAME
C
C     + + + EQUIVALENCES + + +
      EQUIVALENCE (STBUFF,STBUF1),(FLNAME,FLNAM1),(CRBUFF,CRBUF1)
      CHARACTER*1  STBUF1(78),FLNAM1(64),CRBUF1(78)
C
C     + + + FUNCTIONS + + +
      INTEGER      LENSTR
C
C     + + + EXTERNALS + + +
      EXTERNAL LENSTR, ANINIT, AQ2REA, AQ2INI, AQ2WRT, PMXCNW
      EXTERNAL ZMNSST, QRESP, CHRCHR, ZSTADD, QFOPEN,  PRNTXT, ZIPC
      EXTERNAL ANCLOS, QSETUP, QEDIT, GETTXT, SETMET, ZBLDWR, ZQUIET
      EXTERNAL ZSTCMA, ZGTRET, QFILES, PMXTXA, ZANSET, ANPRGT, ZWNSET
      EXTERNAL Q1INIT, QSETFN, Q1EDIT, QGETF
C
C     + + + DATA INITIALIZATIONS + + +
      DATA NWFBUF/'a',' ','n','e','w',' ','f','i','l','e','.'/
      DATA STBUFF/'Currently editing '/
      DATA APPNAM / ' AQUAL2 ' /
      DATA VERLEN(1) / 4 /
      DATA AQUVER / '1','.','2','3' /
C
C     + + + END SPECIFICATIONS + + +
C
C    Initialize environment.
      CALL ANINIT (MESSFL)
      CALL ZANSET (APPNAM)
      I0=0
      I1=1
      BLNK=' '
      PARNUM=45
      USRLEV=0
      FILFG=0
      SCNINI=1
      LINCNT=0
      CNUM = 1
      DO 2 I=1,4
    2    CHGFLG(I) = 'N'
C
C    Set message file screen cluster.
      SCLU= 5
C
C    Retreive the value of the user level parameter (USRLEV) from
C    the TERM.DAT file.
C
      CALL ANPRGT (PARNUM, USRLEV)
C
C    If user level is equal to a value of 0, then the user has       
C    experience using the AQUAL2 program.  Therefore, do not display
C    the temporary opening welcome sceeen when the program is started.
C    
      IF (USRLEV.EQ.0) GO TO 5
C
      WNNAME = 'Information (I): 1 of 4'
      CALL ZWNSET (WNNAME)
C
C 1 - Display the AQUAL2 program opening welcome and information screen.
C
 3    CONTINUE
C
C    Make 'PREV' option available.
      I= 4
      CALL ZSTCMA (I,I1)
C    Make 'INTRPT' option available.
      I= 16
      CALL ZSTCMA (I,I1)
C
C    Display the opening welcome and information screens when program
C    is started.  Set cluster and group number for message file.  A
C    value of 0 for IWRT writes text to the screen then waits for user
C    to press NEXT <F2> key to continue screen displays and eventual
C    program execution.
C
      SGRP = 18
      IWRT = 0
      MXLIN= 16
C
C    Present welcome and information screens with
C    1 - AQUAL2 version number and date of release
C    2 - QUAL2EU model system abstract
C    3 - Address and telephone information for support
C    4 - Address and telephone information for further information
C
      CALL PMXTXA (MESSFL,SCLU,SGRP,MXLIN,SCNINI,IWRT,CNUM,
     1             VERLEN,AQUVER)
      CALL ZGTRET(IRET)
      IF (IRET.EQ.2.OR.IRET.EQ.7) GO TO 4
      SGRP = 19
      CALL PMXCNW (MESSFL,SCLU,SGRP,MXLIN,SCNINI,IWRT,LINCNT)
      CALL ZGTRET(IRET)
      IF (IRET.EQ.2.OR.IRET.EQ.7) GO TO 4
      SGRP = 20
      CALL PMXCNW (MESSFL,SCLU,SGRP,MXLIN,SCNINI,IWRT,LINCNT)
      CALL ZGTRET(IRET)
      IF (IRET.EQ.2.OR.IRET.EQ.7) GO TO 4
      SGRP = 21
      CALL PMXCNW (MESSFL,SCLU,SGRP,MXLIN,SCNINI,IWRT,LINCNT)
C
 4    CONTINUE
C    Make 'PREV' option unavailable.
      I= 4
      CALL ZSTCMA (I,I0)
C    Make 'INTRPT' option unavailable.
      I= 16
      CALL ZSTCMA (I,I0)
C
      RESP = 2
C
C    Primary processing loop (create, modify, write, etc.) starts with
C    the following 5 CONTINUE statement.
C
 5    CONTINUE
C
C    Make 'PREV' option unavailable.
      I= 4
      CALL ZSTCMA (I,I0)
C
      SGRP= 2
C
C Label Determine option selected:
C   3   1 - Display the AQUAL2 program opening welcome screen
C  10   2 - Create (setup) and parameterize a new QUAL2E(U) data file
C  20   3 - Edit an existing data file
C  30   4 - Write the data entered/modified to a file
C  40   5 - Modify related data files
C  50   6 - Display AQUAL2 utility menu
C  60   7 - Execute AQUAL2 tutorial session
C  70   8 - End program and return to operating system command line
C
C    Set data window title and command option sequence.
C
      IF (USRLEV.EQ.0) THEN
          WNNAME = 'Main Option Menu'
          CALL ZWNSET (WNNAME)
      ENDIF
C
      CALL QRESP (MESSFL,SCLU,SGRP,RESP)
C
C    Make 'PREV' option available again.
      I= 4
      CALL ZSTCMA (I,I1)
C
C   If the user selected option 1 from the Main Option Menu, return
C   to statement 3 and display the opening welcome screen.
C
      GO TO (3,10,20,30,40,50,60,70),RESP
C
 10     CONTINUE
C     2 - Create (setup) and parameterize a new QUAL2E(U) data file
          IF (FILFG.EQ.1) THEN
C           file currently in memory, save before doing setup?
            SGRP= 7
            CALL QRESP (MESSFL,SCLU,SGRP,RESP)
            CALL ZGTRET(IRET)
            IF (RESP.EQ.2 .AND. IRET.EQ.1) FILFG= 0
          END IF
          IF (FILFG.NE.1) THEN
C           show creating new file in status window
            SGRP= 9
            I   = 78
            CALL GETTXT (MESSFL,SCLU,SGRP,I,CRBUF1)
            CALL ZSTADD (I1,CRBUFF)
C          Initialize parameters.
            CALL AQ2INI (MESSFL)
            CALL QSETUP (MESSFL,
     O                   IRET)
            IF (IRET.EQ.1) THEN
C             set file flag to indicate new file
              FILFG = 1
              FLNAME= ' '
              RESP  = RESP+ 1
C             inform user they're done w/SEtup, now go to Edit mode
              SGRP= 16
C             make 'prev' unavailable
              I= 4
              CALL ZSTCMA (I,I0)
              CALL PRNTXT (MESSFL,SCLU,SGRP)
C             adjust for metric units if needed
              IF (METFLG.EQ.1) CALL SETMET
            ELSE
C             not creating new file anymore, take status off
              CRBUFF= ' '
              CALL ZSTADD (I1,CRBUFF)
              CALL ZQUIET
            END IF
          END IF
          GO TO 100
C
 20     CONTINUE
C     3 - Edit an existing data file;
C         modify other parameters of input sequence
          RETCOD= 0
          IF (FILFG.EQ.1 .AND. FLNAME.NE.' ') THEN
C           file currently in memory, save before doing setup?
            SGRP= 10
            RESP= 1
            CALL QRESP (MESSFL,SCLU,SGRP,RESP)
            CALL ZGTRET(IRET)
            IF (RESP.EQ.1 .OR. IRET.EQ.2) THEN
C             dont do edit now
              RETCOD= 1
            ELSE
              FILFG= 0
            END IF
          END IF
          IF (FILFG.EQ.2) THEN
C           file saved in memory, want to use it
            I  = 60
            LEN= LENSTR(I,STBUF1(19))
            SGRP= 12
            CALL PMXTXA (MESSFL,SCLU,SGRP,I1,I1,-I1,I1,LEN,STBUF1(19))
            CALL ZMNSST
            SGRP= 11
            CALL QRESP (MESSFL,SCLU,SGRP,RESP)
            CALL ZGTRET(IRET)
            IF (IRET.EQ.2) THEN
C             user wants back to opening screen
              RETCOD= 1
            ELSE IF (RESP.EQ.1) THEN
C             yes, use this file
              FILFG= 1
            ELSE
C             no, need to get a new file name
              FILFG= 0
            END IF
          END IF
          IF (FILFG.EQ.0) THEN
C           get file to edit
            LEN= 60
            CALL ZIPC (LEN,BLNK,STBUF1(19))
            SGRP= 3
C           get screen information
            CALL Q1INIT (MESSFL,SCLU,SGRP)
C           clear file name
C            FLNAME=' '
C            CALL QSETFN (I1,FLNAME)
C           edit the screen
            CALL Q1EDIT (RETCOD)
C           get exit command value
            CALL ZGTRET (I)
            IF (RETCOD.EQ.1 .AND. I.EQ.1) THEN
              RETCOD= 0
C             get file unit number
              CALL QGETF (I1,INPFL)
C             initialize all data
              CALL AQ2INI (MESSFL)
C             put file info in memory
              CALL AQ2REA (MESSFL,INPFL)
C             get file name for status
              INQUIRE (INPFL,NAME=FLNAME)
              I= 64
              LEN= LENSTR(I,FLNAM1)
              CALL CHRCHR (LEN,FLNAM1,STBUF1(19))
C             put in status
              CALL ZSTADD (I1,STBUFF)
C             indicate file in memory, but not saved
              FILFG= 1
            END IF
          ELSE IF (FLNAME.EQ.' ') THEN
C           editing new file
            LEN= 11
            CALL CHRCHR (LEN,NWFBUF,STBUF1(19))
C           put in status
            CALL ZSTADD (I1,STBUFF)
          END IF
          IF (RETCOD.EQ.0) THEN
C           edit current data in memory
            CALL QEDIT (MESSFL)
          END IF
          GO TO 100
C
 30     CONTINUE
C     4 - Write the data entered/modified to a file; save input sequence
          IF (FILFG.EQ.1) THEN
            SGRP= 4
C           get screen information
            CALL Q1INIT (MESSFL,SCLU,SGRP)
C           set file name
C            FLNAME='INPUTDAT.FIL'
C            CALL QSETFN (I1,FLNAME)
C           edit the screen
            CALL Q1EDIT (RETCOD)
C           get exit command value
            CALL ZGTRET (IRET)
            IF (RETCOD.EQ.1 .AND. IRET.EQ.1) THEN
              RETCOD= 0
C             get file unit number
              CALL QGETF (I1,OUTFL)
C             output data to file
              CALL AQ2WRT (MESSFL,OUTFL)
C             indicate file has been saved and is in memory
              FILFG= 2
C             get file name for status
              INQUIRE (OUTFL,NAME=FLNAME)
              LEN= 60
              CALL ZIPC (LEN,BLNK,STBUF1(19))
              I= 64
              LEN= LENSTR(I,FLNAM1)
              CALL CHRCHR (LEN,FLNAM1,STBUF1(19))
C             put file name in status
              CALL ZSTADD (I1,STBUFF)
            END IF
          ELSE
C           nothing to save, let user know
            SGRP= 8
            CALL PRNTXT (MESSFL,SCLU,SGRP)
          END IF
          GO TO 100
C
C Date: Monday, 13 January 1992.  Time: 13:51:22.
C------------------------------------------------
C Show option remove as per TOB.
C
C 40     CONTINUE
C         display results, not available
C          SGRP= 5
C          CALL PRNTXT (MESSFL,SCLU,SGRP)
C          GO TO 100
C
 40      CONTINUE
C      5 - Modify related data files
           CALL QFILES (MESSFL,FLNAME)
           GO TO 100
C
 50      CONTINUE
C    6 - Display AQUAL2 utility menu
C
         CALL AQUTIL (MESSFL)
         GO TO 100
C
C
 60   CONTINUE
C 7 - Execute AQUAL2 tutorial session
C
C    User has selected option to display instructions on
C    how to execute a tutorial session.  Set screen cluster
C    and group then display the text screen without waiting
C    for a user response.  Also, set the default option to
C    be 2 (Create a file) when the Main Option Menu is
C    redisplayed after this screen or execution of the
C    tutorial.
C
      SGRP = 17
      IWRT = 0
      MXLIN = 10
C
      CALL PMXCNW (
     I             MESSFL,SCLU,SGRP,MXLIN,SCNINI,IWRT,
     O             LINCNT)
C     
      RESP = 2
      GO TO 100
C
 70      CONTINUE
C         all done, is everything saved?
          IF (FILFG.EQ.1) THEN
C           let user know files unsaved and verify exit
            SGRP= 6
            CALL QRESP (MESSFL,SCLU,SGRP,RESP)
            CALL ZGTRET(IRET)
            IF (RESP.EQ.1 .OR. IRET.EQ.2) THEN
C             dont exit, go back and save
              RESP= 4
            ELSE
C             want to exit no matter what
              RESP= 8
            END IF
          END IF
C
 100    CONTINUE
C
      IF (RESP.NE.8) GO TO 5
C
      CALL ANCLOS (MESSFL)
C
      STOP
      END
