      SUBROUTINE UNCREA (MESSFL,SCLU,UNCFIL,
     M                   RETCOD)
C
C     + + + PURPOSE + + +
C     routine to read old UNCAS file into UNCAS common block
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,UNCFIL,RETCOD
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SCLU   - screen cluster number on message file
C     UNCFIL - unit number for UNCAS file
C     RETCOD - return code
C
C     + + + COMMON BLOCK + + +
      INCLUDE 'CUNCAS.INC'
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,J,K,I80,DONFG,LEN,SGRP,NANS,LANS,
     1            TLEN,ULEN,RESP,CRESP
      CHARACTER*1 BLNK,RDBUFF(80),IBUFF(27)
C
C     + + + FUNCTIONS + + +
      INTEGER     CHRINT
      REAL        CHRDEC
C
C     + + + EXTERNALS + + +
      EXTERNAL   ZIPC, CHRINT, CHRDEC, CHRCHR, PRNTXI
      EXTERNAL   CHKANQ, ZIPI
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT (80A1)
 1010 FORMAT (30X,50A1)
 1020 FORMAT (24X,3(6X,9A1))
 1030 FORMAT (30X,5(2X,I3,I3))
 1040 FORMAT (48X,8A1,1X,F6.0)
C
C     + + + END SPECIFICATIONS + + +
C
      I80 = 80
      BLNK= ' '
C
C     dummy read for heading
      RETCOD= 1
      READ (UNCFIL,1000,ERR=900) RDBUFF
C
C     read UNCAS title
      RETCOD= 2
      READ (UNCFIL,1010,ERR=900) UNCTTL
C
C     read uncertainty option
      CALL ZIPC (I80,BLNK,RDBUFF)
      RETCOD= 3
      READ (UNCFIL,1000,ERR= 900) RDBUFF
      IF (RDBUFF(31).EQ.'S') THEN
C       Sensitivity analysis
        UNCOPT= 1
      ELSE IF (RDBUFF(31).EQ.'F') THEN
C       First order error analysis
        UNCOPT= 2
        LEN= 6
        PERTRB= CHRDEC(LEN,RDBUFF(59))
      ELSE
C       Monte carlo simulation
        UNCOPT= 3
        LEN= 6
        NMSIMS= CHRINT(LEN,RDBUFF(59))
      END IF
C
C     read input condition
      CALL ZIPC (I80,BLNK,RDBUFF)
      RETCOD= 4
      READ (UNCFIL,1000,ERR=900) RDBUFF
      IF (RDBUFF(31).EQ.'S') THEN
C       Single/multiple perturbations
        INPCND= 1
      ELSE IF (RDBUFF(31).EQ.'2') THEN
C       2-level factorial design
        INPCND= 2
        LEN= 1
        NUMVAR= CHRINT(LEN,RDBUFF(63))
      ELSE IF (RDBUFF(31).EQ.'G') THEN
C       Generic groups
        INPCND= 4
        I= 7
        J= 2
        CALL ZIPI (I,J,IGNGRP)
        LEN= 4
        NANS= 7
        LANS= 4
        TLEN= NANS*LANS
        ULEN= 4
        DO 10 I= 1,7
          CALL CHRCHR (LEN,RDBUFF(42+I*5),IBUFF)
          CALL CHKANQ (NANS,LANS,ULEN,TLEN,GGBUFF,IBUFF,
     M                 RESP,CRESP)
          IF (RESP.GT.0.AND.CRESP.EQ.0) THEN
C           valid Generic group, turn on YES for this group
            IGNGRP(RESP)= 1
          END IF
 10     CONTINUE
      ELSE
C       All inputs
        INPCND= 3
      END IF
C
C     read intermediate output
      CALL ZIPC (I80,BLNK,RDBUFF)
      RETCOD= 5
      READ (UNCFIL,1000,ERR=900) RDBUFF
      IF (RDBUFF(31).EQ.'N') THEN
C       None
        INTOUT= 1
      ELSE IF (RDBUFF(31).EQ.'C') THEN
C       Complete QAUL2E final summary
        INTOUT= 2
      ELSE
C       Limited
        INTOUT= 3
      END IF
C
C     read output variables
      RETCOD= 6
      ULEN  = 9
      NANS  = 3
      LANS  = 9
      TLEN  = NANS*LANS
      IOUTVR(2)= 2
      READ (UNCFIL,1020,ERR=900) IBUFF
      DO 15 I= 1,3
        CALL CHKANQ (NANS,LANS,ULEN,TLEN,OVBUFF,IBUFF((I-1)*9+1),
     M               RESP,CRESP)
        IF (RESP.GT.0.AND.CRESP.EQ.0) THEN
C         valid Output Variable, turn on YES for this variable
          IOUTVR(RESP)= 1
        END IF
 15   CONTINUE
C
C     read output locations
      RETCOD= 7
      READ (UNCFIL,1030,ERR=900) (OUTLCS(I),I=1,10)
C
      IF (UNCOPT.EQ.1) THEN
C       read input variables
        DONFG = 0
        RETCOD= 8
        VRCNT(1)= 1
        NMSENS  = 0
 20     CONTINUE
          CALL ZIPC (I80,BLNK,RDBUFF)
          READ (UNCFIL,1000,ERR=900) RDBUFF
          IF (RDBUFF(31).NE.'E') THEN
C           not at end of file - continue filling common
            NMSENS= NMSENS+ 1
            IF (NMSENS.GT.1)
     1        VRCNT(NMSENS)= VRCNT(NMSENS-1)+NMINVR(NMSENS-1)
            IF (RDBUFF(31).EQ.'S') THEN
C             Single
              INVRTP(NMSENS)= 1
            ELSE IF (RDBUFF(31).EQ.'M') THEN
C             Multiple
              INVRTP(NMSENS)= 2
            ELSE
C             Factorial
              INVRTP(NMSENS)= 3
            END IF
            LEN= 1
            NMINVR(NMSENS)= CHRINT(LEN,RDBUFF(45))
            LEN= 8
            CALL CHRCHR (LEN,RDBUFF(49),VARCOD(1,VRCNT(NMSENS)))
            LEN= 6
            PRCPRT(VRCNT(NMSENS))= CHRDEC(LEN,RDBUFF(58))
            IF (NMINVR(NMSENS).GT.1) THEN
C             put in remaining number of variables
              DO 30 J= 2,NMINVR(NMSENS)
                READ (UNCFIL,1040,ERR=900)
     1            (VARCOD(K,VRCNT(NMSENS)+(J-1)),K=1,8),
     2            PRCPRT(VRCNT(NMSENS)+(J-1))
 30           CONTINUE
            END IF
          ELSE
C           end of file found
            DONFG= 1
          END IF
        IF (DONFG.NE.1) GO TO 20
      END IF
C
      RETCOD= 0
      GO TO 950
C
 900  CONTINUE
      SGRP= 18
      CALL PRNTXI (MESSFL,SCLU,SGRP,RETCOD)
      BACKSPACE UNCFIL
      READ (UNCFIL,1000) RDBUFF
      J= 80
C     CALL PRTSCR (J,RDBUFF)
C
 950  CONTINUE
C
      RETURN
      END
