      SUBROUTINE UNCWRT (MESSFL,SCLU,UNCFIL)
C
C     + + + PURPOSE + + +
C     routine to write out UNCAS file
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,UNCFIL
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SCLU   - screen cluster number on message file
C     UNCFIL - unit number for UNCAS file
C
C     + + + COMMON BLOCK + + +
      INCLUDE 'CUNCAS.INC'
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,I80,SGRP,LEN,L,J,K,JUST
      CHARACTER*1 TBUFF(80),BLNK
C
C     + + + FUNCTIONS + + +
      INTEGER     LENSTR
C
C     + + + EXTERNALS + + +
      EXTERNAL   GETTXT, ZIPC, LENSTR, CHRCHR, DECCHR, INTCHR
C
C     + + + INPUT FORMATS + + +
 2000 FORMAT (80A1)
C
C     + + + END SPECIFICATIONS + + +
C
      I80 = 80
      BLNK= ' '
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write heading
      LEN = I80
      SGRP= 20
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write title
      LEN = I80
      SGRP= 21
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      L= 50
      CALL CHRCHR (L,UNCTTL,TBUFF(31))
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write uncertainty option
      LEN = I80
      SGRP= UNCOPT+ 21
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      IF (UNCOPT.EQ.2) THEN
C       1st order error analysis
        L= 6
        JUST= 0
        CALL DECCHR (PERTRB,L,JUST,K,TBUFF(59))
      ELSE IF (UNCOPT.EQ.3) THEN
C       monte carlo simulation
        L= 6
        JUST= 0
        CALL INTCHR (NMSIMS,L,JUST,K,TBUFF(59))
      END IF
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write input condition
      LEN = I80
      SGRP= INPCND+ 24
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      IF (INPCND.EQ.2) THEN
C       2-level factorial design
        L= 1
        JUST= 0
        CALL INTCHR (NUMVAR,L,JUST,K,TBUFF(63))
      ELSE IF (INPCND.EQ.4) THEN
C       generic groups
        L= 4
        J= 0
        DO 5 I= 1,7
          IF (IGNGRP(I).EQ.1) THEN
            J= J+ 1
            CALL CHRCHR (L,GGBUFF((I-1)*4+1),TBUFF(42+J*5))
          END IF
 5      CONTINUE
      END IF
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write intermediate output
      LEN = I80
      SGRP= INTOUT+ 28
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write output variables
      LEN = I80
      SGRP= 32
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      J= 0
      L= 9
      DO 10 I= 1,3
        IF (IOUTVR(I).EQ.1) THEN
          J= J+ 1
          CALL CHRCHR (L,OVBUFF((I-1)*9+1),TBUFF(16+J*15))
        END IF
 10   CONTINUE
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
C     write output locations
      LEN = I80
      SGRP= 33
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      L= 3
      JUST= 0
      DO 20 I= 1,10,2
        CALL INTCHR (OUTLCS(I),L,JUST,K,TBUFF(33+(I-1)*4))
        CALL INTCHR (OUTLCS(I+1),L,JUST,K,TBUFF(36+(I-1)*4))
 20   CONTINUE
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      CALL ZIPC (I80,BLNK,TBUFF)
C
      IF (UNCOPT.EQ.1) THEN
C       write input variables
        VRCNT(1)= 1
        DO 50 I= 1,NMSENS
          IF (I.GT.1) VRCNT(I)= VRCNT(I-1)+ NMINVR(I-1)
          SGRP= INVRTP(I)+ 33
          CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
          L   = 1
          JUST= 0
          CALL INTCHR (NMINVR(I),L,JUST,K,TBUFF(45))
          L= 8
          CALL CHRCHR (L,VARCOD(1,VRCNT(I)),TBUFF(49))
          L= 6
          CALL DECCHR (PRCPRT(VRCNT(I)),L,JUST,K,TBUFF(58))
          WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
          IF (NMINVR(I).GT.1) THEN
            DO 40 J= 2,NMINVR(I)
              K= 15
              CALL ZIPC (K,BLNK,TBUFF(49))
              L= 8
              CALL CHRCHR (L,VARCOD(1,VRCNT(I)+(J-1)),TBUFF(49))
              L= 6
              CALL DECCHR (PRCPRT(VRCNT(I)+(J-1)),L,JUST,K,TBUFF(58))
              WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 40         CONTINUE
          END IF
 50     CONTINUE
      END IF
C
C     write out ending card
      LEN = I80
      SGRP= 37
      CALL GETTXT (MESSFL,SCLU,SGRP,LEN,TBUFF)
      WRITE (UNCFIL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
      RETURN
      END
