      PROGRAM   Q2PLOT
C
C     + + + PURPOSE + + +
C     plot output from qual2e
C
C     + + + LOCAL VARIABLES + + +
      INTEGER       FE,MAXP,MAXLN,MESSFL,AXTYP(2),GSYMBL(6),GLNTYP(6),
     1              Q2FIL,I,J,K,L,M,N,CURP,DEVCOD,CLU,GRP,
     2              I1,MXLIN,POPT,LLOC,CNTPLT,CNTP(6),OBFLG,DONFLG,
     3              OBCNT,SIMCNT,OBINT(100,3),PLTNUM,IND,RETCOD,
     4              OBIND(3),NIND,ILEN(2),IVAL(7),CVAL(3,3),
     5              INUM,RNUM,CNUM,XIND,YIND(6)
      INTEGER       II,GRAPHS,DEVTYP,INDEX,IPNT,I0,IRET,I80,JUST,
     1              LENOUT,CLEN,PRTFLG,TDATFL,IOSTAT,I64,RTCOD
      INTEGER*2     PRNTYP,LEN2
      INTEGER*4     IVALX(1),CVALX(1,3)
      REAL          YPT(2000,6),XPT(2000,6),RVAL
      REAL*4        RVALX(1)
      LOGICAL       NEWFIL
      CHARACTER*1   TITL1(240),YLAB1(80),XLAB1(80),CLAB1(20,6),
     *              TBUFF(80),BLANK
      CHARACTER*1   FLNAME(64)
      CHARACTER*2   PRNCHR
      CHARACTER*3   OBNAM(12)
      CHARACTER*64  OBREC
      CHARACTER*8   APPNAM
      CHARACTER*80  TBUFFT
      CHARACTER*40  PRNDES(20)
C
      CHARACTER*13  CTITL(85)
      REAL          Q2OUT(2000,85),OBDAT(1000,4)
C
C     + + + EQUIVALENCE + + +
      EQUIVALENCE (TITL1,TITL),(YLAB1,YLAB),(XLAB1,XLAB),(CLAB1,CLAB)
      EQUIVALENCE (TBUFF,TBUFFT)
      CHARACTER*20  CLAB(6)
      CHARACTER*80  YLAB,XLAB
      CHARACTER*240 TITL
C
C     + + + EXTERNALS + + +
      EXTERNAL  ANINIT,GPOPEN,GPCLOS,GPINIT,QFOPEN,ZGTRET
      EXTERNAL  ANCLOS,PRNUPD,QRESPM,ZIPI,PRNTXT,ZANSET
      EXTERNAL  ANPRGT,QRESPI,ZSTCMA,INTCHR,ZIPC,QFOPFN
      EXTERNAL  Q1INIT, QSETFN, Q1EDIT, QGETF
C
C     + + + INPUT FORMATS + + +
1000  FORMAT (A64)
1010  FORMAT (21X,A59)
1020  FORMAT (A40)
1030  FORMAT (9(10A13/))
1040  FORMAT (I6)
1050  FORMAT (9(10E13.5/))
1060  FORMAT (10X,4F10.2)
C
C     + + + OUTPUT FORMATS + + +
2000  FORMAT (1X,A60)
2010  FORMAT (1X,' plot ',7(2X,A13))
2020  FORMAT (1X,I5,7(3X,F12.3))
2030  FORMAT (1X,3I5,4F10.2)
C
3000  FORMAT (1X,'charset   = simplexr.chr')
3010  FORMAT (1X,'symbolset = computer.smb')
3020  FORMAT (1X,'plotter   = 1')
3030  FORMAT (1X,'printer   = ',I2)
3040  FORMAT ('Dummy INTERACTER initialisation file. See User Guide Appe
     1ndix C for more info.')
C
C     + + + END SPECIFCATIONS + + +
C
      DATA PRNDES/'Unspecified text-only printer           ',
     1            'IBM Graphics printer (80 columns)       ',
     2            'Panasonic KX-P1081                      ',
     3            'Amstrad DMP 3000                        ',
     4            'Epson FX type (80 columns)              ',
     5            'Epson FX type (wide carriage)           ',
     6            'Epson MX type (80 columns)              ',
     7            'Epson MX type (wide carriage)           ',
     8            'Shinwa CP80                             ',
     9            'HP Laserjet +                           ',
     A            'HP Laserjet II                          ',
     B            'IBM Graphics printer (wide carriage)    ',
     C            'HP Paintjet                             ',
     D            'HP Deskjet                              ',
     E            'IBM Proprinter (80 columns)             ',
     F            'IBM Proprinter (wide carriage)          ',
     G            'Epson LQ type (80 columns)              ',
     H            'Epson LQ type (wide carriage)           ',
     I            'IBM Proprinter X24 (80 columns)         ',
     J            'IBM Proprinter X24 (wide carriage)      '/
C
      DATA PRNTYP/11/
C
C     Clear the INTERACT.INI file name buffer.
      I64 = 64
      CALL ZIPC
     I          (I64,BLANK,
     O                     FLNAME)         
C
C     Load terminal definition file name.
      FLNAME(1)  = 'I'
      FLNAME(2)  = 'N'
      FLNAME(3)  = 'T'
      FLNAME(4)  = 'E'
      FLNAME(5)  = 'R'
      FLNAME(6)  = 'A'
      FLNAME(7)  = 'C'
      FLNAME(8)  = 'T'
      FLNAME(9)  = '.'
      FLNAME(10) = 'I'
      FLNAME(11) = 'N'
      FLNAME(12) = 'I'
      NEWFIL = .FALSE.
      TDATFL = 0
      PRTFLG = 0
      JUST   = 0
      I80    = 80
      LEN2   = 2
      BLANK  = ' '
      APPNAM = ' Q2PLOT '
      MAXLIN = 10
      SCNINI = 1
      IWRT = 0
      write (*,*) 'initialize annie'
      MESSFL= 9
      CALL ANINIT(MESSFL)
      CALL ZANSET(APPNAM)
C
      FE= 99
      OPEN(UNIT=FE,FILE='ERROR.FIL',STATUS='UNKNOWN')
C
      II = 16
      CALL ANPRGT (II,GRAPHS)
      IF (GRAPHS.EQ.1) THEN
        write (FE,*) 'about to open gks'
        CALL GPOPEN(FE)
        write (FE,*) 'just opened gks'
      ELSE
        write (FE,*) 'no graphics available'
      END IF
C
C      write (99,*) 'about to open GKS'
C      CALL GPOPEN(FE)
C      write (99,*) 'just opened gks'
C
      I0    = 0
      I1    = 1
      MXLIN = 50
      RTCOD= 0
      RETCOD= 0
      OBNAM(1) = 'DO '
      OBNAM(2) = 'BOD'
      OBNAM(3) = 'NO3'
      OBNAM(4) = 'NH3'
      OBNAM(5) = 'NSU'
      OBNAM(6) = 'NOR'
      OBNAM(7) = 'PDS'
      OBNAM(8) = 'POR'
      OBNAM(9) = 'CHR'
      OBNAM(10)= 'EXT'
C
C     open qual2 output file
      CLU= 22
      GRP= 1
C     get screen information
      CALL Q1INIT (MESSFL,CLU,GRP)
C     clear file name
C      FLNAME(1)=' '
C      CALL QSETFN (I1,FLNAME)
C     edit the screen
      CALL Q1EDIT (RETCOD)
C     determine return code
      CALL ZGTRET (I)
      IF (I.EQ.2 .OR. RETCOD.NE.1) THEN
C       user wants prev screen
        RETCOD= 2
      END IF
      IF (RETCOD.EQ.1)  THEN
        RETCOD= 0
C       get file unit number
        CALL QGETF (I1,Q2FIL)
C       read qual2 output file, titles first
        TITL= ' '
        READ(Q2FIL,1010) TITL(1:59)
        TITL(60:60)= '&'
        READ(Q2FIL,1010) TITL(61:119)
        TITL(120:120)= '&'
        READ(Q2FIL,1020) TITL(121:160)
        READ(Q2FIL,1030) CTITL
C
        CNTPLT = 0
        ILEN(1)= 4
        ILEN(2)= 4
        K= 1
 10     CONTINUE
          READ(Q2FIL,1040,END=15) I
          READ(Q2FIL,1050,END=15) (Q2OUT(I,J),J=1,85)
          IF (Q2OUT(I,4).GT.CNTPLT) THEN
C           another plot to draw
            CNTPLT= Q2OUT(I,4)
          END IF
          IVAL(1)= I
          IVAL(2)= CNTPLT
          GRP= 2
          CALL PRNUPD (MESSFL,CLU,GRP,K,ILEN,IVAL)
          K  = 2
        IF (I.LT.2000) GO TO 10
 15     CONTINUE
        MAXP= 2000
        CURP= I
C       close output data file
        CALL QFCLOS(Q2FIL,0)
      END IF
C
C     is observed data available
      OBCNT= 0
      GRP  = 7
      OBFLG= 1
      CALL QRESP (MESSFL,CLU,GRP,OBFLG)
      IF (OBFLG.EQ.1) THEN
C       open the observed data file
        GRP= 8
C       get screen information
        CALL Q1INIT (MESSFL,CLU,GRP)
C       clear file name
C       FLNAME(1)=' '
C       CALL QSETFN (I1,FLNAME)
C       edit the screen
        CALL Q1EDIT (RETCOD)
C       determine return code
        CALL ZGTRET (I)
        IF (I.EQ.2 .OR. RETCOD.NE.1) THEN
C         user wants prev screen
          RETCOD= 2
        END IF
        IF (RETCOD.EQ.1) THEN
          RETCOD= 0
C         get file unit number
          CALL QGETF (I1,Q2FIL)
C         read in the observed data
          READ(Q2FIL,1000)
          PLTNUM= 0
 20       CONTINUE
            READ (Q2FIL,1000,END=25) OBREC
            IF (OBREC(1:2).EQ.'NU') THEN
C             number of locs, a new plot
              PLTNUM= PLTNUM+ 1
            ELSE
C             a data record, what data type
              IND= 0
              IF (OBREC(1:3).EQ.OBNAM(1)) THEN
C               do
                IND = 40
                NIND= 1
              ELSE IF (OBREC(1:3).EQ.OBNAM(2)) THEN
C               bod
                IND = 41
                NIND= 2
              ELSE IF (OBREC(1:3).EQ.OBNAM(3)) THEN
C               nitrate
                IND = 45
                NIND= 3
              ELSE IF (OBREC(1:3).EQ.OBNAM(4)) THEN
C               ammonia
                IND = 43
                NIND= 4
              ELSE IF (OBREC(1:3).EQ.OBNAM(5)) THEN
C               sum nitrogen
                IND = 46
                NIND= 5
              ELSE IF (OBREC(1:3).EQ.OBNAM(6)) THEN
C               organic nitrogen
                IND = 42
                NIND= 6
              ELSE IF (OBREC(1:3).EQ.OBNAM(7)) THEN
C               dissolved phosphorus
                IND = 48
                NIND= 7
              ELSE IF (OBREC(1:3).EQ.OBNAM(8)) THEN
C               organic phosphorus
                IND = 47
                NIND= 8
              ELSE IF (OBREC(1:3).EQ.OBNAM(9)) THEN
C               chla
                IND = 59
                NIND= 9
              ELSE IF (OBREC(1:3).EQ.OBNAM(10)) THEN
C               lite extinction coef
                IND = 52
                NIND= 10
              END IF
C
              IF (IND.NE.0) THEN
C               something to plot that we know about
                OBCNT= OBCNT+ 1
                READ (OBREC,1060,ERR=24) (OBDAT(OBCNT,I),I=1,4)
 24             CONTINUE
                OBINT(OBCNT,1)= IND
                OBINT(OBCNT,2)= PLTNUM
                OBINT(OBCNT,3)= NIND
              END IF
            END IF
          IF (OBCNT.LT.100) GO TO 20
 25       CONTINUE
C         close obs data file
          CALL QFCLOS(Q2FIL,0)
C         write about the observed data we have
          WRITE (99,*) 'observed data:',OBCNT
          DO 26 I= 1,OBCNT
            WRITE (99,2030) (OBINT(I,J),J=1,3),(OBDAT(I,J),J=1,4)
 26       CONTINUE
        ELSE
C         no obs data available
          OBFLG= 2
        END IF
      END IF
C
      IF (RETCOD.EQ.0) THEN
C       default plot specs
        IF (GRAPHS.EQ.1) THEN
            DEVCOD   = 1
        ELSE
            DEVCOD   = 5
        ENDIF
C       move legend to 1-UR,2-LL,3-LR,0-UL
        LLOC     = 0
        AXTYP(1) = 1
        AXTYP(2) = 1
        GLNTYP(1)= 1
        GLNTYP(2)= 2
        GSYMBL(1)= 0
        GSYMBL(2)= 0
        YLAB     = 'mg/l'
        DONFLG   = 0
 29     CONTINUE
C         plot what
          POPT= 1
          GRP = 3
          CALL QRESP (MESSFL,CLU,GRP,POPT)
          write(99,*) 'popt:',popt
          IF (POPT.LE.6 .AND. DEVCOD.LE.4 .AND. GRAPHS.EQ.2) THEN
             GRP = 13
             CALL PRNTXT (MESSFL,CLU,GRP)
             GO TO 29
          ENDIF
          IF (POPT.LT.6) THEN
C           canned plot
            XIND = 5
            MAXLN= 2
            IF (POPT.EQ.1) THEN
C             do-bod
              YIND(1)= 40
              YIND(2)= 41
            ELSE IF (POPT.EQ.2) THEN
C             nitrate, ammonia
              YIND(1)= 45
              YIND(2)= 43
            ELSE IF (POPT.EQ.3) THEN
C             sum N, organic N
              YIND(1)= 46
              YIND(2)= 42
            ELSE IF (POPT.EQ.4) THEN
C             disolved P, organic P
              YIND(1)= 48
              YIND(2)= 47
            ELSE IF (POPT.EQ.5) THEN
C             chla, extinction coef
              YIND(1)= 59
              YIND(2)= 52
            END IF
            write(99,*) 'auto plot:',MAXLN,XIND,YIND
          ELSE IF (POPT.EQ.6) THEN
C           user specifies what to plot
            DO 30 I= 2,7
               IVAL(I)= YIND(I-1)
 30         CONTINUE
            IVAL(1)= XIND
            INUM= 7
            RNUM= 1
            CNUM= 1
            GRP = 11
            TBUFFT = BLANK
            CALL QRESPM(MESSFL,CLU,GRP,INUM,RNUM,CNUM,
     M                  IVAL,RVAL,CVAL,
     O                  TBUFF)
            MAXLN= 0
            DO 32 I= 2,7
              IF (IVAL(I).GT.0) THEN
                MAXLN= MAXLN+ 1
                YIND(MAXLN)= IVAL(I)
              END IF
 32         CONTINUE
            XIND= IVAL(1)
            WRITE(99,*) 'user spec,MAXLN,IVAL:',MAXLN,IVAL
C
          ELSE IF (POPT.EQ.7) THEN
 33         CONTINUE
C           get the plot device
C           GRP= 4
C           CALL QRESP(MESSFL,CLU,GRP,DEVCOD)
            CVAL(1,1)= DEVCOD
            CVAL(2,1)= AXTYP(1)
            CVAL(3,1)= AXTYP(2)
            GRP = 12
            INUM= 1
            RNUM= 1
            CNUM= 3
            CALL QRESPM(MESSFL,CLU,GRP,INUM,RNUM,CNUM,
     M                  IVAL,RVAL,CVAL,
     O                  TBUFF)
            DEVCOD  = CVAL(1,1)
            AXTYP(1)= CVAL(2,1)
            AXTYP(2)= CVAL(3,1)
C            IF (DEVCOD.LE.3. .AND. GRAPHS.EQ.2) THEN
            IF (DEVCOD.LE.4. .AND. GRAPHS.EQ.2) THEN
               GRP = 13
               CALL PRNTXT (MESSFL,CLU,GRP)
               GO TO 33
            ENDIF
            IF (DEVCOD.EQ.2 .AND. GRAPHS.NE.2) THEN
C              Make 'PREV' option available.
               I = 4
               CALL ZSTCMA
     I                     (I,I1)
C              Make 'INTRPT' option available.
               I = 16
               CALL ZSTCMA
     I                     (I,I1)
C              Set the screen group to display data screen.
               GRP = 15
C              Clear the data buffer for initial and return values.
               CALL ZIPC
     I                   (I80,BLANK,
     O                              TBUFF)
               TBUFFT = BLANK
C              Load data into data buffer.  Convert integer to character.
               CALL INTCHR
     I                     (PRNTYP,LEN2,JUST,
     O                                       LENOUT,PRNCHR)
               CLEN = 2
C              Load data into display data buffer.
               CALL CHRCHR
     I                     (CLEN,PRNCHR,
     O                                  TBUFF(1))
               CLEN = 40
               CALL CHRCHR
     I                     (CLEN,PRNDES(PRNTYP),
     O                                          TBUFF(3))
               INUM = I1
               RNUM = I1
               CNUM = I1
               IVALX(1) = I0
               RVALX(1) = 0.0
C              Display the data entry screen.  Current values are in TBUFF.
               CALL QRESPX
     I                     (MESSFL,CLU,GRP,INUM,RNUM,CNUM,
     M                                                    IVALX,
     M                                                    RVALX,
     M                                                    CVALX,
     M                                                    TBUFF)
C              Get return value from data entry screen.
               CALL ZGTRET
     O                     (IRET)
C              Make 'PREV' option unavailable.
               I= 4
               CALL ZSTCMA
     I                     (I,I0)
C              Make 'INTRPT' option unavailable.
               I= 16
               CALL ZSTCMA
     I                     (I,I0)
C              If data entry screen return code=7,
C              interupt (don't save) changes.
               IF (IRET.EQ.7) GO TO 9990
C               IF (IRET.EQ.7.OR.
C     1            (IRET.EQ.2..AND.IVALX(1).EQ.PRNTYP)) GO TO 9990
C              Determine if user changed printer type; change default.
C               IF (PRNTYP .NE. IVALX(1)) THEN
                   GRP = 16
                   CALL PMXCNW
     I                         (MESSFL,CLU,GRP,I1,I1,I1,
     O                                                  J)
                   PRNTYP = IVALX(1)
                   GRP = 17
C                 
                   CALL QFOPFN
     I                         (MESSFL,CLU,GRP,FLNAME,PRTFLG,
     O                                                       TDATFL,
     O                                                       RTCOD)
C
                   IF (RTCOD.EQ.I0) THEN
C                     INTERACT.INI file opened successfully.
                      GO TO 9090
                   ELSE
C                     INTERACT.INI file not found and opened.
                      NEWFIL = .TRUE.
C                     Create new file.
                     OPEN (UNIT=TDATFL,FILE='INTERACT.INI',STATUS='NEW',
     1                      ACCESS='SEQUENTIAL',FORM='FORMATTED',
     2                      IOSTAT=IOSTAT,BLANK='NULL',ERR=9990)
CVAX     3                      CARRIAGECONTROL='LIST')
                      WRITE (TDATFL,3040)
                      WRITE (TDATFL,3000)
                      WRITE (TDATFL,3010)
                   ENDIF
 9090              CONTINUE
C                  Write new printer identification number
                   WRITE (TDATFL,3030) PRNTYP
                   IF (NEWFIL) WRITE (TDATFL,3020)
C                  Close INTERACT.INI file.
                   CLOSE (UNIT=TDATFL,IOSTAT=IOSTAT,STATUS='KEEP')
C               ENDIF
            ENDIF
 9990       CONTINUE
C
C           get linetype and symbol
C           DO 35 I=1,MAXLN
C             WRITE (*,*) 'enter symbol and line type for curve',I,': '
C             READ (*,*) GSYMBL(I),GLNTYP(I)
C35         CONTINUE
          ELSE IF (POPT.EQ.8) THEN
C           plots complete
            DONFLG= 1
          END IF
C
          IF (POPT.LE.6) THEN
C           set titles
            XLAB= CTITL(XIND)
            DO 36 I= 1,MAXLN
              CLAB(I)= CTITL(YIND(I))
 36         CONTINUE
C
            SIMCNT= MAXLN
C
            IF (DEVCOD.EQ.5) THEN
C             open file for output text
              GRP= 9
C             get screen information
              CALL Q1INIT (MESSFL,CLU,GRP)
C             clear file name
C             FLNAME(1)=' '
C             CALL QSETFN (I1,FLNAME)
C             edit the screen
              CALL Q1EDIT (RETCOD)
              IF (RETCOD.EQ.1) THEN
                RETCOD= 0
C               get file unit number
                CALL QGETF (I1,Q2FIL)
C               write general info
                WRITE(Q2FIL,2000) TITL(1:59)
                WRITE(Q2FIL,2000) TITL(61:119)
                WRITE(Q2FIL,2000) TITL(121:160)
                WRITE(Q2FIL,2010) CTITL(XIND),(CTITL(YIND(I)),I=1,MAXLN)
              END IF
            END IF
C
            IF (RETCOD.EQ.0) THEN
C             loop to draw each plot
              write(99,*) 'drawing',cntplt,' plots with ',maxln,' crvs'
              write(99,*) 'XIND,YIND:',XIND,(YIND(I),I=1,MAXLN)
              DO 60 K= 1,CNTPLT
                write(99,*) 'about to draw plot',k
                DO 37 I= 1,MAXLN
                  CNTP(I)= 0
37              CONTINUE
C               use the qual2 output data
                DO 40 I= 1,CURP
                  IF (ABS(Q2OUT(I,4)-K).LT.1E-4) THEN
C                   part of current plot
                    DO 38 J= 1,MAXLN
                      CNTP(J)= CNTP(J)+ 1
                      YPT(CNTP(J),J)= Q2OUT(I,YIND(J))
                      XPT(CNTP(J),J)= Q2OUT(I,XIND)
C                     IF (J.EQ.1) THEN
C                       WRITE(99,*) 'save:',CNTP(J),
C    1                    XPT(CNTP(J),J),YPT(CNTP(J),J)
C                     END IF
38                  CONTINUE
                  END IF
40              CONTINUE
                write(99,*) 'using ',cntp(1),' points of',curp
C
                IF (OBCNT.GT.0) THEN
C                 use some observed data
                  DO 42 J= 1,SIMCNT
C                   assume no data for this plot
                    IF (J .LE. 3) OBIND(J)= 0
                    IPNT=J+SIMCNT
                    IF (IPNT .LE. 6) CNTP(J+SIMCNT)= 0
 42               CONTINUE
C
                  DO 50 I= 1,OBCNT
                    DO 48 J= 1,SIMCNT
                      WRITE (99,*) 'obs data find:',I,J
                      IF(OBINT(I,1).EQ.YIND(J).AND.OBINT(I,2).EQ.K) THEN
C                       plot these observed points
                        L= 0
 45                     CONTINUE
C                         determine which plot
                          L= L+ 1
                        IF (OBIND(L).NE.OBINT(I,1) .AND.
     1                      OBIND(L).NE.0) GO TO 45
                        IF (OBIND(L).EQ.0) THEN
C                         a new plot
                          OBIND(L)= OBINT(I,1)
                          MAXLN= MAXLN+ 1
                          CLAB(MAXLN)= 'OBS '//OBNAM(OBINT(I,3))
                          GSYMBL(MAXLN)= MAXLN- SIMCNT
                          GLNTYP(MAXLN)= 0
                          WRITE (99,*) 'new obs plot:',L,OBIND(L),MAXLN
                        END IF
                        M= MAXLN
                        DO 46 N= 2,4
                          IF (OBDAT(I,N).GT.0.0) THEN
C                           a valid point
                            CNTP(M)= CNTP(M)+ 1
                            YPT(CNTP(M),M)= OBDAT(I,N)
                            XPT(CNTP(M),M)= OBDAT(I,1)
                            WRITE (99,*) 'new obs data point:',M,CNTP(M)
                          END IF
 46                     CONTINUE
                      END IF
 48                 CONTINUE
 50               CONTINUE
                END IF
                write(99,*) 'plot',maxln,' crv of ',(cntp(j),j=1,maxln)
C
                IF (DEVCOD.NE.5) THEN
C                 initialize plot common
                  write(99,*) 'about to initialize plot common'
                  CALL GPINIT
                  IF (LLOC.EQ.1) THEN
C                   set legend location to UR
                    CALL GPLEDG(0.7,0.95)
                  ELSE IF (LLOC.EQ.2) THEN
C                   set legend location to LL
                    CALL GPLEDG(0.05,0.1*MAXLN)
                  ELSE IF (LLOC.EQ.3) THEN
C                   set legend location to LR
                    CALL GPLEDG(0.7,0.1*MAXLN)
                  END IF
C                 set device
CLH
                  DEVTYP=DEVCOD
                  write(99,*) 'set DEVTYP from DEVCOD',DEVTYP,DEVCOD
                  INDEX =39+DEVTYP
                write(99,*) 'set INDEX based on DEVTYP+39',INDEX,DEVTYP
                  CALL ANPRGT (INDEX,DEVCOD)
      write(99,*) 'call ANPRGT set DEVCOD based on INDEX',DEVCOD,INDEX
                  CALL GPDEVC(DEVTYP,DEVCOD)
      write(99,*) 'called GPDEVC with DEVTYP and DEVCOD',DEVTYP,DEVCOD
C                  CALL GPDEVC(DEVCOD)
CLH
                  write (99,*) 'about to make plot',K,CNTP
                  IF (DEVCOD.NE.1) THEN
C                   status message needed
                    IF (DEVCOD.EQ.2) THEN
                      GRP= 5
                    ELSE IF (DEVCOD.EQ.3) THEN
                      GRP= 6
                    ELSE IF (DEVCOD.EQ.4) THEN
                      GRP= 14
                    END IF
                    CALL PMXTXI (MESSFL,CLU,GRP,MXLIN,I1,I1,I1,K)
                  END IF
                  CALL GPSIMQ(AXTYP,MAXLN,GLNTYP,GSYMBL,MAXP,CNTP,
     I                        YPT,XPT,TITL1,YLAB1,XLAB1,CLAB1)
                  WRITE(99,*) 'back from GPSIMQ'
                ELSE
C                 text to a file
                  DO 55 I=1,CNTP(1)
                    WRITE (Q2FIL,2020) K,XPT(I,1),(YPT(I,J),J=1,SIMCNT)
 55               CONTINUE
                END IF
C               reset number of plots
                MAXLN= SIMCNT
                write(99,*) 'completed plot ',K,' of',CNTPLT
 60           CONTINUE
            END IF
C
            IF (DEVCOD.EQ.5 .AND. RETCOD.EQ.0) THEN
C             wrote file message
              GRP= 10
              CALL PRNTXT (MESSFL,CLU,GRP)
C             close file
              CALL QFCLOS(Q2FIL,0)
            END IF
          END IF
        IF (DONFLG.EQ.0) GO TO 29
      END IF
C
      II = 16
      CALL ANPRGT (II,GRAPHS)
      IF (GRAPHS.EQ.1) THEN
          write (FE,*) 'just made plot, about to close GKS'
          CALL GPCLOS(FE)
      ELSE
          write (FE,*) 'no graphics available'
      END IF
C
C     shut down system
      CALL ANCLOS (MESSFL)
C
      STOP
      END
