       SUBROUTINE ALGAES
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CCC
CCC             NCASI Commentary, ALGAES - Section A.
CCC                     A. Initialize cunters.
CCC
      NHW=0
      NWS=0
CCC
CCC             NCASI Commentary, ALGAES - Section B.
CCC                     B. Read in solar radiation data, if
CCC                         required.
CCC
CCC
CCC             NCASI Commentary, ALGAES - Section C.
CCC                     C. Set up loop on number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + +
      ALGIJI = QI(I)/CNCELR*ALGI(I)
      ALGIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      ALGIJI = 0.0
      ALGIJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, ALGAES - Section D.
CCC                     D. Compute algal growth rates.
CCC
      TC = 0.556*(T(IOR)-68.0)
      RESPRR(IOR)=RESPRT*THETA(14)**TC
        AGYSET(IOR) = ALGSET(I)*THETA(15)**TC
      ALSINK=AGYSET(IOR)/DEPTH(IOR)
CCC
CCC             NCASI Commentary, ALGAES - Section E.
CCC
CCC                     E. Initialize diagonal and known terms.
CCC
      REACT=GROWTH(IOR)-RESPRR(IOR)-ALSINK
      B(IOR)=X(IOR)-ALGIJO*DTOVCL(IOR)-REACT*D1LT
      S(IOR)=ALGAE(IOR)
      IF(ISS.GT.1) S(IOR)=0.0
      S(IOR) = S(IOR)+ALGIJI*DTOVCL(IOR)
CCC
CCC                     E.6 For Type 2, 3, 4 and 5 elements
CCC                          the algae balance is now complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, ALGAES - Section F.
CCC                     F. Algal balance fo Type 1 element.
CCC
  101 NHW=NHW+1
      S(IOR) = S(IOR) - A(IOR)*HWALG(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, ALGAES - Section G.
CCC                     G. Algal balance for Type 6 element.
CCC
  103 NWS=NWS+1
      S(IOR) = S(IOR) + WSFLOW(NWS)*WSALG(NWS)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, ALGAES - Section H.
CCC                     H. Algal balance for Type 7 element.
CCC
  104 NWS=NWS+1
      B(IOR) = B(IOR) - WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*ALGLB
CCC
CCC             NCASI Commentary, ALGAES - Section I.
CCC                     I. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, ALGAES - Section J.
CCC                     J. Return to MAIN.
CCC
      RETURN
      END
