      SUBROUTINE ANCS
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CCC
CCC             NCASI Commentary, ANCS - Section A.
CCC                     A. Initialize counters.
CCC
      NHW=0
      NWS=0
        FACT = 1.0/(28.3*86400.0)
CCC
CCC             NCASI Commentary, ANCS - Section B.
CCC                     B. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + + +
      ANCIJI=QI(I)/CNCELR*ANCI(I)
      ANCIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      ANCIJI = 0.0
      ANCIJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, ANCS - Section C.
CCC                     C. Initialize diagonal and known terms.
CCC
      TC=0.556*(T(IOR)-68.0)
      KANC(IOR)=CKANC(I)*THETA(17)**TC
      STANC(IOR) = SETANC(I)*THETA(18)**TC
      B(IOR) = X(IOR)-ANCIJO*DTOVCL(IOR)+(KANC(IOR)+STANC(IOR))*D1LT
      SRANC(IOR) = (SRCANC(I)*THETA(19)**TC)
      S1 = ANCIJI + SRANC(IOR)*BAREA(IOR)*FACT
      S(IOR)=ANC(IOR)
      IF (ISS.GT.0) S(IOR)=0.0
      S(IOR) = S(IOR) + S1*DTOVCL(IOR)
CCC
CCC                     C.8 For Type 2, 3, 4, and 5 elements the
CCC                          non-conservative balance is now
CCC                          complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, ANCS - Section D.
CCC                     D. Non-conservative balance for Type 1
CCC                         element.
CCC
  101 NHW=NHW+1
      S(IOR)=S(IOR)-A(IOR)*HWANC(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, ANCS - Section E.
CCC                     E. Non-conservative balance for Type 6
CCC                         element.
CCC
  103 NWS=NWS+1
      S(IOR)=S(IOR)+WSFLOW(NWS)*WSANC(NWS)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, ANCS - Section F.
CCC                     F. Non-conservative balance for Type 7
CCC                         element.
CCC
  104 NWS=NWS+1
      B(IOR)=B(IOR)-WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*ANCLB
CCC
CCC             NCASI Commentary, ANCS - Section G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, ANCS - Section H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
