      SUBROUTINE BODS
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
C
CCC
CCC             NCASI Commentary, BODS - Section A.
CCC                     A. Initialize counters.
CCC
      NHW=0
      NWS=0
CCC
CCC             NCASI Commentary, BODS - Section B.
CCC                     B. Set up loop on number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + +
      BODIJI=QI(I)/CNCELR*BODI(I)
      BODIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      BODIJI = 0.0
      BODIJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, BODS - Section C.
CCC                     C. Initialize diagonal and known terms.
CCC
      TC=0.556*(T(IOR)-68.0)
      K1(IOR)=CK1(I)*THETA(1)**TC
      K3(IOR) = CK3(I)*THETA(2)**TC
      REACT=D1LT*(K1(IOR)+K3(IOR))
      B(IOR)=X(IOR)+REACT-BODIJO*DTOVCL(IOR)
      S(IOR)=BOD(IOR)
      IF(ISS.GT.1) S(IOR)=0.0
      S(IOR)=S(IOR)+BODIJI*DTOVCL(IOR)
CCC
CCC
CCC                     C.9 For Type 2, 3, 4 and 5 elements
CCC                          the BOD balance is now complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, BODS - Section D.
CCC                     D. BOD balance for Type 1 element.
CCC
  101 NHW=NHW+1
      S(IOR)=S(IOR)-A(IOR)*HWBOD(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, BODS - Section E.
CCC                     E. BOD balance for Type 6 element.
CCC
  103 NWS=NWS+1
      S(IOR)=S(IOR)+WSFLOW(NWS)*WSBOD(NWS)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, BODS - Section F.
CCC                     F. BOD balance for Type 7 element.
CCC
  104 NWS=NWS+1
      B(IOR)=B(IOR)-WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*BODLB
CCC
CCC             NCASI Commentary, BODS - Section G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, BODS - Section H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
