      SUBROUTINE CHANL(J,Q,VELO,DPTH,K)
C
C                  THIS SUBROUTINE RETURNS VELOCITY AND DEPTH
C                  USING   THE NEWTON RAPHSON TECHNIQUE WHEN
C                  TRAP-CHANNEL DATA IS INPUT OR
C                  ALPHA'S AND BETA'S OTHERWISE
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'CONST.INC'
CC
CCC
CCC             NCASI Commentary, CHANL - Section B.
CCC                     B. Test for a dry channel (no flow).
CCC
C +++++
C      IF(Q.NE.0.0)GO TO 340
      IF(ABS(Q).GT.R0MIN) GO TO 340
C +++++
      VELO=0.
      DPTH=0
CCC
CCC                     B.1 Return to HYDRAU.
CCC
      RETURN
  340 CONTINUE
CCC
CCC             NCASI Commentary, CHANL - Section C.
CCC                     C. Test for trapezoidal cross sections.
CCC
CCC                     C.2 Calculate velocity and depth from
CCC                          correlations with flow.
CCC
      IF(ITRAP.EQ.1)GO TO 350
      VELO=COEFQV(J)*Q**EXPOQV(J)
      DPTH=COEFQH(J)*Q**EXPOQH(J)
      TRVTM(K) = DELX/(VELO*86400.)
      XAREA(K) = Q/VELO
      VOLSEG(K) = Q*DELX/(VELO)
      EWIDTH(K) = Q/(VELO*DPTH)
      BAREA(K) = (EWIDTH(K) + 2.*DPTH)*DELX
CCC
CCC                     C.2c Return to HYDRAU.
CCC
      RETURN
  350 CONTINUE
CCC
CCC             NCASI Commentary, CHANL - Section D.
CCC                     D. Calculate velocity and depth for
CCC                         trapezoidal cross sections from
CCC                         Manning's equation using Newton's
CCC                         method.
CCC
CCC                     D.1 Set initial guesses for old and
CCC                          new depths.
CCC
      DEL=1.
      DELD=1.
      CONST=1.486/CMANN(J)*SQRT(SLOPE(J))
CCC
CCC                     D.3 Set up loop for iterative solution.
CCC
      DO 360 I=1,30
      AREA=0.5*(SS1(J)+SS2(J))*DEL**2+WIDTH(J)*DEL
      DAREA=(SS1(J)+SS2(J))*DEL+WIDTH(J)
      WETPER=SQRT(SS1(J)**2+1)*DEL+SQRT(SS2(J)**2+1)*DEL+WIDTH(J)
      DWETP=(SQRT(SS1(J)**2+1))+(SQRT(SS2(J)**2+1))
      FLW=CONST*((AREA**1.66667)/(WETPER**0.66667))
      F=FLW-Q
      DF=CONST*(((1.66667*AREA**0.6667*DAREA)*(WETPER**0.66667))
     1   -((AREA**1.66667)*0.66667*(WETPER**(-0.33333))*DWETP))/
     2   (WETPER**1.33333)
      DEL=DELD-F/DF
CCC
CCC                     D.4 Test for convergence.
CCC
      IF(ABS(F).LT.0.001*Q) GO TO 380
  360 DELD=DEL
      WRITE(NJ,1111)
 1111 FORMAT(1H ,32HTHERE IS NO CONVERGENCE IN CHANL)
CCC
CCC                     D.4b Return to HYDRAU.
CCC
      RETURN
  380 CONTINUE
      DPTH=DEL
      VELO=Q/AREA
      TRVTM(K) = DELX/(VELO*86400.)
      XAREA(K) = AREA
      VOLSEG(K) = AREA*DELX
      EWIDTH(K) = AREA/DPTH
      BAREA(K) = WETPER*DELX
CCC
CCC                     D.5b Return to HYDRAU.
CCC
      RETURN
      END
