      SUBROUTINE CONSVT
C
C                             CONSVT PERFORMS A CONSERVATIVE MINERAL
C                             BALANCE FOR EACH COMPUTATIONAL ELEMENT
C                             IN THE SYSTEM.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CCC
CCC             NCASI Commentary, CONSVT - Section A.
CCC                     A. Initialize counters.
CCC
      NHW=0
      NWS=0
CCC
CCC             NCASI Commentary, CONSVT - Section B.
CCC                     B. Set up loop on number of reaches
CCC                          and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + +
      CONSJI = QI(I)/CNCELR*CONSI(I,NC)
      CONSJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      CONSJI = 0.0
      CONSJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC                     B.5 Initialize diagonal and known terms.
CCC
      B(IOR)=X(IOR)-CONSJO*DTOVCL(IOR)
      S(IOR)=CONS(IOR,NC)
      IF(ISS.GT.1) S(IOR)=0.0
      S(IOR)=S(IOR)+CONSJI*DTOVCL(IOR)
CCC
CCC                     B.8 For Type 2, 3, 4 and 5 elements
CCC                          the conservative mineral balance
CCC                          is now complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, CONSVT - Section C.
CCC                     C. Mineral balance for Type 1 element.
CCC
  101 NHW=NHW+1
      S(IOR)=S(IOR)-A(IOR)*HWCONS(NHW,NC)
      GO TO 100
CCC
CCC             NCASI Commentary, CONSVT - Section D.
CCC                     D. Mineral balance for Type 6 element.
CCC
  103 NWS=NWS+1
      S(IOR)=S(IOR)+WSFLOW(NWS)*WSCONS(NWS,NC)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, CONSVT - Section E.
CCC                     E. Mineral balance for Type 7 element.
CCC
  104 NWS=NWS+1
      B(IOR)=B(IOR)-WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*CONSLB(NC)
CCC
CCC             NCASI Commentary, CONSVT - Section F.
CCC                     F. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, CONSVT - Section G.
CCC                     G. Return to MAIN.
CCC
      RETURN
      END
