      SUBROUTINE DOS
CC
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
CDWD - DOS UPDATE from specifications provided by J. Kreider            02/92
CDWD   State of Wisconsin                                               02/92
CDWD   Date: Wednesday, 26 February 1992.  Time: 16:58:12.              02/92
CDWD   Version 3.15                                                     02/92
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      REAL*4 TERM1, IANC
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      CHARACTER*4       UBOD
      DATA UBOD /' 5-D'/
CCC
CCC             NCASI Commentary, DOS - Section A.
CCC                     A. Convert 5 day BOD to ultimate (or
CCC                         vice-versa) if title card number 7
CCC                         specifies BOD input data as 5 day.
CCC
C-.....
C.....CONVERT BETWEEN ULTIMATE AND 5-DAY BOD BASED ON AN ASSUMED
C.....LAB DECAY RATE OF 0.23/DAY (BASE E )........WRN......
C.....
      IF(TITLE(7,6).NE.UBOD) GO TO 50
      CFBOD = 1.0 - EXP( -5.0*KBOD)
      IVERT = 0
   10 IVERT = IVERT + 1
      IF( NHWTRS .LE. 0 ) GO TO 25
      DO 20 J = 1, NHWTRS
      HWBOD(J) = HWBOD(J) / CFBOD
   20 CONTINUE
   25 IF( NWASTE .LE. 0 ) GO TO 35
      DO 30 J = 1, NWASTE
      WSBOD(J) = WSBOD(J) / CFBOD
   30 CONTINUE
   35 DO 45 J = 1, NREACH
      BODI(J) = BODI(J) / CFBOD
      NCELR = NCELRH(J)
      DO 40 K = 1, NCELR
      IOR = ICLORD(J,K)
      BOD(IOR) = BOD(IOR) / CFBOD
   40 CONTINUE
   45 CONTINUE
      BODLB = BODLB/CFBOD
CCC
CCC                     B.6 Test IVERT for first of second
CCC                          pass. Return to MAIN.
CCC
      IF( IVERT .GE. 2 ) RETURN
      CFBOD = 1.0 / CFBOD
CCC
CCC             NCASI Commentary, DOS - Section B.
CCC                     B. Initialize counters and constants.
CCC
   50 CONTINUE
      NHW=0
      NWS=0
      IJUNC=0
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      IANC=0.0
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      FACT = 1.0 / (28.3 * 86400.0)
      FACT1 = 1.0/(28.3*86.4)
C3.0
      ATMP = ATMPR/29.9
C3.0
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      IF(TITLE(15,13).EQ.'2BOD') THEN IANC=1.0
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
CCC
CCC             NCASI Commentary, DOS - Section C.
CCC                     C. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + + +
      DOIJI=QI(I)/CNCELR*DOI(I)
      DOIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 60
      DOIJI = 0.0
      DOIJO = QI(I)/CNCELR
60    CONTINUE
CQ2E + + + + + + + +
C3.0
      IF(ISS.GT.1) ATMP = RCHATM(I)/29.9
C3.0
C     RATIO=1.0/(1.0-EXP(-5.0*CK1(I)))
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, DOS - Section D.
CCC                     D. Initialize diagonal and known terms.
CCC
      TC=0.556*(T(IOR)-68.0)
      S(IOR)=DO2(IOR)
      IF (ISS.GT.1) S(IOR)=0.0
      IF (MODOPT(4).LT.1) GO TO 90
      AREACT=(ALPHA3*GROWTH(IOR)-ALPHA4*RESPRR(IOR))*D1LT
      S(IOR) = S(IOR) + AREACT*ALGAE(IOR)
   90 IF (MODOPT(6).LT.1) GO TO 92
      S(IOR) = S(IOR) - (ALPHA5*KNH3(IOR)*CNH3(IOR)+
     1                   ALPHA6*KNO2(IOR)*CNO2(IOR))*D1LT
92      SOD(IOR) = CK4(I)*THETA(4)**TC
        S(IOR) = S(IOR) - SOD(IOR)*BAREA(IOR)*DTOVCL(IOR)*FACT1
C     K1(IOR)=K1(IOR)*RATIO
        TK = 273.15 + (T(IOR)-32.0)*5./9.
        DSM = -139.34410+(1.575701E+05/TK)
     1       -(6.642308E+07/(TK*TK))
     2       +(1.243800E+10/(TK*TK*TK))
     3       -(8.621949E+11/(TK*TK*TK*TK))
      DOSAT(IOR) = EXP(DSM)
C     DOSAT(IOR)=24.89-0.4259*T(IOR)+0.003734*T(IOR)**2-0.00001328
C     1*T(IOR)**3
C3P1
C3P1   CORRECT DOSAT FOR ATMP, IF VALUE IS GIVEN
C3P1
        IF(ATMP.LE.0.1) GO TO 95
        PWV = 11.8571-(3840.70/TK) - 216961./(TK*TK)
        PWV = EXP(PWV)
        THETAW = 0.000975 - (1.426E-05*TC)
     1 + (6.436E-08*TC*TC)
        PNUM = (1.0-PWV/ATMP)*(1.0-THETAW*ATMP)
        PDENOM = (1.0-PWV)*(1.0-THETAW)
        DOSAT(IOR) = DOSAT(IOR)*ATMP*PNUM/PDENOM
95      CONTINUE
CC
CC              Remove the constraint on DO saturation.
CC
CC    IF (DO2(IOR).GT.DOSAT(IOR)) DO2(IOR) = DOSAT(IOR)
CC
      IFL=IFLAG(I,J)
      GO TO (101,102,102,104,109,103,105), IFL
CCC
CCC             NCASI Commentary, DOS - Section E.
CCC                     E. DO balance on Type 1 element.
CCC
  101 NHW=NHW+1
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      TERM1=KANC(IOR)*ANC(IOR)*IANC
      REACT=D1LT*(XK2(IOR)*DOSAT(IOR)-K1(IOR)*BOD(IOR)-TERM1)
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      S(IOR)=S(IOR)+REACT+DOIJI*DTOVCL(IOR)-A(IOR)*HWDO(NHW)
      B(IOR)=X(IOR)+D1LT*XK2(IOR)-DOIJO*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, DOS - Section F.
CCC                     F. DO balance on Type 2, 3, and 5 elements.
CCC
102   CONTINUE
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      TERM1=KANC(IOR)*ANC(IOR)*IANC
      REACT=D1LT*(XK2(IOR)*DOSAT(IOR)-K1(IOR)*BOD(IOR)-TERM1)
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      S(IOR)=S(IOR)+REACT+DOIJI*DTOVCL(IOR)
      B(IOR)=X(IOR)+D1LT*XK2(IOR)-DOIJO*DTOVCL(IOR)
      IF(JDAM(IOR).EQ.0) GO TO 100
      IDAM = JDAM(IOR)
      AVTEMP = (((T(IOR-1)+T(IOR))*.5) - 32.0)*5./9.
      DENOM = 1.0 + .116*ADAM(IDAM)*BDAM(IDAM)*(1.0+0.046*AVTEMP)*
     1 (1-0.034*HDAM(IDAM))*HDAM(IDAM)
        RHS = (1.0 - 1.0/DENOM)*(DOSAT(IOR-1)-DO2(IOR-1))
        DAMO2(IDAM) = RHS-DOSAT(IOR-1) + DOSAT(IOR)
        S(IOR) = S(IOR) + DAMO2(IDAM)*FDAM(IDAM)*FLOW(IOR-1)*
     1 DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, DOS - Section G.
CCC                     G. DO balance on Type 6 element.
CCC
  103 NWS=NWS+1
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      TERM1=KANC(IOR)*ANC(IOR)*IANC
      REACT=D1LT*(XK2(IOR)*DOSAT(IOR)-K1(IOR)*BOD(IOR)-TERM1)
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      S(IOR)=S(IOR)+REACT+(DOIJI+WSFLOW(NWS)*WSDO(NWS))*DTOVCL(IOR)
      B(IOR)=X(IOR)+D1LT*XK2(IOR)-DOIJO*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, DOS - Section H.
CCC                     H. DO balance on Type 4 element.
CCC
  104 IJUNC=IJUNC+1
      NS=1
      NN=JUNC(IJUNC,NS)
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      TERM1=KANC(IOR)*ANC(IOR)*IANC
      REACT=D1LT*(XK2(IOR)*DOSAT(IOR)-K1(IOR)*BOD(IOR)-TERM1)
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      S(IOR)=S(IOR)+REACT+DOIJI*DTOVCL(IOR)
      B(IOR)=X(IOR)+D1LT*XK2(IOR)-DOIJO*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, DOS - Section I.
CCC                     I. DO balance on Type 7 element.
CCC
  105 NWS=NWS+1
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      TERM1=KANC(IOR)*ANC(IOR)*IANC
      REACT=D1LT*(XK2(IOR)*DOSAT(IOR)-K1(IOR)*BOD(IOR)-TERM1)
CDWD ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 02/92
      S(IOR)=S(IOR)+REACT+DOIJI*DTOVCL(IOR)
      B(IOR)=X(IOR)+D1LT*XK2(IOR)-(DOIJO+WSFLOW(NWS))*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 102
      S(IOR) = S(IOR) - C(IOR)*DOLB
      GO TO 102
CCC
CCC             NCASI Commentary, DOS - Section J.
CCC                     J. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, DOS - Section K.
CCC                     K. Test Title 7 for 5 day BOD data.
CCC
CCC                     L. Return to MAIN.
CCC
      IF(TITLE(7,6).NE.UBOD) RETURN
      GO TO 10
      END
