      SUBROUTINE FDES
C
C      THIS SUBROUTINE ANALYZES A FACTORIALLY DESIGNED SET OF 
C      SENSITIVITY SIMULATIONS AND WRITES THE UNCAS FINAL REPORT
C      FOR THE FACTORIAL DESIGN.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C
C +++++
      CHARACTER*4 VNAME,VO,V1,V2,V3,V4,V5
C      INTEGER*2 CONOUT,MSGFIL
C +++++
C
      DIMENSION VO(5),LEM(8,8),MDATA(10)
C
C +++++
C      DATA CONOUT,MSGFIL / 7,9 /
C +++++
      DATA VO/'MEAN',' 1-2',' 1-3',' 2-3','1-2-'/
      DATA V1,V2,V3,V4,V5/'    ','RCH=','HDW=','PTL=','NDM='/
C
C      SET UP DESIGN ARRAY
C
      IF(NSIM.EQ.8) GO TO 9
      DO 5 I=1,NSIM
      LEM(I,1) = 1
      LEM(I,2) = LD(1,I)
      LEM(I,3) = LD(2,I)
      LEM(I,4) = LD(1,I)*LD(2,I)
5     CONTINUE
      GO TO 15
9     CONTINUE
      DO 10 I=1,NSIM
      LEM(I,1) = 1
      LEM(I,2) = LD(1,I)
      LEM(I,3) = LD(2,I)
      LEM(I,4) = LD(3,I)
      LEM(I,5) = LD(1,I)*LD(2,I)
      LEM(I,6) = LD(1,I)*LD(3,I)
      LEM(I,7) = LD(2,I)*LD(3,I)
      LEM(I,8) = LEM(I,5)*LD(3,I)
10    CONTINUE
15    CONTINUE
C
C       BEGIN LOOP
C
       DO 100 M=1,NOVAR
C
C      OPEN FILE CONTAINING STORED DATA FOR FACTORIAL ANALYSIS
C
C      NJ2 = 2
      OPEN(UNIT=NJ2,FILE=FILNAM(8),STATUS='OLD',ERR=990)
C      OPEN(UNIT=NJ2,STATUS='OLD',FILE='STORE.DAT')
C
C      READ MDATA ARRAY FOR OUTPUT SCREENING
C
      DO 135 I=1,NOVAR
      READ(NJ2,126) (MDATA(K),K=1,10)
126   FORMAT(10I5)
      IF(I.NE.M) GO TO 135
      DO 137 K=1,10
137   IF(MDATA(K).EQ.1) MM=K
135   CONTINUE
C
C      READ BASE CASE
C
      READ(NJ2,20) I
      DO 17 J=1,NOVAR
      READ(NJ2,21) (SDATA(K),K=1,NLOC)
17    CONTINUE
C
C      READ MDATA ARRAY FOR INPUT SCREENING.  COMPARE LINKAGE OF EACH 
C      INPUT TO THE CURRENT OUTPUT VARIABLE, IF NONE, PROCEED TO THE
C      NEXT OUTPUT VARIABLE.
C
      IFECT=0
      DO 125 I=1,NFVARS
      READ(NJ2,126) (MDATA(K),K=1,10)
      IF(MDATA(MM).EQ.1) IFECT=1
125   CONTINUE
      IF(IFECT.EQ.0) GO TO 102
C
C      EXTRACT RSMAT ARRAY (RESPONSES)
C      NOTE RSMAT BECOMES PERCENT EFFECT AFTER STATEMENT 40
C
      DO 30 I=1,NSIM
      READ(NJ2,20) JSENS
20    FORMAT(I5)
C        ERROR TRAP FOR MISREAD OF STORED DATA
      IF(JSENS.NE.I) GO TO 95
      DO 35 J=1,NOVAR
      READ(NJ2,21) (SDATA(K),K=1,NLOC)
21    FORMAT(8E14.6/)
      IF(J.NE.M) GO TO 35
      DO 32 K=1,NLOC
32    RSMAT(I,K) = SDATA(K)
35    CONTINUE
30    CONTINUE
C
      CLOSE(UNIT=NJ2)
C
C      CALCULATE FACTORIAL EFFECTS
C
      DO 40 I=1,NLOC
      DO 42 J=1,NSIM
      EFCT = 0.0
      DO 44 K=1,NSIM
44    EFCT=EFCT+RSMAT(K,I)*LEM(K,J)
      EFMAT(J,I) = EFCT/NSIM
42    CONTINUE
40    CONTINUE
      DO 45 I=1,NSIM
      DO 45 J=1,NLOC
      RSMAT(I,J) = 0.0
C +++++
C      IF(EFMAT(1,J).NE.0.0) RSMAT(I,J)=EFMAT(I,J)/EFMAT(1,J)*100.
      IF(EFMAT(1,J).GT.R0MIN) RSMAT(I,J)=EFMAT(I,J)/EFMAT(1,J)*100.
C +++++
45    CONTINUE
C
C      WRITE FACTORIAL DESIGN OUTPUT
C
      WRITE(NJ,50) M
50    FORMAT(1H1,//'  2. SUMMARY OF FACTORIAL DESIGN OUTPUT ANALYSIS',
     *  ': RESPONSE NO. ',I2/)
      WRITE(NJ,51) (TITLE(1,J),J=6,20),(TITLE(2,J1),J1=6,20)
51    FORMAT(/5X,'A. TITLE OF DATA SET.'//,2(10X,15A4/))
      WRITE(NJ,52) VAROT(M)
52    FORMAT(/5X,'B. RESPONSE VARIABLE:',2X,A4/)
      WRITE(NJ,53)
53    FORMAT(/5X,'C. FACTORIAL ANALYSIS'//
     * 38X,'L O C A T I O N'/12X,'EFFECTS')
      GO TO (110,120,130,140,150) NLOC
110   CONTINUE
      WRITE(NJ,112) (JR(K),K=1,NLOC)
112   FORMAT(19X,1(7X,'REACH',I3))
      WRITE(NJ,114) (JE(K),K=1,NLOC)
114   FORMAT(20X,1(5X,'ELEMENT',I3))
      GO TO 160
120   CONTINUE
      WRITE(NJ,122) (JR(K),K=1,NLOC)
122   FORMAT(19X,2(7X,'REACH',I3))
      WRITE(NJ,124) (JE(K),K=1,NLOC)
124   FORMAT(20X,2(5X,'ELEMENT',I3))
      GO TO 160
130   CONTINUE
      WRITE(NJ,132) (JR(K),K=1,NLOC)
132   FORMAT(19X,3(7X,'REACH',I3))
      WRITE(NJ,134) (JE(K),K=1,NLOC)
134   FORMAT(20X,3(5X,'ELEMENT',I3))
      GO TO 160
140   CONTINUE
      WRITE(NJ,142) (JR(K),K=1,NLOC)
142   FORMAT(19X,4(7X,'REACH',I3))
      WRITE(NJ,144) (JE(K),K=1,NLOC)
144   FORMAT(20X,4(5X,'ELEMENT',I3))
      GO TO 160
150   CONTINUE
      WRITE(NJ,54) (JR(K),K=1,NLOC)
54    FORMAT(19X,5(7X,'REACH',I3))
      WRITE(NJ,55) (JE(K),K=1,NLOC)
55    FORMAT(20X,5(5X,'ELEMENT',I3))
160   CONTINUE
      WRITE(NJ,560) VO(1),(EFMAT(1,J),J=1,NLOC)
560   FORMAT(/9X,A4,7X,5(3X,F10.2,2X))
      WRITE(NJ,56)
56    FORMAT(/7X,'MAIN'/)
      NUP=3
      IF(NSIM.EQ.8) NUP=4
      DO 570 I=2,NUP
      I1=I-1
570   WRITE(NJ,57) I1,(EFMAT(I,J),RSMAT(I,J),J=1,NLOC)
57    FORMAT(9X,I3,8X,5(F7.2,'/',F6.1,'%'))
      WRITE(NJ,58)
58    FORMAT(/7X,'2-FACTOR'/9X,'INTERACTION'/)
      IF(NSIM.EQ.8) GO TO 585
      I=4
      I2=I-2
      WRITE(NJ,59) VO(I2),(EFMAT(I,J),RSMAT(I,J),J=1,NLOC)
      GO TO 65
585   CONTINUE
      DO 590 I=5,7
      I3 = I-3
590   WRITE(NJ,59) VO(I3),(EFMAT(I,J),RSMAT(I,J),J=1,NLOC)
59    FORMAT(9X,A4,7X,5(F7.2,'/',F6.1,'%'))
      WRITE(NJ,60)
60    FORMAT(/7X,'3-FACTOR'/9X,'INTERACTION'/)
      I5=5
      I=3
      WRITE(NJ,61) VO(I5),I,(EFMAT(8,J),RSMAT(8,J),J=1,NLOC)
61    FORMAT(9X,A4,I1,6X,5(F7.2,'/',F6.1,'%'))
65    CONTINUE
C
C      WRITE KEY TO IDENTIFY INPUT VARIABLES AND PERTURBED LEVELS
C      FOR THIS ANALYSIS.
C
      WRITE(NJ,70)
70    FORMAT(////5X,'D. INPUT VARIABLES'/
     * 53X,'BASE',9X,'DESIGN LEVELS'/
     * 53X,'VALUE',8X,'LOW',7X,'HIGH'/)
      NV = NVAR(JSENS)
      DO 72 I=1,NV
      INDEX = INDXI(JSENS,L)
      GO TO (310,320,330,340,350,360,370) KTYPE(I)
310   NUP = 1
      VNAME = V1
      GO TO 390
320   NUP = NREACH
      VNAME = V2
      GO TO 390
330   NUP = NREACH
      VNAME = V2
      GO TO 390
340   NUP = NREACH
      VNAME = V2
      GO TO 390
350   NUP = NHWTRS
      VNAME = V3
      GO TO 390
360   NUP = NWASTE
      VNAME = V4
      GO TO 390
370   NUP = NDAM
      VNAME = V5
390   CONTINUE
393   FORMAT(/)
      WRITE(NJ,73) I
73    FORMAT(6X,I2,'. ')
      DO 75 J=1,NUP
75    WRITE(NJ,76) (VARIN(JP,I),JP=1,7),VNAME,J,VSAVE(J,I),
     * SVALLO(I),SVALHI(I)
76    FORMAT(10X,7A4,2X,A4,I3,2X,F10.4,2(3X,F7.3))
      WRITE(NJ,393)
72    CONTINUE
C
C     WRITE SUMMARY MESSAGE TO CTY SCREEN
C
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,98) M,NOVAR,VAROT(M)
98    FORMAT(///////////,
     * 14X,'FDES summary for response',I4,' of',I4,': ',A4,' complete.')
102   REWIND NJ2
100   CONTINUE
      GO TO 998
95    CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,995)
995   FORMAT(///////////,
     1       22X,'????? MISMATCH READING STORED FDES DATA ?????')
998   CONTINUE
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)FILNAM(8)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING STORED FACTORIAL ANALYSIS DATA FILE',
     2     /,'   ',A64,
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
      END
