       SUBROUTINE FLOAUG
C
C                             FLOAUG SEARCHES THROUGH THE SYSTEM BY
C                             REACH TO DETERMINE THE MINIMUM DO LEVEL
C                             WITHIN EACH REACH. EACH OF THESE MINIMUM
C                             DO LEVELS IS CHECKED AGAINST A SELECTED
C                             TARGET LEVEL. IF FLOW AUGMENTATION IS
C                             REQUIRED, THIS FLOW IS DISTRIBUTED
C                             EQUALLY AMONG THE HEADWATER SOURCES THAT
C                             ARE AVAILABLE TO A GIVEN REACH.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
C
      DIMENSION IORMIN(MR),RMILE(MR),DOMIN(MR),IORDER(MR),QAUG(MH)
CCC
CCC             NCASI Commentary, FLOAUG - Section A. (QUAL2 Step 1-0)
CCC                     A. Initialize augmentation flows.
CCC
      DO 5 NHW=1,NHWTRS
      QAUG(NHW)=0.0
    5 CONTINUE
CCC
CCC             NCASI Commentary, FLOAUG - Section B. (QUAL2 Step 2-0)
CCC                     B. Loop through reaches to find the
CCC                         the minimun DO in the reach and
CCC                         its location.
CCC
      DO 50 I=1,NREACH
      DOMIN(I)=100.0
      IF(NHWWAR(I).EQ.0) GO TO 50
      NCELR=NCELRH(I)
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
      IF (DO2(IOR).GE.DOMIN(I)) GO TO 100
      DOMIN(I)=DO2(IOR)
      IORMIN(I)=IOR
      XMIN=J
      RMILE(I)=RMTHOR(I)-XMIN*DELX/5280.0
  100 CONTINUE
   50 CONTINUE
      NBTARG=0
CCC
CCC             NCASI Commentary, FLOAUG - Section C. (QUAL2 Step 3-0)
CCC                     C. Test whether minimum DO is below the
CCC                         target DO.
CCC
      DO 25 I=1,NREACH
      IF (DOMIN(I).GE.TARGDO(I)) GO TO 25
CCC
CCC             NCASI Commentary, FLOAUG - Section D. (QUAL2 Step 3-1)
CCC                     D. If there is a violation of the target
CCC                         DO, compute the amount of flow
CCC                         augmentation required for the reach.
CCC
      NBTARG=NBTARG+1
      IORDER(NBTARG)=I
      IOR=IORMIN(I)
      RMILE(NBTARG)=RMILE(I)
      DOREQD=TARGDO(I)-DOMIN(I)+0.1
      QREQD = FLOW(IOR)*(DOREQD/TARGDO(I) + 0.15*
     *(DOREQD/TARGDO(I))**2)
CCC
CCC             NCASI Commentary, FLOAUG - Section E.
CCC                     E. Determine the augmentation flow already
CCC                         being supplied to this reach because
CCC                         of upstream reaches with DO
CCC                         violations.
CCC
      QSUM=0.0
      NHWAR=NHWWAR(I)
      DO 350 J=1,NHWAR
      NHW=IAUGOR(I,J)
      QSUM=QSUM+QAUG(NHW)
  350 CONTINUE
CC
CCC
CCC             NCASI Commentary, FLOAUG - Section F. (QUAL2 Step 3-2)
CCC                     F. Divide the augmentation flow for this
CCC                         reach equally among the number of
CCC                         available headwaters.
CCC
      QADD=QREQD/NHWWAR(I)
CCC
CCC             NCASI Commentary, FLOAUG - Section G. (QUAL2 Step 3-3)
CCC                     G. Calculate and/or update the augmentation
CCC                         flow to be supplied from each
CCC                         available headwater source.
CCC
      IF (QREQD.LT.QSUM) GO TO 25
      NHWAR=NHWWAR(I)
      DO 375 J=1,NHWAR
      NHW=IAUGOR(I,J)
      QAUG(NHW)=QADD
  375 CONTINUE
   25 CONTINUE
CCC
CCC             NCASI Commentary, FLOAUG - Section H.
CCC                     H. Test the number of target DO violations
CCC                         for the form of output/exit mode.
CCC
      IF (NBTARG.EQ.0) GO TO 300
CCC
CCC             NCASI Commentary, FLOAUG - Section I. (QUAL2 Step 4-0)
CCC                     I. Intermediate augmentation summary.
CCC
CBR      WRITE (NJ,200)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
C +++++
C      IF(METOUT.EQ.O) WRITE (NJ,200)
C      IF(METOUT.NE.O) WRITE (NJ,201)
      IF(METOUT.EQ.0) WRITE (NJ,200)
      IF(METOUT.NE.0) WRITE (NJ,201)
C +++++
CBR                                        !
CBR                                        !
CBR----------------------------------------!
  200 FORMAT (1H1,38X,39H* * * REACHES WITH OXYGEN DEFICIT * * *,//,23X,
     *        52HREACH NO.     REACH IDENTIFICATION       MINIMUM DO.,
     *        15H     RIVER MILE,/)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
  201 FORMAT (1H1,38X,39H* * * REACHES WITH OXYGEN DEFICIT * * *,//,23X,
     *        52HREACH NO.     REACH IDENTIFICATION       MINIMUM DO.,
     *        15H     RIVER KILO,/)
CBR                                        !
CBR                                        !
CBR----------------------------------------!
CCC
CCC                     I.2 Set routing counter to zero.
CCC
      TIME=0.0
      DO 250 K=1,NBTARG
      I=IORDER(K)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
      RX1=RMILE(I)
C +++++
C      IF(METOUT.NE.O) RX1=RX1/1.609
      IF(METOUT.NE.0) RX1=RX1/1.609
C +++++
      WRITE (NJ,255) I,(RCHID(I,J),J=1,5),DOMIN(I),RX1
CBR                                        !
CBR                                        !
CBR----------------------------------------!
CBR      WRITE (NJ,255) I,(RCHID(I,J),J=1,5),DOMIN(I),RMILE(I)
  255 FORMAT (22X,I5,10X,5A4,7X,F5.1,11X,F6.1)
  250 CONTINUE
CBR      WRITE (NJ,260)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
      IF(METOUT.EQ.0) WRITE (NJ,260)
      IF(METOUT.NE.0) WRITE (NJ,262)
CBR                                        !
CBR                                        !
CBR----------------------------------------!
  260 FORMAT (1H0,30X,38H* * * FLOW AUGMENTATION REQUIRED * * *,//,
     *        5X,100HHEADWATER NO.     HEADWATER IDENTIFICATION     EXIS
     *TING HEADWATER FLOW (CFS)     AUG. REQUIRED (CFS),/)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
  262 FORMAT (1H0,30X,38H* * * FLOW AUGMENTATION REQUIRED * * *,//,
     *        5X,100HHEADWATER NO.     HEADWATER IDENTIFICATION     EXIS
     *TING HEADWATER FLOW (m3/s)   AUG. REQUIRED (m3/s),/)
CBR                                        !
CBR                                        !
CBR----------------------------------------!
      DO 270 NHW=1,NHWTRS
CBR----------------------------------------!
CBR                                        !
CBR                                        !
      QX1=HWFLOW(NHW)
      QX2=QAUG(NHW)
      IF(METOUT.EQ.0) GO TO 33
      QX1=QX1/35.3233
      QX2=QX2/35.3233
   33 WRITE (NJ,275) NHW,(HWTRID(NHW,J),J=1,5),QX1,QX2
CBR                                        !
CBR                                        !
CBR----------------------------------------!
CBR     WRITE (NJ,275) NHW,(HWTRID(NHW,J),J=1,5),HWFLOW(NHW),QAUG(NHW)
  275 FORMAT (8X,I5,12X,5A4,16X,F10.1,20X,F10.1)
  270 CONTINUE
      DO 380 NHW=1,NHWTRS
      HWFLOW(NHW) = HWFLOW(NHW) + QAUG(NHW)
  380 CONTINUE
      GO TO 310
  300 CONTINUE
CCC
CCC             NCASI Commentary, FLOAUG - Section J. (QUAL2 Step 5-0)
CCC                     J. Final augmentation summary.
CCC
CBR      WRITE (NJ,261)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
      IF(METOUT.EQ.0) WRITE (NJ,261)
      IF(METOUT.NE.0) WRITE (NJ,263)
CBR                                        !
CBR                                        !
CBR----------------------------------------!
  261 FORMAT (1H0,33X,32HTOTAL FLOW AUGMENTATION REQUIRED,//,
     *5X,101HHEADWATER NO.     HEADWATER IDENTIFICATION      INITIAL  HE
     *ADWATER FLOW (CFS)     AUG. REQUIRED (CFS),/)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
  263 FORMAT (1H0,33X,32HTOTAL FLOW AUGMENTATION REQUIRED,//,
     *5X,101HHEADWATER NO.     HEADWATER IDENTIFICATION      INITIAL  HE
     *ADWATER FLOW (m3/s)   AUG. REQUIRED (m3/s),/)
CBR                                        !
CBR                                        !
CBR----------------------------------------!
      DO 305 NHW=1,NHWTRS
CBR----------------------------------------!
CBR                                        !
CBR                                        !
      QX1=HWFLOW(NHW)
      QX2=QATOT(NHW)
      IF(METOUT.EQ.0) GO TO 34
      QX1=QX1/35.3233
      QX2=QX2/35.3233
34    HWFLOI=QATOT(NHW)
CBR                                        !
CBR                                        !
CBR----------------------------------------!
      QATOT(NHW)=HWFLOW(NHW)-HWFLOI
      HWFLOW(NHW)=HWFLOI
CBR      WRITE (NJ,275) NHW,(HWTRID(NHW,J),J=1,5),HWFLOW(NHW),QATOT(NHW)
CBR----------------------------------------!
CBR                                        !
CBR                                        !
      WRITE (NJ,275) NHW,(HWTRID(NHW,J),J=1,5),QX1,QX2
CBR                                        !
CBR                                        !
CBR----------------------------------------!
  305 CONTINUE
  310 CONTINUE
CCC
CCC             NCASI Commentary, FLOAUG - Section K.
CCC                     K. Return to MAIN.
CCC
      RETURN
      END
