      SUBROUTINE FOEA
C
C       THIS SUBROUTINE PERFORMS THE COMPUTATIONS AND WRITES THE FINAL 
C       UNCAS REPORT FOR THE FOEA OPTION.  OUTPUT CONSISTS OF A NORMALIZED
C       SENSITIVITY COEFFICIENT MATRIX AND A COMPONENTS OF VARIANCE
C       MATRIX.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C
      DIMENSION Y(MLOC),STDV(MLOC),PVAR(MLOC),VAR(MLOC),STODAT(MLOC)
      DIMENSION MDATA(10),IVAR(MSIM),SPVAR(MLOC)
C3P1 -------  10/11/89
      DIMENSION MM(10)
      DATA MM/10*0/
C3P1
C
C +++++
C      INTEGER*2 CONOUT,MSGFIL
C      DATA CONOUT,MSGFIL / 7,9 /
C +++++
C
C      OPEN FILE CONTAINING STORED DATA FOR FOEA ANALYSIS
C
C      NJ2=2
C      OPEN(UNIT=NJ2,STATUS='OLD',FILE='STORE.DAT')
C
      OPEN(UNIT=NJ2,FILE=FILNAM(8),STATUS='OLD',ERR=990)
C
      DO 100 M=1,NOVAR
C
C      READ MDATA ARRAY FOR OUTPUT SCREENING
C
      DO 135 I=1,NOVAR
      READ(NJ2,126) (MDATA(K),K=1,10)
      IF(I.NE.M) GO TO 135
      DO 137 K=1,10
C3P1   ------  10/11/89
C  137   IF(MDATA(K).EQ.1) MM=K
137   MM(K)=MDATA(K)
C3P1
135   CONTINUE
C
C      READ BASE CASE
C
      READ(NJ2,10) I
10    FORMAT(I5)
      DO 15 J=1,NOVAR
      READ(NJ2,11) (STODAT(K),K=1,NTLOC)
11    FORMAT(8E14.6/)
      IF(J.NE.M) GO TO 15
      DO 12 K=1,NTLOC
12    Y(K) = STODAT(K)
15    CONTINUE
C
C      READ MDATA ARRAY FOR INPUT SCREENING.  COMPARE LINKAGE OF
C      PERTURBED INPUT VARIABLE TO CURRENT OUTPUT VARIABLE. IF NONE,
C      NO ANALYSIS REQUIRED.  PROCEED TO THE NEXT OUTPUT VARIABLE.
C
      IFECT=0
      DO 125 I=1,NSIM
      READ(NJ2,126) (MDATA(K),K=1,10)
126   FORMAT(10I5)
C3P1  -----  10/11 89
      DO 1125 KM=1,10
      M1 = MM(KM)
      IF(M1.EQ.0) GO TO 1125
      NVAR(I) = MDATA(KM)
      IF(NVAR(I).EQ.0) GO TO 1125
      IFECT=1
      GO TO 125
1125  CONTINUE
C3P1
125   CONTINUE
      IF(IFECT.EQ.0) GO TO 102
C
C      SET UP DELTA Y MATRIX (OUTPUT SENSITIVITIES).
C
      DO 20 I=1,NSIM
      READ(NJ2,10) JSENS
C      ERROR TRAP FOR MISREAD OF STORED DATA
      IF(JSENS.NE.I) GO TO 95
      DO 25 J=1,NOVAR
      READ(NJ2,11) (STODAT(K),K=1,NTLOC)
      IF(J.NE.M) GO TO 25
      DO 22 K=1,NTLOC
      DY(I,K) = STODAT(K)-Y(K)
22    CONTINUE
25    CONTINUE
20    CONTINUE
C
C      COMPUTE SENSITIVITY/VARIANCE MATRICES
C      NOTE DY BECOMES VARIANCE COMPONENT AFTER STATEMENT 32-3
C
      DO 30 K=1,NTLOC
      SUM = 0.0
      DO 32 I=1,NSIM
C3PS
C3PS    CHANGE DEFAULT SENMAT TO 0.0
C3PS      SENMAT(I,K) = 1000.
C3PS
      SENMAT(I,K) = 0.0
C +++++
      IF(ABS(Y(K)).GT.1.0E-6) SENMAT(I,K) = DY(I,K)/(Y(K)*SVALUE(I,1))
C +++++
      AV = SVALUE(I,2)*DY(I,K)/SVALUE(I,1)
      DY(I,K) = AV*AV
      SUM = SUM + AV*AV
32    CONTINUE
      VAR(K) = SUM
30    CONTINUE
C
C      WRITE SENSITIVITY COEFFICIENT MATRIX, ONLY IF AT LEAST ONE VALUE
C      IS GREATER THAN 0.10.
C
      WRITE(NJ,50) M
50    FORMAT(1H1//'  2. FIRST ORDER ERROR ANALYSIS: RESPONSE',
     *  ' NO.',I4/)
      WRITE(NJ,51) (TITLE(1,J),J=6,20),(TITLE(2,J1),J1=6,20)
51    FORMAT(/5X,'A. TITLE OF DATA SET.'//2(10X,15A4/))
      WRITE(NJ,52) VAROT(M)
52    FORMAT(/5X,'B. RESPONSE VARIABLE:',2X,A4/)
      WRITE(NJ,53) VAROT(M)
53    FORMAT(/5X,'C. NORMALIZED SENSITIVITY COEFFICIENT MATRIX:',
     * 2X,A4,//38X,'L O C A T I O N'/8X,'INPUT VAR'/)
      GO TO (110,120,130,140,150) NLOC
110   CONTINUE
      WRITE(NJ,112) (JR(K),K=1,NLOC)
112   FORMAT(19X,1(7X,'REACH',I3))
      WRITE(NJ,114) (JE(K),K=1,NLOC)
114   FORMAT(20X,1(5X,'ELEMENT',I3))
      GO TO 160
120   CONTINUE
      WRITE(NJ,122) (JR(K),K=1,NLOC)
122   FORMAT(19X,2(7X,'REACH',I3))
      WRITE(NJ,124) (JE(K),K=1,NLOC)
124   FORMAT(20X,2(5X,'ELEMENT',I3))
      GO TO 160
130   CONTINUE
      WRITE(NJ,132) (JR(K),K=1,NLOC)
132   FORMAT(19X,3(7X,'REACH',I3))
      WRITE(NJ,134) (JE(K),K=1,NLOC)
134   FORMAT(20X,3(5X,'ELEMENT',I3))
      GO TO 160
140   CONTINUE
      WRITE(NJ,142) (JR(K),K=1,NLOC)
142   FORMAT(19X,4(7X,'REACH',I3))
      WRITE(NJ,144) (JE(K),K=1,NLOC)
144   FORMAT(20X,4(5X,'ELEMENT',I3))
      GO TO 160
150   CONTINUE
      WRITE(NJ,54) (JR(K),K=1,NLOC)
54    FORMAT(19X,5(7X,'REACH',I3))
      WRITE(NJ,55) (JE(K),K=1,NLOC)
55    FORMAT(20X,5(5X,'ELEMENT',I3))
160   CONTINUE
      JV=0
      DO 60 I=1,NSIM
      IF(NVAR(I).EQ.0) GO TO 60
      JPRT=0
      DO 465 J=1,NTLOC
465   IF(ABS(SENMAT(I,J)).GT.0.10) JPRT=1
      IF(JPRT.EQ.1) GO TO 165
      JV=JV+1
      IVAR(JV) = I
      GO TO 60
165   CONTINUE
      WRITE(NJ,61) (VCODE(I,1,J),J=1,2),(SENMAT(I,J1),J1=1,NLOC)
61    FORMAT(/8X,2A4,4X,5(3X,F10.3,2X))
60    CONTINUE
C
C     WRITE NAMES OF INPUTS WITH NON-ZERO COEFFICIENTS, BUT WITH VALUES
C     LESS THAN 0.10 AT THE LOCATIONS SPECIFIED.
C
      WRITE(NJ,264)
264   FORMAT(///8X,'  OTHER INPUTS WITH NORMALIZED SENSITIVITY COEF',
     * 'FICIENTS LESS THAN 0.10  EACH.'//)
      DO 261 K=1,JV,5
      DO 262 I=1,5
      IK = K+I-1
      VCODE(I,MVAR,1) = '    '
      VCODE(I,MVAR,2) = '    '
      J = IVAR(IK)
      IF(IK.GT.JV) GO TO 262
      VCODE(I,MVAR,1) = VCODE(J,1,1)
      VCODE(I,MVAR,2) = VCODE(J,1,2)
262   CONTINUE
      WRITE(NJ,265) ((VCODE(I,MVAR,J),J=1,2),I=1,5)
265   FORMAT(8X,5(7X,2A4))
261   CONTINUE
C
C      WRITE COMPONENTS OF VARIANCE MATRIX, ONLY IF AT LEAST ONE VALUE
C      IS GREATER THAN 1.0%.
C
      WRITE(NJ,65) VAROT(M)
65    FORMAT(1H1///5X,'D. COMPONENTS OF VARIANCE MATRIX:',2X,A4//
     * 38X,'L O C A T I O N'/8X,'INPUT VAR'/)
      GO TO (210,220,230,240,250) NLOC
210   CONTINUE
      WRITE(NJ,112) (JR(K),K=1,NLOC)
      WRITE(NJ,114) (JE(K),K=1,NLOC)
      GO TO 260
220   CONTINUE
      WRITE(NJ,122) (JR(K),K=1,NLOC)
      WRITE(NJ,124) (JE(K),K=1,NLOC)
      GO TO 260
230   CONTINUE
      WRITE(NJ,132) (JR(K),K=1,NLOC)
      WRITE(NJ,134) (JE(K),K=1,NLOC)
      GO TO 260
240   CONTINUE
      WRITE(NJ,142) (JR(K),K=1,NLOC)
      WRITE(NJ,144) (JE(K),K=1,NLOC)
      GO TO 260
250   CONTINUE
      WRITE(NJ,54) (JR(K),K=1,NLOC)
      WRITE(NJ,55) (JE(K),K=1,NLOC)
260   CONTINUE
      JV=0
      DO 72 J=1,NTLOC
72    SPVAR(J)=0.0
      DO 70 I=1,NSIM
      IF(NVAR(I).EQ.0) GO TO 70
      JPRT=0
      DO 75 J=1,NTLOC
      STDV(J) = SQRT(DY(I,J))
      PVAR(J)=0.0
      IF(VAR(J).GT.1.E-08) PVAR(J) = DY(I,J)/VAR(J)*100.
      IF(PVAR(J).GT.1.0) JPRT=1
75    CONTINUE
      IF(JPRT.EQ.1) GO TO 175
      JV=JV+1
      IVAR(JV)=I
      GO TO 70
175   CONTINUE
      WRITE(NJ,71) (VCODE(I,1,J),J=1,2)
71    FORMAT(/8X,2A4)
      MP=0
      DO 170 J=1,NLOC
170   IF(DY(I,J).GE.100.) MP=1
      IF(MP.EQ.1) GO TO 171
      WRITE(NJ,76) (DY(I,J),J=1,NLOC)
76    FORMAT(10X,'VAR   ',4X,5(5X,F8.4,2X))
      WRITE(NJ,77) (PVAR(J),J=1,NLOC)
77    FORMAT(10X,'VAR(%)',4X,5(2X,'(',F6.2,'%)',4X))
      WRITE(NJ,78) (STDV(J),J=1,NLOC)
78    FORMAT(10X,'STDEV ',4X,5(5X,F8.3,2X))
      GO TO 179
171   CONTINUE
      WRITE(NJ,176) (DY(I,J),J=1,NLOC)
176   FORMAT(10X,'VAR   ',4X,5(3X,F10.1,2X))
      WRITE(NJ,77) (PVAR(J),J=1,NLOC)
C +++++
C177   FORMAT(10X,'VAR(%)',4X,5(2X,'(',F6.2,'%)',4X))
C +++++
      WRITE(NJ,78) (STDV(J),J=1,NLOC)
178   FORMAT(10X,'STDEV ',4X,5(3X,F10.2,2X))
179   CONTINUE
      DO 79 J=1,NTLOC
79    SPVAR(J)=SPVAR(J)+PVAR(J)
70    CONTINUE
      MP=0
      DO 190 J=1,NLOC
190   IF(VAR(J).GE.100.) MP=1
      IF(MP.EQ.1) GO TO 191
      WRITE(NJ,80) (VAR(J),J=1,NLOC)
80    FORMAT(//8X,'SUM'/10X,'VAR   ',4X,5(5X,F8.3,2X))
      GO TO 192
191   WRITE(NJ,180) (VAR(J),J=1,NLOC)
180   FORMAT(//8X,'SUM'/10X,'VAR   ',4X,5(3X,F10.1,2X))
192   CONTINUE
      DO 81 J=1,NTLOC
      PVAR(J) = 100.
      STDV(J) = SQRT(VAR(J))
81    CONTINUE
      WRITE(NJ,82) (SPVAR(J),J=1,NLOC)
82    FORMAT(10X,'VAR(%)',4X,5(2X,'(',F6.2,'%)',4X))
      IF(MP.EQ.1) GO TO 193
      WRITE(NJ,78) (STDV(J),J=1,NLOC)
      GO TO 194
193   WRITE(NJ,178) (STDV(J),J=1,NLOC)
194   CONTINUE
C
C      WRITE THE NAMES OF INPUTS WITH NON-ZERO VARIANCE COMPONENTS,
C      BUT HAVING VALUES LESS THAN 1.0% AT THE LOCATIONS SPECIFIED.
C
      WRITE(NJ,270)
270   FORMAT(///8X,'  OTHER INPUTS AFFECTING OUTPUT VARIANCE BY',
     * ' LESS THAN 1.0% EACH.'//)
      DO 271 K=1,JV,5
      DO 272 I=1,5
      IK = K+I-1
      VCODE(I,MVAR,1) = '    '
      VCODE(I,MVAR,2) = '    '
      J = IVAR(IK)
      IF(IK.GT.JV) GO TO 272
      VCODE(I,MVAR,1) = VCODE(J,1,1)
      VCODE(I,MVAR,2) = VCODE(J,1,2)
272   CONTINUE
      WRITE(NJ,275) ((VCODE(I,MVAR,J),J=1,2),I=1,5)
275   FORMAT(8X,5(7X,2A4))
271   CONTINUE
C
C      WRITE SUMMARY MESSAGE TO CTY
C
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,101) M,NOVAR,VAROT(M)
101   FORMAT(///////////,
     * 13X,'FOEA summary for response',I4,' of',I4,': ',A4,' complete.')
102   REWIND NJ2
100   CONTINUE
      GO TO 99
95    WRITE(NJ,96) I
96    FORMAT(//2X,'$$$$$ERROR IN READING (DEV NJ2) FOEA DATA,',
     * ' SIMULATION NUMBER:',I4//)
99    CLOSE(UNIT=NJ2)
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)FILNAM(8)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING STORED FOEA ANALYSIS DATA FILE',
     2     /,'   ',A64,
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
      END
