      SUBROUTINE GROW
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
        INCLUDE 'CONST.INC'
C
C               TEST DYNAMIC/SS SIMULATION
        IF(ISS.GT.0) GO TO 40
C               TEST FOR DYNAMIC TEMPERATURE
        IF(MODOPT(2).GT.0) GO TO 20
C               SOLAR VALUES FROM LCD
        RF = SOLHR/CKL
        AF = 1.0
        GO TO 99
C               SOLAR VALUES FROM HEATEX
20      SUNNY = 0
        IF(TSOLHR.GT.0.0) SUNNY = TFACT*TSOLHR
        RF = SUNNY/CKL
        AF = 1.0
C +++++
C        IF(ITEMP.EQ.0.OR.TPRINT.EQ.PTIME) GO TO 25
        RDIF=TPRINT-PTIME
        IF(ITEMP.EQ.0.OR.ABS(RDIF).LT.R0MIN) GO TO 25
C +++++
        SUNNZ = SUNNY/3.685
        WRITE(NJ,26) TOFDAY,SUNNY,SUNNZ
26      FORMAT(/'  DYNAMIC ALGAE SIMULATION:'/
     18X,'TIME OF DAY =  ',F10.3/
     28X,'SOLAR RADIATION FOR ALGAE =  ',F10.3,
     2' BTU/FT-2   OR',F10.3,' LANGLEYS'///)
25      CONTINUE
        GO TO 99
C       INITIALIZATION FOR STEADY STATE LIGHT PARAMETERS
40      IF(IPASS.GT.0) GO TO 99
C               TEST LIGHT AVERAGING OPTION
        GO TO (50,60,70,80) LAVOPT
C               LAVOPT = 1
50      SONET = TFACT*BASNET
        DLH = BADLH
        AF = AFACT*DLH/24.0
        RF = SONET/(DLH*CKL)
        GO TO 99
C               LAVOPT = 2
60      AF = AFACT*DLH/24.0
        RF = SONET/(DLH*CKL)
        GO TO 99
C               LAVOPT = 3
70      NDLH = 0
        DO 75 L=1,24
        SUN(L) = 0.0
        IF(BATSUN(L).GT.0.0) SUN(L) = TFACT*BATSUN(L)
        R(L) = SUN(L)/CKL
        IF(SUN(L).LE.0.00) GO TO 75
        NDLH = NDLH + 1
75      CONTINUE
        AF = 1.0
        GO TO 99
C               LAVOPT = 4
80      NDLH = DLH
        SOAVE = SONET/NDLH
        DHR = FLOAT(NDLH) + 1.0
        DO 82 L=1,NDLH
        XL = L
        ARG = 2.0*3.14159*XL/DHR
        SUN(L) = SOAVE*(1.0-COS(ARG))
82      R(L) = SUN(L)/CKL
        J=NDLH + 1
        DO 84 L=J,24
        SUN(L) = 0.0
84      R(L) = 0.0
        AF = 1.0
99      CONTINUE
C               LOOP ON REACHES
        DO 200 I=1,NREACH
        NCELR = NCELRH(I)
        DO 200 J=1,NCELR
        IOR = ICLORD(I,J)
        AGFL(IOR) = 1.0
        AGFP(IOR) = 1.0
        AGFN(IOR) = 1.0
        TC = 0.556*(T(IOR)-68.0)
C               LIGHT EXTINCTION COEFF
        CHLA=ALPHAO(I)*ALGAE(IOR)
        EXTC(IOR) = EXCOEF(I)+EXALG1*CHLA+EXALG2*(CHLA**.667)
        EF = EXTC(IOR)
        ZF = DEPTH(IOR)
C
C +++++
C
        IF(ABS(-EF*ZF).GE.88.0) THEN
          XF=0.0
        ELSE
          XF = EXP(-EF*ZF)
        ENDIF
C
C +++++
C
      DENOM = EF*ZF
C               TEST FOR DYNAMIC SS SIMULATION
        IF(ISS.GT.0) GO TO 110
        CALL LIGHT(LFNOPT,AF,RF,XF,DENOM,FL)
        AGFL(IOR) = FL
        GO TO 160
110     GO TO (120,120,130,130) LAVOPT
120     CALL LIGHT(LFNOPT,AF,RF,XF,DENOM,FL)
        AGFL(IOR) = FL
        GO TO 160
130     SUM = 0.0
        DO 135 L=1,24
        RF = R(L)
        CALL LIGHT(LFNOPT,AF,RF,XF,DENOM,FL)
135     SUM = SUM + FL
        AGFL(IOR) = SUM/24.0
C               NUTRIENT GROWTH FACTORS
160     CPE = PHOS(IOR)
        IF(MODOPT(5).NE.0) AGFP(IOR) = CPE/(CKP+CPE)
        CNE =  CNO3(IOR)+CNH3(IOR)
        IF(MODOPT(6).NE.0) AGFN(IOR) = CNE/(CKN+CNE)
C               GROWTH ATTENUATION OPTION
        GO TO (170,180,190) LGROPT
C               LGROPT = 1
170     FNPL = AGFL(IOR)*AGFP(IOR)*AGFN(IOR)
        GO TO 195
C               LGROPT = 2
180     FNP = AMIN1(AGFN(IOR),AGFP(IOR))
        FNPL = AGFL(IOR)*FNP
        GO TO 195
C               LGROPT = 3
190     FNP = (1.0/AGFN(IOR))+(1.0/AGFP(IOR))
        FNPL = AGFL(IOR)*2.0/FNP
C               TEMPERATURE ADJUST
195     Z(IOR) = GROMAX*FNPL*(THETA(13)**TC)
200     CONTINUE
        RETURN
        END
