      SUBROUTINE HEATER
C
C                             HEATEX COMPUTES THE NET AMOUNT OF HEAT
C                             RADIATION FLUX BEING TRANSFERRED ACROSS
C                             THE AIR-WATER INTERFACE BASED ON AN
C                             ENERGY BUDGET WHICH CONSIDERS SOLAR
C                             RADIATION, ATMOSPHERIC RADIATION, BACK
C                             RADIATION, CONDUCTION, AND EVAPORATION.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
C       INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
C       INCLUDE 'HDWTRS.VAR'
C       INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
C       INCLUDE 'WASTLD.VAR'
        INCLUDE 'CONST.INC'
CC
CCC
CCC             NCASI Commentary, HEATER - Section B. (QUAL2 Step 1-0)
CCC                     B. Compute and/or define required
CCC                         constants.
CCC
C      PI=3.141628         <---Moved to BLOCK DATA subroutine.
      CON1=2.0*PI/365.0
      CON2=PI/180.0*LAT
      CON3=180.0/PI
      CON4=23.45*PI/180.0
      CON5=PI/12.0
      CON6=12.0/PI
      DELTSL=(LLM-LSM)/15.0
      SOLCON=438.0
CCC             NCASI Commentary, HEATER - Section C. (QUAL2 Step 2-0)
CCC                     C. Begin computations for calculating
CCC                         the net solar radiation term.
CCC
CCC                     C.1a Calculate seasonal and daily
CCC                           position of sun relative to the
CCC                           location of the basin on the earth's
CCC                           surface. (QUAL2 Step 2-1)
CCC
      REARTH=1.0+0.017*COS(CON1*(186.0-DAYOFY))
      DECLIN=CON4*COS(CON1*(172.0-DAYOFY))
      RR=REARTH**2
      EQTIME=0.000121-0.12319*SIN(CON1*(DAYOFY-1.0)-0.07014)
     *       -0.16549*SIN(2.0*CON1*(DAYOFY-1.0)+0.3088)
      DECLON=ABS(DECLIN)
CC
CC              Change TAN to  SIN/COS.
CC
        TANA = SIN(CON2)/COS(CON2)
        TANB = SIN(DECLON)/COS(DECLON)
        ACS = TANA*TANB
CC
C +++++
C      IF (ACS.EQ.0.0) GO TO 8
      IF (ABS(ACS).LT.R0MIN) GO TO 8
C +++++
      XX=SQRT(1.0-ACS*ACS)
      XX=XX/ACS
      ACS=ATAN(XX)
      IF (DECLIN.GT.0.0) ACS=PI-ACS
      GO TO 9
    8 ACS=PI/2.0
    9 CONTINUE
CCC
CCC                     C.1a Calculate the standard time of
CCC                           sunrise(STR) and sunset (STS).
CCC                           (QUAL2 Step 2-2)
CCC
CQT
      DO 100 I=1,NREACH
      TSONET(I) = 0.0
      ELEXP = EXP(-RCHELV(I)/2532.0)
CCC
CCC                     C.8 Compute vapor pressures (VPWB and
CCC                          VPAIR), dew point (DEWPT), and
CCC                          dampening effect of clouds (CS and
CCC                          CNL). (QUAL2 Step 2-4)
CCC
      VPWB=0.1001*EXP(0.03*RCHTWB(I))-0.0837
      VPAIR=VPWB-0.000367*RCHATM(I)*(RCHTDB(I)-RCHTWB(I))
     *     *(1.0+(RCHTWB(I)-32.0)/1571.0)
      DEWPT=ALOG((VPAIR+0.0837)/0.1001)/0.03
      CS=1.0-0.65*RCHCLD(I)**2
      IF (RCHCLD(I).GT.0.9) CS=0.50
      CNL=RCHCLD(I)*10.0+1.0
      NL=CNL
C +++++
C      IF (TOFDAY.NE.0.0) GO TO 77
      IF (TOFDAY.GT.R0MIN) GO TO 77
C +++++
CQT
      STR=12.0-CON6*ACS+DELTSL
      STS=24.0-STR+2.0*DELTSL
      STB=0.0
      STE=STB+D2LT
      GO TO 78
CCC
CCC                     C.2 Increment the variables that define
CCC                          the time of the beginning (STB)
CCC                          and end (STE) of the time interval.
CCC
   77 STB=STB+D2LT
      STE=STB+D2LT
   78 CONTINUE
        KT = TOFDAY + 1.0
C +++++
C   82 CONTINUE
      CONTINUE
C +++++
      IF (STS.LE.STB.OR.STR.GE.STE) GO TO 35
      IF(STR.GT.STB.AND.STR.LT.STE) GO TO 41
      IF (STS.LT.STE.AND.STS.GT.STB) GO TO 42
CCC
CCC             NCASI Commentary, HEATER - Section D.
CCC                     D. Continue with calculations for the
CCC                         net solar radiation.
CCC
CCC                     D.1 Calculate hour angles (TB and TE).
CCC                          (QUAL2 Step 2-5)
CCC
      TB=STB-12.0-DELTSL+EQTIME
      TE=STE-12.0-DELTSL+EQTIME
      GO TO 43
   41 TB=STR-12.0-DELTSL+EQTIME
      TE=STE-12.0-DELTSL+EQTIME
      GO TO 43
   42 TB=STB-12.0-DELTSL+EQTIME
      TE=STS-12.0-DELTSL+EQTIME
   43 CONTINUE
      TALT=(TB+TE)/2.0
CCC
CCC                     D.2 Compute amount of clear sky, solar
CCC                          radiation (SOLAR), and altitude of
CCC                          the sun (ALPHA). (QUAL2 Step 2-6)
CCC
      SOLAR=SOLCON/RR*(SIN(CON2)*SIN(DECLIN)*(TE-TB)+CON6*COS(CON2)*
     *      COS(DECLIN)*(SIN(CON5*TE)-SIN(CON5*TB)))
      ALPHA=SIN(CON2)*SIN(DECLIN)+COS(CON2)*COS(DECLIN)*COS(CON5*TALT)
C +++++
C      IF (ABS(ALPHA).LT.RP1MIN) GO TO 4
      IF (ABS(ALPHA).EQ.1.0) GO TO 4
C +++++
      Y=SQRT(1.0-ALPHA*ALPHA)
      Y=ALPHA/Y
      ALPHA=ATAN(Y)
      GO TO 5
C +++++
C    4  IF (ABS(ALPHA).LT.RP1MIN) GO TO 6
    4 IF (ALPHA.EQ.-1.0) GO TO 6
C +++++
      ALPHA=PI/2.0
      GO TO 5
    6 ALPHA=-PI/2.0
    5 CONTINUE
      IF (ALPHA.LT.0.01) GO TO 35
CCC
CCC                     D.3 Compute absorption and scattering due
CCC                          to atmospheric conditions. (QUAL2
CCC                          Step 2-7)
CCC
      PWC=0.00614*EXP(0.0489*DEWPT)
      OAM=ELEXP/(SIN(ALPHA)+0.15*(ALPHA*CON3+3.885)**(-1.253))
      A1=EXP(-(0.465+0.0408*PWC)*(0.129+0.171*EXP(-0.880*OAM))*OAM)
      A2=EXP(-(0.465+0.0408*PWC)*(0.179+0.421*EXP(-0.721*OAM))*OAM)
CCC
CCC                     D.4 Compute reflectivity coefficient, RS.
CCC                          (QUAL2 Step 2-8)
CCC
CCC
CCC                     D.5 Compute atmospheric transmission term.
CCC
      GO TO (30,31,31,31,31,31,32,32,32,32,33), NL
   30 AR=1.18
      BR=-0.77
      GO TO 34
   31 AR=2.20
      BR=-0.97
      GO TO 34
   32 AR=0.95
      BR=-0.75
      GO TO 34
   33 AR=0.35
      BR=-0.45
   34 CONTINUE
      RS=AR*(CON3*ALPHA)**BR
CC
CC              Add a test for reflectivity greater than 1.0
CC
        IF(RS.GE.1.0) GO TO 35
CC
      ATC=(A2+0.5*(1.0-A1-RCHDAC(I)))/(1.0-0.5*RS*(1.0-A1+RCHDAC(I)))
CCC
CCC             NCASI Commentary, HEATER - Section E. (QUAL2 Step 2-9)
CCC                     E. Calculation of average net daily
CCC                         solar radiation.
CCC
CC
CC          NCASI Modifications.
CC              Calculate hourly solar radiation as TSUN(I,KT) and
CC          accumulate values in TSONET.  Continue through the
CC          24 hours of the day.  Then write the average value
CC          (TSONET/24.) into the RCHSOL(I) array.
CC
      TSUN(I,KT)=SOLAR*ATC*CS*(1.0-RS)*RCHSAT(I)
      GO TO 36
   35 TSUN(I,KT)=0.0
   36 CONTINUE
        TSONET(I) = TSONET(I) + TSUN(I,KT)
      TOFDAY=TOFDAY+D2LT
      IF (TOFDAY.LT.23.9) GO TO 77
      TOFDAY=0.
      RCHSOL(I) = TSONET(I)/24.0
        TDLH(I) = STS-STR
100   CONTINUE
CCC
CCC             NCASI Commentary, HEATER - Section F.
CCC                     F. Return to TEMPSS.
CCC
      RETURN
      END
