      SUBROUTINE HEATEX
C
C                             HEATEX COMPUTES THE NET AMOUNT OF HEAT
C                             RADIATION FLUX BEING TRANSFERRED ACROSS
C                             THE AIR-WATER INTERFACE BASED ON AN
C                             ENERGY BUDGET WHICH CONSIDERS SOLAR
C                             RADIATION, ATMOSPHERIC RADIATION, BACK
C                             RADIATION, CONDUCTION, AND EVAPORATION.
CC
C  UPDATED 6/84 T.WILSON FOR IBM - TO CORRECT APARRENT TYPO
CC
        INCLUDE 'MAIN.VAR'
C       INCLUDE 'ARRAYS.VAR'
C       INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
C       INCLUDE 'HDWTRS.VAR'
C       INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
C       INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
        INCLUDE 'CONST.INC'
CC
C
CCC
CCC             NCASI Commentary, HEATEX Section A. (QUAL2 Step 1-0)
CCC                     A. Compute and/or define required constants.
CCC
C
C +++++
C      IF (TOFDAY.NE.0.0) GO TO 77
      IF (ABS(TOFDAY).GT.R0MIN) GO TO 77
C +++++
C
C      PI=3.141628           <---Moved to BLOCK DATA subroutine.
      CON1=2.0*PI/365.0
      CON2=PI/180.0*LAT
      CON3=180.0/PI
      CON4=23.45*PI/180.0
      CON5=PI/12.0
      CON6=12.0/PI
      DELTSL=(LLM-LSM)/15.0
      SOLCON=438.0
      ELEXP=EXP(-ELEV/2532.0)
CCC
CCC             NCASI Commentary, HEATEX Section B. (QUAL2 Step 2-0)
CCC                     B. Begin computations  for calculating the
CCC                         net solar radiation term.
CCC
CCC                     B.1 Test for beginning of a new day.
CCC
CDD    Branch for TOFDAY moved to same location as in HEATER.
C
CCC
CCC                     B.1a Calculate seasonal and daily position
CCC                           of the sun relative to the location
CCC                           of the basin on the earth's
CCC                           surface. (QUAL2 Step 2-1)
CCC
      REARTH=1.0+0.017*COS(CON1*(186.0-DAYOFY))
      DECLIN=CON4*COS(CON1*(172.0-DAYOFY))
      RR=REARTH**2
      EQTIME=0.000121-0.12319*SIN(CON1*(DAYOFY-1.0)-0.07014)
     *       -0.16549*SIN(2.0*CON1*(DAYOFY-1.0)+0.3088)
      DECLON=ABS(DECLIN)
CC
CC              Replace TAN function with SIN/COS.
CC
        TANA = SIN(CON2)/COS(CON2)
        TANB = SIN(DECLON)/COS(DECLON)
        ACS = TANA*TANB
CC
C +++++
C      IF (ACS.EQ.0.0) GO TO 8
      IF (ABS(ACS).LT.R0MIN) GO TO 8
C +++++
      XX=SQRT(1.0-ACS*ACS)
      XX=XX/ACS
C ->-> CHANGED ATAN(X) TO ATAN(XX) TO CORRECT APPARENT TYPO. <-<-
C ->->    -T.WILSON 6/15/84   <-<-
C      ACS=ATAN(X)
      ACS=ATAN(XX)
      IF (DECLIN.GT.0.0) ACS=PI-ACS
      GO TO 9
    8 ACS=PI/2.0
    9 CONTINUE
CCC
CCC                     B.1a Calculate the standard time of
CCC                           sunrise (STR) and sunset (STS).
CCC                           (QUAL2 Step 2-2)
CCC
C      IF (TOFDAY.NE.0.0) GO TO 77
C
      STR=12.0-CON6*ACS+DELTSL
      STS=24.0-STR+2.0*DELTSL
      STB=0.0
      STE=STB+D2LT
      GO TO 78
CCC
CCC                     B.2 Increment the variables that define the
CCC                          time of the beginning(STB) and the
CCC                          end (STE) of the time interval.
CCC
   77 STB=STB+D2LT
      STE=STB+D2LT
   78 CONTINUE
CCC
CCC                     B.3 Test if time to read in local
CCC                          climatological data. (QUAL2 Step 2-3)
CCC
C +++++
C      IF (ABS(TRLCD).GT.RP1MIN) GO TO 82
      IF (TRLCD.NE.1.0) GO TO 82
C +++++
CCC
CCC                     B.7 Compute vapor pressures (VPWB and
CCC                          VPAIR), dew point (DEWPT), AND
CCC                          dampening effect of clouds (CNS
CCC                          and CNL). (QUAL2 Step 2-4)
CCC
      VPWB=0.1001*EXP(0.03*WETBLB)-0.0837
      VPAIR=VPWB-0.000367*ATMPR*(DRYBLB-WETBLB)
     *     *(1.0+(WETBLB-32.0)/1571.0)
      DEWPT=ALOG((VPAIR+0.0837)/0.1001)/0.03
      CS=1.0-0.65*CLOUD**2
      IF (CLOUD.GT.0.9) CS=0.50
      CNL=CLOUD*10.0+1.0
      NL=CNL
82    CONTINUE
      IF (STS.LE.STB.OR.STR.GE.STE) GO TO 35
      IF(STR.GT.STB.AND.STR.LT.STE) GO TO 41
      IF (STS.LT.STE.AND.STS.GT.STB) GO TO 42
CCC
CCC             NCASI Commentary, HEATEX Section C. (QUAL2 Step 2-5)
CCC                     C. Continue with calculations for solar
CCC                         radiation.
CCC
CCC                     C.1 Calculate hour angles (TB and TE).
CCC
      TB=STB-12.0-DELTSL+EQTIME
      TE=STE-12.0-DELTSL+EQTIME
      GO TO 43
   41 TB=STR-12.0-DELTSL+EQTIME
      TE=STE-12.0-DELTSL+EQTIME
      GO TO 43
   42 TB=STB-12.0-DELTSL+EQTIME
      TE=STS-12.0-DELTSL+EQTIME
   43 CONTINUE
      TALT=(TB+TE)/2.0
CCC
CCC                     C.2 Compute amount of clear sky, solar
CCC                          radiation(SOLAR), and altitude of
CCC                          the sun (ALPHA). (QUAL2 Step 2-6)
CCC
      SOLAR=SOLCON/RR*(SIN(CON2)*SIN(DECLIN)*(TE-TB)+CON6*COS(CON2)*
     *      COS(DECLIN)*(SIN(CON5*TE)-SIN(CON5*TB)))
      ALPHA=SIN(CON2)*SIN(DECLIN)+COS(CON2)*COS(DECLIN)*COS(CON5*TALT)
C +++++
C      IF (ABS(ALPHA).LT.RP1MIN) GO TO 4
      IF (ABS(ALPHA).EQ.1.0) GO TO 4
C +++++
      Y=SQRT(1.0-ALPHA*ALPHA)
      Y=ALPHA/Y
      ALPHA=ATAN(Y)
      GO TO 5
C +++++
C    4  IF (ABS(ALPHA).LT.RP1MIN) GO TO 6
    4 IF (ALPHA.EQ.-1.0) GO TO 6
C +++++
      ALPHA=PI/2.0
      GO TO 5
    6 ALPHA=-PI/2.0
    5 CONTINUE
      IF (ALPHA.LT.0.01) GO TO 35
CCC
CCC                     C.3 Compute absorption and scattering due
CCC                          to atmospheric conditions. (QUAL2
CCC                          Step 2-7)
CCC
      PWC=0.00614*EXP(0.0489*DEWPT)
      OAM=ELEXP/(SIN(ALPHA)+0.15*(ALPHA*CON3+3.885)**(-1.253))
      A1=EXP(-(0.465+0.0408*PWC)*(0.129+0.171*EXP(-0.880*OAM))*OAM)
      A2=EXP(-(0.465+0.0408*PWC)*(0.179+0.421*EXP(-0.721*OAM))*OAM)
CCC
CCC                     C.4 Compute reflectivity coefficient (RS).
CCC                          (QUAL2 Step 2-8)
CCC
      GO TO (30,31,31,31,31,31,32,32,32,32,33), NL
   30 AR=1.18
      BR=-0.77
      GO TO 34
   31 AR=2.20
      BR=-0.97
      GO TO 34
   32 AR=0.95
      BR=-0.75
      GO TO 34
   33 AR=0.35
      BR=-0.45
   34 CONTINUE
      RS=AR*(CON3*ALPHA)**BR
CC
CC              Add test for RS greater than 1.0.
CC
        IF(RS.GE.1.0) GO TO 35
CC
CCC
CCC                     C.5 Compute atmospheric transmission term (ATC).
CCC
      ATC=(A2+0.5*(1.0-A1-DAT))/(1.0-0.5*RS*(1.0-A1+DAT))
CCC
CCC                     C.6 Compute net solar radiaiont for the time
CCC                          interval delta t. (QUAL2 Step 2-9)
CCC
      TSOLHR=SOLAR*ATC*CS*(1.0-RS)
      GO TO 36
   35 TSOLHR=0.0
   36 CONTINUE
      CLC=1.0+0.17*CLOUD**2
CCC
CCC             NCASI Commentary, HEATEX Section D. (QUAL2 Step 3-0)
CCC                     D. Compute heat fluxes from other terms.
CCC
CCC                     D.1 Long wave atmospheric radiation (HA).
CCC
      HA=0.97*1.73E-09*2.89E-06*(DRYBLB+460.0)**6*CLC*D2LT
CCC
CCC                     D.2 Water surface back radiation (HB).
CCC
      DO 70 I=1,NREACH
      NCELR=NCELRH(I)
      DO 70 J=1,NCELR
      IOR=ICLORD(I,J)
      VPW=0.1001*EXP(0.03*T(IOR))-0.0837
      HB=0.97*1.73E-09*(T(IOR)+460.0)**4*D2LT
CCC
CCC                     D.3 Evaporation (HE).
CCC
      EVAP=62.4*(AE+BE*WIND)
      HE=EVAP*(VPW-VPAIR)*(1084.0-0.5*T(IOR))*D2LT
CCC
CCC                     D.4 Conduction (HC).
CCC
      HC=0.01*EVAP*(DRYBLB-T(IOR))*(1084.0-0.5*T(IOR))*D2LT
CCC
CCC             NCASI Commentary, HEATEX Section E.
CCC                     E. Compute net heat flux from all sources.
CCC
      HSNET(IOR)=TSOLHR+HA-HB+HC-HE
   70 CONTINUE
      TOFDAY=TOFDAY+D2LT
      IF(ITEMP.EQ.0) GO TO 71
      TSLR = TSOLHR/3.685
      WRITE(NJ,93) TOFDAY,TSOLHR,TSLR
93    FORMAT(///'  DYNAMIC TEMPERATURE SIMULATION:'/
     18X,'TIME OF DAY =  ',F10.3/
     28X,'HOURLY SOLAR RADIATION =  ',F8.3,' BTU/FT-2
     3 OR ',F9.3,' LANGLEYS')
71    CONTINUE
CCC
CCC             NCASI Commentary, HEATEX Section F.
CCC                     F. Test for beginning of a new day.
CCC
      IF (TOFDAY.LT.23.9) GO TO 85
      TOFDAY=0.0
      DAYOFY=DAYOFY+1.0
   85 CONTINUE
CCC
CCC             NCASI Commentary, HEATEX Section G.
CCC                     G. Return to TEMPS.
CCC
      RETURN
      END
