      SUBROUTINE HYDRAU
C
C                             HYDRAU PERFORMS A HYDROLOGIC BALANCE ON
C                             THE SYSTEM BASED ON CONTINUITY. IT
C                             COMPUTES THE FLOW, VELOCITY, VOLUME,
C                             DEPTH, AND DISPERSION COEFFICIENT FOR
C                             EVERY ELEMENT IN THE SYSTEM.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
CCC
CCC             NCASI Commentary, HYDRAU - SECTION A. (QUAL2 Step 1-0)
CCC                     A. Initialize constants in the system.
CCC
      NHW=0
      NWS=0
      IJUNC=0
CCC
CCC             NCASI Commentary, HYDRAU - SECTION B. (QUAL2 Step 2-0)
CCC                     B. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
      QR=QI(I)/CNCELR
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
      IFL=IFLAG(I,J)
CC
CC              Insert a dummy DO loop index, ICHAN, to avoid the
CC               index modification error message during compilation.
CC              Then swap ICHAN for I in the CALL CHANL statements.
CC
      ICHAN = I
CC
      GO TO (101,102,102,103,102,104,104), IFL
CCC
CCC             NCASI Commentary, HYDRAU - SECTION C. (QUAL2 Step 2-1)
CCC                     C. Hydraulics for Type 1 element.
CCC
  101 NHW=NHW+1
      FLOW(IOR)=HWFLOW(NHW)+QR
      IF(FLOW(IOR).LE.0.0) GO TO 150
      CALL CHANL(ICHAN,HWFLOW(NHW),VHW(NHW),DEPHW(NHW),IOR)
      DLHW(NHW)=3.82*DISKO(I)*CMANN(I)*VHW(NHW)*DEPHW(NHW)**0.833
      CALL CHANL(ICHAN,FLOW(IOR),VEL(IOR),DEPTH(IOR),IOR)
      DTOVCL(IOR)=DT2ODX/(HWFLOW(NHW)/VHW(NHW)+FLOW(IOR)/VEL(IOR))
      GO TO 105
CCC
CCC             NCASI Commentary, HYDRAU - SECTION D. (QUAL2 Step 2-2)
CCC                     D. Hydraulics for Type 2, 3, and 5
CCC                         elements.
CCC
  102 FLOW(IOR)=FLOW(IOR-1)+QR
      IF(FLOW(IOR).LE.0.0) GO TO 150
      CALL CHANL(ICHAN,FLOW(IOR),VEL(IOR),DEPTH(IOR),IOR)
      DTOVCL(IOR)=DT2ODX/(FLOW(IOR-1)/VEL(IOR-1)+FLOW(IOR)/VEL(IOR))
      GO TO 105
CCC
CCC             NCASI Commentary, HYDRAU - SECTION E. (QUAL2 Step 2-3)
CCC                     E. Hydraulics for Type 4 element.
CCC
  103 IJUNC=IJUNC+1
      NS=1
      NN=JUNC(IJUNC,NS)
      FLOW(IOR)=FLOW(IOR-1)+FLOW(NN)+QR
      IF(FLOW(IOR).LE.0.0) GO TO 150
      CALL CHANL(ICHAN,FLOW(IOR),VEL(IOR),DEPTH(IOR),IOR)
CC
CC              Change definition of DTOVCL coefficient to reflect
CC               the average over three adjoining elements.
CC
      DT3ODX = 1.5*DT2ODX
CC
      DTOVCL(IOR)=DT3ODX/(FLOW(IOR-1)/VEL(IOR-1)+FLOW(IOR)/VEL(IOR)+
     *            FLOW(NN)/VEL(NN))
CC
      GO TO 105
CCC
CCC             NCASI Commentary, HYDRAU - SECTION F. (QUAL2 Step 2-4)
CCC                     F. Hydraulics for Type 6 and 7 elements.
CCC
  104 NWS=NWS+1
      FLOW(IOR)=FLOW(IOR-1)+WSFLOW(NWS)+QR
      IF(FLOW(IOR).LE.0.0) GO TO 150
      CALL CHANL(ICHAN,FLOW(IOR),VEL(IOR),DEPTH(IOR),IOR)
      DTOVCL(IOR)=DT2ODX/(FLOW(IOR-1)/VEL(IOR-1)+FLOW(IOR)/VEL(IOR))
  105 CONTINUE
      DL(IOR)=3.82*DISKO(I)*CMANN(I)*VEL(IOR)*DEPTH(IOR)**0.833
CCC
CCC             NCASI Commentary, HYDRAU - SECTION G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
      GO TO 175
150   WRITE(NJ,155) IOR
155   FORMAT(//'  NEGATIVE FLOW COMPUTED IN ELEMENT',
     1 I5,', EXECUTION TERMINATED'/
     2 /6X,'ELEMENT',7X,'FLOW'/)
      DO 160 K=1,IOR
160   WRITE(NJ,161) K,FLOW(K)
161   FORMAT(6X,I5,4X,F10.3)
C//   CALL EXIT
      STOP
175   CONTINUE
CCC
CCC             NCASI Commentary, HYDRAU - SECTION H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
