      SUBROUTINE IFOAMC
C
C      THIS SUBROUTINE CONTROLS THE INPUT SPECIFICATIONS FOR FOEA AND MCS
C      BY DETERMINING EXACTLY WHICH OF THE INPUT VARIABLES ARE TO BE PERTURBED
C      IN THE CURRENT SIMULATION.  INPUTS NOT USED ARE SCREENED OUT.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C
C +++++
C      CHARACTER*4 VDATAC(2),UD4,UD5
      CHARACTER*4 VDATAC(2)
C +++++
C3P1      CHARACTER*4 VDATAC(2)
      CHARACTER*2 PDF
      CHARACTER*1 BLANK
C
      DIMENSION MDATA(10)
      DATA BLANK/' '/
C
C     INITIALIZE  VARIABLES, WRITE HEADINGS FOR LISTING THE INPUT
C     VARIABLES TO BE PERTURBED/RANDOMIZED FOR UNCERTAINTY ANALYSIS.
C
C3P1    MOVE OPEN/CLOSE FOR STORE.DAT FILE TO UNCAS.
C3P1
C3P1      NJ2 = 2
C3P1      OPEN(UNIT=NJ2,STATUS='OLD',ACCESS='APPEND',FILE='STORE.DAT')
C3P1      OPEN(UNIT=NJ2,STATUS='OLD',ACCESS='APPEND',FILE=FILNAM(8))
      NP=1
      JSENS=1
      K2OP1=0
      K2OP7=0
      K2OP8=0
      DO 2 I=1,NREACH
      IF(K2OPT(I).EQ.1) K2OP1=1
      IF(K2OPT(I).EQ.7) K2OP7=1
      IF(K2OPT(I).EQ.8) K2OP8=1
2     CONTINUE
      IF(INTYPE.EQ.2) WRITE(NJ,4)
4     FORMAT(1H1,//'  SUMMARY OF FIRST ORDER ERROR ANALYSIS INPUT',
     * ' VARIANCE CONDITIONS'/2X,63('-')//)
      IF(INTYPE.EQ.3) WRITE(NJ,15) NMCS
15     FORMAT(1H1,//'  SUMMARY OF MONTE CARLO INPUT VARIANCE',
     * ' CONDITIONS',8X,I5,' SIMULATIONS'/2X,48('-')//)
      IF(INTYPE.EQ.2) WRITE(NJ,16)
16     FORMAT(44X,'INPUT',6X,'MAGNITUDE',7X,'RELATIVE'/
     * 44X,'DATA',8X,'OF INPUT',7X,'STANDARD'/
     * 12X,'INPUT VARIABLE OR PARAMETER',5X,'TYPE',6X,'PERTURBATION',5X,
     * 'DEVIATION'/
     * 58X,'(%)',13X,'(%)'//)
      IF(INTYPE.EQ.3) WRITE(NJ,17)
17     FORMAT(44X,'INPUT',6X,'RELATIVE'/
     * 44X,'DATA',7X,'STANDARD',7X,'INPUT'/
     * 12X,'INPUT VARIABLE OR PARAMETER',5X,'TYPE',7X,'DEVIATION',7X,
     * 'PDF'/58X,'(%)'//)
C
C     SEARCH THROUGH ALL INPUT VARIBLES (UCODE.DAT) FOR THOSE TO BE
C     PERTURBED.   THE PURPOSE IS TO SCREEN OUT THOSE NOT REQUESTED IN
C     UNCAS TYPE 4 DATA, AND PURGE THOSE INPUTS AND/OR MODEL OPTIONS
C     NOT USED IN THE BASE CASE. 
C
      NI3 = 3
      IF (IU.EQ.1.AND.UCPATH(1:1).EQ.BLANK) THEN
          OPEN(UNIT=NI3,FILE='UCODE.DAT',STATUS='OLD',ERR=990)
      ELSE
          OPEN(UNIT=NI3,FILE=UCPATH(1:IU)//'UCODE.DAT',
     1         STATUS='OLD',ERR=990)
      ENDIF
C
C      OPEN USER SUPPLIED FILE 'INVAR' TO READ APPROPRIATE INPUT
C      UNCERTAINTY INFORMATION (VARIANCE AND/OR PDF).
C
      NI4 = 4
C      OPEN(UNIT=NI4,STATUS='OLD',FILE=INVAR)
      OPEN(UNIT=NI4,FILE=FILNAM(5),STATUS='OLD',ERR=991)
C
C     SKIP TWO HEADER LINES IN INVAR.DAT
C
      READ(NI4,210)
210   FORMAT(/)
5     CONTINUE
C3P1
C3P1  MOVE NITROGEN-OXYGEN LINKS TO OMATCH
C3P1
C3P1      IF(KNITRF.GE.10.0) GO TO 40
      READ(NI3,21,END=25) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(K),K=1,10)
21    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,2X,10I1)
C3P1      GO TO 41
C3P1 40    CONTINUE
C3P1       READ(NI3,22,END=25) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
C3P1     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(K),K=1,10)
C3P1 22    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,14X,10I1)
C3P1 41    CONTINUE
C
C      PURGE GENERIC INPUTS NOT REQUESTED IN UNCAS4 DATA.
C
      IF(UDATAC(1).NE.'IN') GO TO 5
      LTP = UDATAR(1)
      IF(INCON.EQ.2) GO TO 51
      IF(KFLIN(LTP).EQ.0) GO TO 5
51    CONTINUE
      GO TO (11,12,13,14,14,14,119) LTP
11    CONTINUE
C
C      PURGE GLOBAL OPTIONS NOT USED
C
      IF(UDATAC(4).EQ.'NHIB'.AND.KNITRF.GE.10.0)GO TO 5
      IF(UDATAC(4).EQ.'5TOU'.AND.TITLE(7,6).NE.' 5-D') GO TO 5
      IF(UDATAC(4).EQ.'NUMB'.AND.LAVOPT.EQ.1) GO TO 6
      IF(UDATAC(4).EQ.'NUMB'.AND.LAVOPT.EQ.3) GO TO 6
      IF(UDATAC(4).EQ.'LAVG'.AND.LAVOPT.GT.2) GO TO 5
      IF(UDATAC(4).EQ.'A/TF'.AND.LAVOPT.EQ.2) GO TO 5
      IF(UDATAC(4).EQ.'A/TF'.AND.LAVOPT.EQ.4) GO TO 5
      IF(UDATAC(4).EQ.'AGYN'.AND.MODOPT(6).EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'AGYP'.AND.MODOPT(5).EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'NHAL'.AND.MODOPT(6).EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'PHAL'.AND.MODOPT(5).EQ.0) GO TO 5
      GO TO 19
6     READ(NI3,21,END=25) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17)
      GO TO 5
C
C      PURGE HYDRAULIC OPTIONS NOT USED
C
12    IF(UDATAC(4).EQ.'TRAP'.AND.ITRAP.EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'EXPO'.AND.ITRAP.NE.0) GO TO 5
      IF(UDATAC(4).EQ.'COEF'.AND.ITRAP.NE.0) GO TO 5
      GO TO 19
C
C      PURGE REACTION COEFFICIENTS NOT USED
C
13    CONTINUE
      IF(UDATAC(4).EQ.'K2-O'.AND.K2OP1.EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'CQK2'.AND.K2OP7.EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'EQK2'.AND.K2OP7.EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'K2CO'.AND.K2OP8.EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'K2SL'.AND.K2OP8.EQ.0) GO TO 5
      IF(UDATAC(4).EQ.'K2OP') GO TO 5
      IF(UDATAC(4).EQ.'INIT'.AND.MODOPT(2).EQ.1) GO TO 5
      GO TO 19
C
C      PURGE FORCING FUNCTIONS NOT USED
C
14    IF(UDATAC(5).EQ.'CM2 '.AND.NCS.LE.1) GO TO 5
      IF(UDATAC(5).EQ.'CM3 '.AND.NCS.LE.2) GO TO 5
      GO TO 19
C
C      PURGE DAM OPTIONS NOT USED
C
119   IF(NDAM.EQ.0) GO TO 5
19    CONTINUE
C
C     PURGE INPUT VARIABLE FROM FOEA/MC ANALYSIS IF ITS BASE CASE
C     VALUE IS ZERO (I.E. NOT USED).
C
      INDEX=UDATAR(2)
      MTYPE=UDATAR(1)
      CALL ZEROP(NP,INDEX,MTYPE,LUP,IZERO)
      IF(IZERO.EQ.0) GO TO 5
C
C      USING THE MDATA MATRIX FOR THE INPUT VARIABLE, PURGE INPUTS
C      NOT USED WITH THE MODEL OPTIONS SPECIFIED IN THE BASE CASE.  
C      STORE THE MODIFIED MDATA MATRIX FOR SUBSEQUENT OUTPUT PROCESSING.
C 
      ISIM = 0
      DO 30 I=1,10
      IF(MDATA(I).EQ.1) ISIM=1
      IF(MODOPT(I).EQ.0) MDATA(I)=0
30    CONTINUE
      IF(ISIM.EQ.0) GO TO 5
      ISIM=0
      DO 32 I=1,10
32    IF(MDATA(I).EQ.1) ISIM=1
      IF(ISIM.EQ.0) GO TO 5
      WRITE(NJ2,35) (MDATA(K),K=1,10)
35    FORMAT(10I5)
C
C      SEARCH THE INVAR FILE FOR APPROPRIATE INPUT VARIABLE
C      VARIANCE INFORMATION.
C
60    CONTINUE
      READ(NI4,61) (VDATAC(I),I=1,2),STEMP,PDF
61    FORMAT(35X,2A4,12X,F5.0,7X,A2)
      IF(VDATAC(1).NE.UDATAC(4)) GO TO 60
      IF(VDATAC(2).NE.UDATAC(5)) GO TO 60
      SVALUE(JSENS,2) = STEMP
      NRVT(JSENS) = 1
      IF(PDF.EQ.'LN') NRVT(JSENS) = 2
C-LCB  ADD UNIFORM PDF OPTION  3/19/88
      IF(PDF.EQ.'UN') NRVT(JSENS) = 3
C-LCB
C
C      ALL INPUT PURGING AND READING TESTS COMPLETE.  STORE AND WRITE
C      INPUT VARIABLE TO BE PERTURBED IN THIS UNCERTAINTY SIMULATION.
C
      VCODE(JSENS,NP,1) = UDATAC(4)
      VCODE(JSENS,NP,2) = UDATAC(5)
      SVALUE(JSENS,1) = PDX
      PCVAL=SVALUE(JSENS,2)*100.
      PTURB = SVALUE(JSENS,1)*100.
      IF(INTYPE.EQ.3) WRITE(NJ,27) JSENS,(UDATAC(K),K=11,17),UDATAC(3),
     * PCVAL,PDF
27    FORMAT(3X,I6,3X,7A4,5X,A4,6X,F7.2,10X,A2)
      IF(INTYPE.EQ.2) WRITE(NJ,28) JSENS,(UDATAC(K),K=11,17),UDATAC(3),
     * PTURB,PCVAL
28    FORMAT(3X,I6,3X,7A4,5X,A4,6X,F7.1,9X,F7.2)
      NVAR(JSENS) = NP
      JSENS=JSENS+1
C
C      LOOP TO NEXT VARIABLE IN UCODE.DAT
C
      GO TO 5
25    CONTINUE
      NSIM=JSENS-1
      CLOSE(UNIT=NI4)
      CLOSE(UNIT=NI3)
C3P1      CLOSE(UNIT=NJ2)
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING UNCERTAINTY INPUT DATA FILE',
     2     /,'   UCODE.DAT',
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
 991  CALL CLRSCR
      WRITE(CONOUT,9951)FILNAM(5)
 9951 FORMAT(/////////////////////,
     1       '** ERROR OPENING UNCAS INPUT VARIANCE FILE',
     2     /,'   ',A64,
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
      END
