      SUBROUTINE INSENS
C
C      THIS SUBROUTINE READS UNCAS8 DATA AND CONTROLS THE INPUT
C      SPECIFICATIONS FOR SENSITIVITY ANALYSIS.  IT DETERMINES THE
C      TOTAL NUMBER OF SENSITIVITY SIMULATIONS TO BE PERFORMED AND
C      THE LEVELS OF ALL VARIABLES TO BE PERTURBED IN EACH SIMULATION.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C
      CHARACTER*4 UNCAS8(3),SVAR(2),UNDAT,UNDAT8,UNCAS
      CHARACTER*1 BLANK
      DIMENSION MDATA(10)
      DATA UNCAS/'UNCA'/
      DATA UNCAS8/'SING','MULT','FACT'/
      DATA BLANK/' '/
C
C      TEST FOR FACTORIAL DESIGN
C
      GO TO (1,100) INCON
1     CONTINUE
C
C      READ UNCAS8 DATA, SINGLE/MULTIPLE INPUT VARIABLES TO BE
C      PERTURBED FOR SENSITIVITY ANALYSIS.  LOOP THROUGH DATA
C      UNTIL INPUT CONDITIONS FOR ALL SENSITIVITY SIMULATIONS HAVE BEEN
C      READ AND STORED.
C
      JSENS = 1
      INVC = 1
5     CONTINUE
CBR      READ(NI,10,END=999) UNDAT,L,UNDAT8,NVAR8,(SVAR(I),I=1,2),VAL8
      READ(NI,10,END=999) UNDAT,L,UNDAT8,NVAR8,(SVAR(I),I=1,2),VAL8,
     *                    NVAL8
CBR10    FORMAT(A4,1X,I1,24X,A4,10X,I1,3X,2A4,1X,F6.0)
10    FORMAT(A4,1X,I1,24X,A4,10X,I1,3X,2A4,1X,F6.0,2X,I4)
      IF(UNDAT.EQ.UNCAS.AND.L.EQ.9) GO TO 90
      IF(UNDAT.NE.UNCAS.OR.L.NE.8) GO TO 95
      IF(UNDAT8.EQ.UNCAS8(1)) GO TO 20
      IF(UNDAT8.EQ.UNCAS8(2)) GO TO 30
      WRITE(NJ,12)
12    FORMAT(//2X,'????? ERROR TRAP ON SENSITIVITY READ INPUT NOT',
     *  ' RECOGNIZED ?????'//)
      GO TO 999
C
C       THIS BRANCH IS FOR SINGLE VARIABLE PERTURBATIONS
C
20    NV = 1
      GO TO 40
C
C      THIS BRANCH IS FOR MULTIPLE VARIABLE PERTURBATIONS
C
30    CONTINUE
      NV = NVAR8
40    VCODE(JSENS,INVC,1) = SVAR(1)
      VCODE(JSENS,INVC,2) = SVAR(2)
      SVALUE(JSENS,INVC) = VAL8/100.
CBR
      JTEM(JSENS,INVC) = NVAL8
CBR
C
C      TEST FOR NEXT VARIABLE IN MULTIPLE PERTURBATIONS
C
      INVC = INVC + 1
      IF(INVC.GT.NV) GO TO 50
      GO TO 5
50    NVAR(JSENS) = NV
C
C      TEST FOR NEXT SENSITIVITY SIMULATION
C
      JSENS = JSENS + 1
      IF(JSENS.GT.MSIM) GO TO 92
      INVC=1
      GO TO 5
C
90    NSIM = JSENS-1
      GO TO 99
92    WRITE(NJ,93)
93    FORMAT(//2X,'????? TOO MANY SIMULATIONS REQUESTED ?????'//)
      GO TO 999
95    WRITE(NJ,96)
96    FORMAT(//2X,'????? ERROR IN SENSITIVITY(S/M) INPUT',
     *  ' FORMAT ?????'//)
      GO TO 999
C
99    CONTINUE
      CLOSE(UNIT=NI)
      RETURN
C
C     BRANCH FOR FACTORIAL DESIGN
C
100   CONTINUE
C
C      READ UNCAS8 DATA, FACTORIAL DESIGN INPUT VARIABLES TO BE
C      PERTURBED FOR SENSITIVITY ANALYSIS.
C
      NV=NFVARS
      NSIM = 2**NV
      DO 130 I=1,NV
CBR      READ(NI,10,END=999) UNDAT,L,UNDAT8,NVAR8,(SVAR(IX),IX=1,2),VAL8
      READ(NI,10,END=999) UNDAT,L,UNDAT8,NVAR8,(SVAR(IX),IX=1,2),VAL8,
     *                    NVAL8
CBR
      IF(UNDAT.EQ.UNCAS.AND.L.EQ.9) GO TO 199
      IF(UNDAT.NE.UNCAS.OR.L.NE.8) GO TO 195
      IF(UNDAT8.EQ.UNCAS8(3)) GO TO 120
      WRITE(NJ,115)
115   FORMAT(//2X,'????? ERROR TRAP ON FACTORIAL READ, INPUT NOT',
     *  ' RECOGNIZED. ?????'//)
      GO TO 999
C
120   CONTINUE
      SVALLO(I)= -VAL8/100.
      SVALHI(I)= VAL8/100.
      DO 130 J=1,NSIM
      VCODE(J,I,1) = SVAR(1)
      VCODE(J,I,2) = SVAR(2)
CBR
      JTEM(J,I) = NVAL8
CBR
130   CONTINUE
      GO TO 199
195   WRITE(NJ,196)
196   FORMAT(//2X,'????? ERROR IN SENSITIVITY(FDES) INPUT',
     *  ' FORMAT ?????',//)
      GO TO 999
199   CONTINUE
C
C      RETRIEVE MDATA MATRIX FROM UCODE.DAT FOR LATER OUTPUT VARIABLE
C      SCREENING FOR FACTORIAL DESIGN ANALYSIS.  THE MDATA MATRIX LINKS
C      EACH INPUT VARIABLE TO BE PERTURBED TO THE MODEL OPTIONS SELECTED
C      BY THE USER IN THE BASE CASE.
C
C3P1    MOVE OPEN/CLOSE OF STORE.DAT FILE TO UNCAS.
C3P1
C3P1      NJ2=2
C3P1      OPEN(UNIT=NJ2,STATUS='OLD',ACCESS='APPEND',FILE='STORE.DAT')
C3P1      OPEN(UNIT=NJ2,STATUS='OLD',ACCESS='APPEND',FILE=FILNAM(8))
      NI3 = 3
      IF (IU.EQ.1.AND.UCPATH(1:1).EQ.BLANK) THEN
          OPEN(UNIT=NI3,FILE='UCODE.DAT',STATUS='OLD',ERR=990)
      ELSE
          OPEN(UNIT=NI3,FILE=UCPATH(1:IU)//'UCODE.DAT',
     1         STATUS='OLD',ERR=990)
      ENDIF
C
      DO 140 I=1,NFVARS
55    CONTINUE
C3P1
C3P1 MOVE NITROGEN-OXYGEN LINK CHECK TO OMATCH
C3P1
C3P1      IF(KNITRF.GE.10.0) GO TO 42
C
C     SEARCH UCODE.DAT FOR A MATCH OF INPUT VARIBLE TO BE PERTURBED,
C     THEN STORE THE MDATA MATRIX.
C
      READ(NI3,21,END=25) UDATAC(1),UDATAR(1),(UDATAC(J),J=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(K),K=1,10)
21    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,2X,10I1)
C3P1      GO TO 41
C3P1 42    CONTINUE
C3P1      READ(NI3,22,END=25) UDATAC(1),UDATAR(1),(UDATAC(J),J=2,3),
C3P1     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(K),K=1,10)
C3P1 22    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,14X,10I1)
C3P1 41    CONTINUE
      IF(UDATAC(1).NE.'IN') GO TO 55
      IF(UDATAC(4).NE.VCODE(1,I,1)) GO TO 55
      IF(UDATAC(5).NE.VCODE(1,I,2)) GO TO 55
      WRITE(NJ2,35) (MDATA(K),K=1,10)
35    FORMAT(10I5)
      GO TO 26
25    WRITE(NJ,115)
      GO TO 999
26    REWIND NI3
140   CONTINUE
      CLOSE(UNIT=NI3)
C3P1      CLOSE(UNIT=NJ2)
C
C      SET UP EACH 2-LEVEL FACTORIAL DESIGN SENSITIVITY SIMULATION
C
      NV = NFVARS
      DO 210 I=1,NSIM
      JSENS = I
      DO 220 J=1,NV
      V = SVALLO(J)
      IF(LD(J,JSENS).GT.0) V=SVALHI(J)
      SVALUE(JSENS,J) = V
220   CONTINUE
      NVAR(I) = NV
210   CONTINUE
C
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING UNCERTAINTY INPUT DATA FILE',
     2     /,'   UCODE.DAT',
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
C
 999  STOP
      END
