      SUBROUTINE MCSIM
C
C      THIS SUBROUTINE PERFORMS THE COMPUTATIONS AND WRITES THE FINAL UNCAS
C      REPORT FOR THE MCS OPTION.  THE REPORT CONSISTS OF SUMMARY STATISTICS
C      AND FREQUENCY DISTRIBUTIONS FOR EACH OUTPUT VARIABLE REQUESTED IN
C      UNCAS6 DATA.
C 
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C
      DIMENSION Y(MLOC),SUM1(MLOC),SUM2(MLOC),SUM3(MLOC)
      DIMENSION MDATA(10),SUM4(MLOC)
      DIMENSION DMIN(MLOC),DMAX(MLOC),RANGE(MLOC)
C
C +++++
C      INTEGER*2 CONOUT,MSGFIL
C      DATA CONOUT,MSGFIL / 7,9 /
C +++++
C
      DO 100 M=1,NOVAR
C
C      OPEN FILE CONTAINING DATA STORED FOR MCS ANALYSIS.
C
C      NJ2=2
      OPEN(UNIT=NJ2,FILE=FILNAM(8),STATUS='OLD',ERR=990)
C      OPEN(UNIT=NJ2,STATUS='OLD',FILE='STORE.DAT')
C
C      READ MDATA ARRAY FOR OUTPUT SCREENING (IGNORE).
C
      DO 135 I=1,NOVAR
      READ(NJ2,126) (MDATA(K),K=1,10)
      IF(I.NE.M) GO TO 135
      DO 137 K=1,10
137   IF(MDATA(K).EQ.1) MM=K
135   CONTINUE
C
C      READ BASE CASE
C
      READ(NJ2,10) I
10    FORMAT(I5)
      DO 15 J=1,NOVAR
      READ(NJ2,11) (SDATA(K),K=1,NLOC)
11    FORMAT(8E14.6/)
      IF(J.NE.M) GO TO 15
      DO 12 K=1,NLOC
12    Y(K) = SDATA(K)
15    CONTINUE
C
C      READ MDATA ARRAY FOR INPUT SCREENING (IGNORE).
C
      DO 125 I=1,NSIM
      READ(NJ2,126) (MDATA(K),K=1,10)
126   FORMAT(10I5)
125   CONTINUE
C
C     EXTRACT DATA FOR ANALYSIS
C
      DO 19 K=1,NLOC
      SUM1(K)=0.0
      SUM2(K)=0.0
      SUM3(K)=0.0
      SUM4(K)=0.0
      DMIN(K)=+1.0E+10
      DMAX(K)=-1.0E+10
      RANGE(K)=0.0
19    CONTINUE
C
      XN=NMCS
      DO 20 I=1,NMCS
      READ(NJ2,10) JSENS
C       ERROR TRAP FOR MISREAD OF STORED DATA
      IF(JSENS.NE.I) GO TO 95
      DO 25 J=1,NOVAR
      READ(NJ2,11) (SDATA(K),K=1,NLOC)
      IF(J.NE.M) GO TO 25
      DO 22 K=1,NLOC
      DY(I,K) = SDATA(K)
      SUM1(K)=SUM1(K)+SDATA(K)/XN
      IF(SDATA(K).LT.DMIN(K)) DMIN(K)=SDATA(K)
      IF(SDATA(K).GT.DMAX(K)) DMAX(K)=SDATA(K)
22    CONTINUE
25    CONTINUE
20    CONTINUE
      CLOSE(UNIT=NJ2)
C
C      COMPUTE SUMMARY STATISTICS
C
      DO 30 K=1,NLOC
      DO 35 I=1,NMCS
      DY(I,K) = DY(I,K)-SUM1(K)
      SUM2(K)=SUM2(K)+DY(I,K)*DY(I,K)
      SUM3(K)=SUM3(K)+DY(I,K)*DY(I,K)*DY(I,K)
35    CONTINUE
      SUM2(K)=SUM2(K)/(XN-1.0)
      SUM2(K) = SQRT(SUM2(K))
C3PS
C3PS   ADD TEST FOR ZERO STDEV AND COEFF OF VAR
C3PS
      SUM4(K) = 0.0
C +++++
      IF(SUM1(K).NE.0.0) SUM4(K) = SUM2(K)/SUM1(K)
C      IF(SUM1(K).GT.R0MIN) SUM4(K) = SUM2(K)/SUM1(K)
C +++++
      AS3=0.0
      IF(SUM2(K).GT.1.0E-10) AS3=SUM3(K)/(SUM2(K)*SUM2(K)*SUM2(K))
C      IF(SUM2(K).GT.R0MIN) AS3=SUM3(K)/(SUM2(K)*SUM2(K)*SUM2(K))
      SUM3(K)=XN*AS3/((XN-1.0)*(XN-2.0))
      RANGE(K)=DMAX(K)-DMIN(K)
30    CONTINUE
C
C     WRITE SUMMARY STATS
C
      WRITE(NJ,80) M,VAROT(M)
80    FORMAT(1H1//'  MONTE CARLO SIMULATION SUMMARY, RESPONSE',
     * ' NO.',I4,2X,A4//)
      WRITE(NJ,81)
81    FORMAT(/38X,'LOCATION'/6X,'STATISTIC'/)
      GO TO (110,120,130,140,150) NLOC
110   CONTINUE
      WRITE(NJ,112) (JR(K),K=1,NLOC)
112   FORMAT(19X,1(7X,'REACH',I3))
      WRITE(NJ,114) (JE(K),K=1,NLOC)
114   FORMAT(20X,1(5X,'ELEMENT',I3))
      GO TO 160
120   CONTINUE
      WRITE(NJ,122) (JR(K),K=1,NLOC)
122   FORMAT(19X,2(7X,'REACH',I3))
      WRITE(NJ,124) (JE(K),K=1,NLOC)
124   FORMAT(20X,2(5X,'ELEMENT',I3))
      GO TO 160
130   CONTINUE
      WRITE(NJ,132) (JR(K),K=1,NLOC)
132   FORMAT(19X,3(7X,'REACH',I3))
      WRITE(NJ,134) (JE(K),K=1,NLOC)
134   FORMAT(20X,3(5X,'ELEMENT',I3))
      GO TO 160
140   CONTINUE
      WRITE(NJ,142) (JR(K),K=1,NLOC)
142   FORMAT(19X,4(7X,'REACH',I3))
      WRITE(NJ,144) (JE(K),K=1,NLOC)
144   FORMAT(20X,4(5X,'ELEMENT',I3))
      GO TO 160
150   CONTINUE
      WRITE(NJ,54) (JR(K),K=1,NLOC)
54    FORMAT(19X,5(7X,'REACH',I3))
      WRITE(NJ,55) (JE(K),K=1,NLOC)
55    FORMAT(20X,5(5X,'ELEMENT',I3))
160   CONTINUE
C
      WRITE(NJ,180) (Y(K),K=1,NLOC)
180   FORMAT(/7X,'BASE MEAN',4X,5(F13.3,2X))
      WRITE(NJ,181) (SUM1(K),K=1,NLOC)
181   FORMAT(/7X,'SIM MEAN',5X,5(F13.3,2X))
      DO 182 K=1,NLOC
182   Y(K)=SUM1(K)-Y(K)
      WRITE(NJ,183) (Y(K),K=1,NLOC)
183   FORMAT(/9X,'BIAS',7X,5(F13.3,2X))
      WRITE(NJ,187) (DMIN(K),K=1,NLOC)
187   FORMAT(///7X,'MINIMUM',6X,5(F13.3,2X))
      WRITE(NJ,188) (DMAX(K),K=1,NLOC)
188   FORMAT(/7X,'MAXIMUM',6X,5(F13.3,2X))
      WRITE(NJ,189) (RANGE(K),K=1,NLOC)
189   FORMAT(/7X,'RANGE',8X,5(F13.3,2X))
      WRITE(NJ,184) (SUM2(K),K=1,NLOC)
184   FORMAT(/7X,'STD DEV',6X,5(F13.3,2X))
      WRITE(NJ,185) (SUM4(K),K=1,NLOC)
185   FORMAT(/7X,'COEF VAR',5X,5(F13.3,2X))
      WRITE(NJ,186) (SUM3(K),K=1,NLOC)
186   FORMAT(/7X,'SKEW COEF',4X,5(F13.3,2X))
C
C      BEGIN FREQUENCY DISTRIBUTION COMPUTATIONS
C
      DO 39 K=1,NLOC
      DO 39 J=1,18
39    SENMAT(J,K) = 0.0
C
      DO 40 K=1,NLOC
      DO 50 I=1,NMCS
C3PS
C3PS  ADD TEST FOR ZERO STD DEV
C3PS
      ZX = 0.0
C +++++
      IF(SUM2(K).NE.0.0) ZX=DY(I,K)/SUM2(K)
C      IF(SUM2(K).GT.R0MIN) ZX=DY(I,K)/SUM2(K)
C +++++
      IF(ZX.LT.0.0) GO TO 45
      ZX=ZX*10. + 5.0000001
      IZ=ZX/5
      IF(IZ.GT.9) IZ=9
      J=IZ+9
      SENMAT(J,K)=SENMAT(J,K)+1.0
      GO TO 50
45    ZX=-ZX*10.0+5.0000001
      IZ=ZX/5
      IF(IZ.GT.9) IZ=9
      J=10-IZ
      SENMAT(J,K) = SENMAT(J,K)+1.0
50    CONTINUE
      DY(1,K)=SENMAT(1,K)/XN
      DO 48 J=2,18
48    DY(J,K)=DY(J-1,K) + SENMAT(J,K)/XN
40    CONTINUE
C
C      WRITE FREQUENCY DISTRIBUTION
C
      WRITE(NJ,190)
190   FORMAT(//5X,'FREQUENCY',/,9X,'DISTRIBUTION'/
     * 6X,'(STDV FROM MEAN)'/)
      WRITE(NJ,191) (SENMAT(1,K),DY(1,K),K=1,NLOC)
191   FORMAT(20X,5(8X,'CUM REL')/20X,5(2('  FREQ '),1X)//
     * 12X,'LT -4.0 ',5(F7.0,F7.3,1X))
      DO 195 I=2,17
      XP=I-10
      XP1=XP/2.0
      XP2=XP1+0.5
      WRITE(NJ,192) XP1,XP2,(SENMAT(I,K),DY(I,K),K=1,NLOC)
192   FORMAT(6X,F5.1,' TO',F5.1,1X,5(F7.0,F7.3,1X))
195   CONTINUE
      WRITE(NJ,196) (SENMAT(18,K),DY(18,K),K=1,NLOC)
196   FORMAT(12X,'GT +4.0 ',5(F7.0,F7.3,1X))
C
C      WRITE SUMMARY MESSAGE TO CTY.
C
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,101) M,NOVAR,VAROT(M)
101   FORMAT(///////////,
     * 12X,'MC SIM summary for response',I4,' of',I4,': ',A4,
     *     ' complete.')
100   CONTINUE
      GO TO 99
95    WRITE(NJ,96) I
96    FORMAT(//2X,'$$$$$ERROR IN READING (DEV NJ2) MCSIM DATA,',
     * ' SIMULATION NUMBER:',I4//)
      CLOSE(UNIT=NJ2)
99    CONTINUE
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)FILNAM(8)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING STORED FACTORIAL ANALYSIS DATA FILE',
     2     /,'   ',A64,
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
      END
