      SUBROUTINE NH3S
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
C       INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
C       INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'CONST.INC'
CC
CCC
CCC             NCASI Commentary, NH3S - Section A.
CCC                     A. Initialize counters and constants.
CCC
      NHW=0
      NWS=0
      FACT = 1.0 / (28.3 * 86400.0)
CCC
CCC             NCASI Commentary, NH3S - Section B.
CCC                     B. Set up loop on number of reaches and
CCC                         elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + +
      CNH3JI=QI(I)/CNCELR*CNH3I(I)
      CNH3JO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      CNH3JI = 0.0
      CNH3JO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, NH3S - Section C.
CCC                     C. Initialize diagonal and known terms.
CCC
      TC=0.556*(T(IOR)-68.0)
      SRCNH3(IOR) = SNH3(I)*THETA(8)**TC
      AMSRCE = SRCNH3(IOR)*BAREA(IOR)*DTOVCL(IOR)*FACT
      PRF(IOR) = (PREFN*CNH3(IOR))+((1.0-PREFN)*CNO3(IOR))
C +++++
C      IF(PRF(IOR).NE.0) PRF(IOR) = PREFN*CNH3(IOR)/PRF(IOR)
      RTEST=PRF(IOR)
      IF(ABS(RTEST).GT.R0MIN) PRF(IOR) = PREFN*CNH3(IOR)/PRF(IOR)
C +++++
      REACT = KNH2(IOR)*CNH2(IOR)*D1LT
      REACT = REACT - ALPHA1*GROWTH(IOR)*ALGAE(IOR)*PRF(IOR)*D1LT
      B(IOR)=X(IOR)-CNH3JO*DTOVCL(IOR)+D1LT*KNH3(IOR)
      S(IOR)=CNH3(IOR)
      IF (ISS.GT.0) S(IOR)=0.0
      S(IOR)=S(IOR)+REACT+CNH3JI*DTOVCL(IOR) + AMSRCE
CCC
CCC                     C.8 For Type 2, 3,4, and 5 elements
CCC                         the ammonia balance is now complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, NH3S - Section D.
CCC                     D. Ammonia balance for Type 1 element.
CCC
  101 NHW=NHW+1
      S(IOR)=S(IOR)-A(IOR)*HWNH3(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, NH3S - Section E.
CCC                     E. Ammonia balance for Type 6 element.
CCC
  103 NWS=NWS+1
      S(IOR)=S(IOR)+WSFLOW(NWS)*WSNH3 (NWS)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, NH3S - Section F.
CCC                     F. Ammonia balance for Type 7 element.
CCC
  104 NWS=NWS+1
      B(IOR)=B(IOR)-WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*CNH3LB
CCC
CCC             NCASI Commentary, NH3S - Section G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, NH3S - Section H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
