      SUBROUTINE NO3S
CC
        INCLUDE 'MAIN.VAR'
C       INCLUDE 'ARRAYS.VAR'
C       INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
C       INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CCC
CCC             NCASI Commentary, NO3S - Section A.
CCC                     A. Initialize counters.
CCC
      NHW=0
      NWS=0
CCC
CCC             NCASI Commentary, NO3S - Section B.
CCC                     B. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + +  +
      CNO3JI=QI(I)/CNCELR*CNO3I(I)
      CNO3JO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      CNO3JI = 0.0
      CNO3JO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, NO3S - Section C.
CCC                     C. Initialize diagonal and known terms.
CCC
      REACT = D1LT*KNO2(IOR)*CNO2(IOR)
      REACT = REACT-D1LT*ALPHA1*GROWTH(IOR)*ALGAE(IOR)*(1.0-PRF(IOR))
      B(IOR)=X(IOR)-CNO3JO*DTOVCL(IOR)
      S(IOR)=CNO3(IOR)
      IF (ISS.GT.0) S(IOR)=0.0
      S(IOR)=S(IOR)+REACT+CNO3JI*DTOVCL(IOR)
CCC
CCC                     C.6 For Type 2, 3, 4, and 5 elements
CCC                          the nitrate balance is now complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, NO3S - Section D.
CCC                     D. Nitrate balance for Type 1 element.
CCC
  101 NHW=NHW+1
      S(IOR)=S(IOR)-A(IOR)*HWNO3(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, NO3S - Section E.
CCC                     E. Nitrate balance for Type 6 element.
CCC
  103 NWS=NWS+1
      S(IOR)=S(IOR)+WSFLOW(NWS)*WSNO3 (NWS)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, NO3S - Section F.
CCC                     F. Nitrate balance for Type 7 element.
CCC
  104 NWS=NWS+1
      B(IOR)=B(IOR)-WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*CNO3LB
CCC
CCC             NCASI Commentary, NO3S - Section G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, NO3S - Section H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
