      SUBROUTINE OMATCH
C
C      THIS SUBROUTINE RETRIEVES, PURGES, AND STORES (ON DISK FILE) THE
C      APPROPRIATE OUTPUT FROM THE BASE SIMULATION THAT WILL SUBSEQUENTLY
C      BE USED IN THE UNCERTAINTY ANALYSIS CALCULATIONS.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C        
        DIMENSION MDATA(10)
C +++++
        CHARACTER*1 BLANK
C        CHARACTER*4 BLANK4
C
C      DATA BLANK4/'    '/
      DATA BLANK/' '/
C +++++
C
      GO TO (200,300,300) INTYPE
C
200   CONTINUE
C
C         THIS BRANCH IS FOR STORING COMPLETE BASE CASE SIMULATION.
C     STORE BASE SIMULATION FOR DETAILED SENSITIVITY OUTPUT ANALYSIS
C
C3P1      CHANGE NJ2 TO NJ4 FOR BASE.DAT FILE
C3P1
C3P1      NJ4 = 4
      OPEN(UNIT=NJ4,STATUS='UNKNOWN',FILE=FILNAM(7))
C      OPEN(UNIT=NJ4,STATUS='UNKNOWN',FILE='BASE.DAT')
      DO 250 L=1,NCELLS
      WRITE(NJ4,252) L
252   FORMAT(I5)
250   WRITE(NJ4,251) (BASE(L,K),K=1,36)
251   FORMAT(8E14.6/)
      CLOSE(UNIT=NJ4)
      IF(INCON.EQ.2) GO TO 300
      RETURN
C
C     THIS BRANCH IS FOR STORING THE BASE CASE SIMULATION OUTPUT AT
C     SPECIFIC OUTPUTS AND LOCATIONS (FDES, FOEA, AND MCS).
C
300   CONTINUE
C3P1
C3P1    MOVE OPEN/CLOSE FOR STORE.DAT TO UNCAS.
C3P1 
C3P1      NJ2 = 2
C3P1      OPEN(UNIT=NJ2,STATUS='UNKNOWN',FILE=FILNAM(8))
C3P1      OPEN(UNIT=NJ2,STATUS='UNKNOWN',FILE='STORE.DAT')
C
C      SEARCH FOR OUTPUT VARIABLES TO BE STORED/PRINTED
C
      NI3 = 3
      IF (IU.EQ.1.AND.UCPATH(1:1).EQ.BLANK) THEN
          OPEN(UNIT=NI3,FILE='UCODE.DAT',STATUS='OLD',ERR=990)
      ELSE
          OPEN(UNIT=NI3,FILE=UCPATH(1:IU)//'UCODE.DAT',
     1         STATUS='OLD',ERR=990)
      ENDIF
C
      J = 1
340   CONTINUE
      IF(KNITRF.GE.10.0) GO TO 341
      READ(NI3,40,END=360) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     *    UDATAR(2),(UDATAC(II),II=4,17),(MDATA(J2),J2=1,10),MO
40    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,14X,
     * 10I1,2X,I2)
      GO TO 42
341   READ(NI3,41,END=360) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     *    UDATAR(2),(UDATAC(II),II=4,17),(MDATA(J2),J2=1,10),MO
41    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,2X,10I1,
     * 14X,I2)
42    CONTINUE
      IF(UDATAC(1).NE.'OU') GO TO 340
C3P1
      IF(MODOPT(MO).EQ.0) GO TO 340
C3P1
      JTYPE(J)=UDATAR(1)
      KJ = JTYPE(J)
      IF(KFLOUT(KJ).EQ.0) GO TO 340
C
C      PURGE OUTPUT STATE VARIABLES (MODOPT) NOT SIMULATED 
C      IN THE BASE CASE.
C
      ISIM=0
      DO 330 I=1,10
      IF(MDATA(I).EQ.1) ISIM=1
      IF(MODOPT(I).EQ.0) MDATA(I)=0
330   CONTINUE
      IF(ISIM.EQ.0) GO TO 340
      ISIM=0
      DO 332 I=1,10
332   IF(MDATA(I).EQ.1) ISIM=1
      IF(ISIM.EQ.0) GO TO 340
      GO TO (342,344,342) KJ
344   IF(UDATAC(4).EQ.'CM-2'.AND.NCS.LE.1) GO TO 340
      IF(UDATAC(4).EQ.'CM-3'.AND.NCS.LE.2) GO TO 340
342   CONTINUE
C
C      PURGE INTERNAL (ALGAL/NUTRIENT) VARIABLES FOR OPTIONS NOT
C      EXERCISED IN THE BASE CASE.
C
      IF(UDATAC(4).EQ.'NINH'.AND.KNITRF.GE.10.) GO TO 340
      IF(UDATAC(4).EQ.'NH3F'.AND.PREFN.GE.0.99) GO TO 340
      IF(UDATAC(4).EQ.'NH3F'.AND.PREFN.LE.0.01) GO TO 340
      IF(UDATAC(4).EQ.'AGFN'.AND.MODOPT(6).EQ.0) GO TO 340
      IF(UDATAC(4).EQ.'AGFP'.AND.MODOPT(5).EQ.0) GO TO 340
C
C     WRITE MDATA FLAGS.  MDATA IS A MATRIX THAT LINKS EACH STORED OUTPUT
C     VARIABLE TO THE MODEL OPTION SELECTED IN THE BASE CASE.
C
      WRITE(NJ2,346) (MDATA(I),I=1,10)
346   FORMAT(10I5)
C
C      LOCATE AND RETRIEVE DESIRED OUTPUTS FOR STORING
C
      INDEX = UDATAR(2)
      INDXO(J) = INDEX
      VAROT(J) = UDATAC(4)
      JTYPE(J) = UDATAR(1)
C3P1
C3P1   DO 351 L=1,NLOC
      DO 351 L=1,NTLOC
C3P1
      KX = LOC(L)
      IF(KX.EQ.0) GO TO 351
      GO TO (352,353,354) KJ
352   QSAVE(J,L) = HD(KX,INDEX)
      IF(INDEX.EQ.6.OR.INDEX.EQ.7) QSAVE(J,L)=QSAVE(J,L)/1000.
      GO TO 351
353   QSAVE(J,L) = QL(KX,INDEX)
      GO TO 351
354   QSAVE(J,L) = DI(KX,INDEX)
351   CONTINUE
      J=J+1
      IF(J.GT.MOVAR) GO TO 360
      GO TO 340
C
C      END SEARCH/PURGE LOOP FOR OUTPUT VARIABLES.
C
360   CONTINUE
      CLOSE(UNIT=NI3)
      NOVAR = J-1
C +++++
C390   CONTINUE
      CONTINUE
C +++++
C
C     STORE FOR SUBSEQUENT FOEA/MCS ANALYSIS SELECTED VALUES
C     OF BASE SIMULATION IN THE ARRAY QSAVE(NOVAR,NLOC)
C
      I=0
      WRITE(NJ2,312) I
312   FORMAT(I5)
      DO 310 K=1,NOVAR
310   WRITE(NJ2,314) (QSAVE(K,L),L=1,NTLOC)
314   FORMAT(8E14.6/)
C3P1      CLOSE(UNIT=NJ2)
      GO TO 400
C
C      ERROR MESSAGES
C
C +++++
C      CONTINUE
99    CONTINUE
C +++++
      WRITE(NJ,98) (SDATA(I),I=1,13)
98    FORMAT(//' ***** ','ERROR IN SENSITIVITY OUTPUT LOCATIONS'/
     * 5X,5A4,4(2X,2F4.0))
      GO TO 400
C +++++
C88    WRITE(NJ,89) (SDATA(I),I=1,12)
C
C 89    FORMAT(//' ***** ','ERROR IN SENSITIVITY OUTPUT VARIALBLES'/
C     * 5X,7A4,2X,5(A4,1X))
C +++++
400   CONTINUE
C
C      RETURN TO UNDATA
C
      RETURN 
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING UNCERTAINTY INPUT DATA FILE',
     2     /,'   UCODE.DAT',
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
      END
