      SUBROUTINE PO4S
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CCC
CCC             NCASI Commentary, PO4S - Section A.
CCC                     A. Initialize counters and constants.
CCC
      NHW=0
      NWS=0
      FACT = 1.0 / (28.3 * 86400.0)
CCC
CCC             NCASI Commentary, PO4S - Section B.
CCC                     B. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + + +
      POSIJI = QI(I)/CNCELR*PHOSI(I)
      POSIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      POSIJI = 0.0
      POSIJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, PO4S - Section C.
CCC                     C. Initialize diagonal and known terms.
CCC
      S(IOR)=PHOS(IOR)
      B(IOR)=X(IOR)-POSIJO*DTOVCL(IOR)
      IF(ISS.GT.0) S(IOR)=0.0
      TC = 0.556*(T(IOR)-68.0)
      SCPHOS(IOR) = SPHOS(I)*THETA(12)**TC
      PSORCE=SCPHOS(IOR)*BAREA(IOR)*DTOVCL(IOR) * FACT
      REACT = (PORG(IOR)*KPORG(IOR) - ALPHA2*GROWTH(IOR)
     1 *ALGAE(IOR))*D1LT
      S(IOR)=S(IOR)+POSIJI*DTOVCL(IOR)+REACT+PSORCE
CCC
CCC                     C.7 For Type 2, 3, 4, and 5 elements the
CCC                          phosphorus balance is now complete.
CCC
      IFL=IFLAG(I,J)
      GO TO (101,100,100,100,109,103,104), IFL
CCC
CCC             NCASI Commentary, PO4S - Section D.
CCC                     D.Phosphorus balance for Type 1 element.
CCC
  101 NHW=NHW+1
      S(IOR) = S(IOR) - A(IOR)*HWPHOS(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, PO4S - Section E.
CCC                     E. Phosphorus balance for Type 6 element.
CCC
  103 NWS=NWS+1
      S(IOR) = S(IOR) + WSFLOW(NWS)*WSPHOS(NWS)*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, PO4S - Section F.
CCC                     F. Phosphorus balance for Type 7 element.
CCC
  104 NWS=NWS+1
      B(IOR) = B(IOR) - WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 100
      S(IOR) = S(IOR) - C(IOR)*PHOSLB
CCC
CCC             NCASI Commentary, PO4S - Section G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, PO4S - Section H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
