      SUBROUTINE Q2EZ
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C        INTEGER CONOUT,MSGFIL
C        DATA CONOUT,MSGFIL / 6,9 /
C +++++
CC
CC           Insert the call to HYDRAU and TRIMAT here for
CC            compatability with the flow augmentation option.
CC
      IAGIT = 0
      IF(DISPYN.EQ.'Y') CALL GETMSG(19,MSGFIL)
  998 CALL HYDRAU
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(20,MSGFIL)
      CALL TRIMAT
CC
CCC             NCASI Commentary, MAIN - Section G. (QUAL2 Step 7-0)
CCC                     G. Begin computations.
CCC
CCC                     G.1 Initialize iteration counters for
CCC                          steady state simulations.
CCC
      JTER = 0
      ITERN = 0
      ITERO = 0
      NITER=0
      ITER=0
      IPASS = 0
      JPASS = 0
      ITCODE = 1
CCC
CCC                     G.2 Advance time counters for dynamic
CCC                          simulations.
CCC
CC                      ISS=0 is dynamic simulation
CC                      ISS=2 is steady state simulation
C
      IF(ISS.EQ.0) CALL CLRSCR
      IF(ISS.EQ.0) CALL GETMSG(39,MSGFIL)
C
  999 TIME=TIME+D2LT
      TPRINT=TPRINT+D2LT
      IAGIT = IAGIT + 1
CCC
CCC                     G.3 Route water quality constituents
CCC                          according to the value of
CCC                          MODOPT(I). (QUAL2 Step 7-2)
CCC
C                                       MODOPT(1)   CONSERVATIVE
C                                       MODOPT(2)   TEMPERATURE
C                                       MODOPT(3)   BOD
C                                       MODOPT(4)   CHLOROPHYLL A
C                                       MODOPT(5)   PHOSPHOROUS
C                                       MODOPT(6)   NH3,NO2,NO3
C                                       MODOPT(7)   OXYGEN
C                                       MODOPT(8)   COLIFORMS
C                                       MODOPT(9)   NON-CONSERVATIVE
CC
CC           Add the flag IRPT1 to the argument of SOVMAT so that
CC            intermediate output will be printed in the dynamic
CC            simulations, if desired.
CC
C + + + + + + + +
C
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y') CALL CLRSCR
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y')
     1   CALL GETMSG(21,MSGFIL)
      CALL TCALCS
C
C + + + + + + + +
C
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y') CALL CLRSCR
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y') 
     1   CALL GETMSG(22,MSGFIL)
      CALL QCALC1
C
C + + + + + +
C
C       INSERT CALL TO REAERC FOR COMPUTATIONAL EFFICIENCY
C               (DELETE BELOW IN QCALC2)
C3.0          (ALSO SET UP THE XK2 ARRAY)
C
      IF(MODOPT(7).EQ.0) GO TO 7049
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y') CALL CLRSCR
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y')
     1   CALL GETMSG(23,MSGFIL)
      CALL REAERC
      IJUNC=0
        DO 800 I=1,NREACH
        NCELR = NCELRH(I)
        DO 800 J=1,NCELR
        IOR = ICLORD(I,J)
        IFL = IFLAG(I,J)
        TC = 0.556*(T(IOR)-68.0)
        GO TO (802,804,804,806,804,804,804) IFL
802     XK2(IOR) = K2(IOR)*THETA(3)**TC
        GO TO 800
804     XK2(IOR) = 0.5*(K2(IOR-1)+K2(IOR))*THETA(3)**TC
        GO TO 800
806     IJUNC = IJUNC + 1
        NN=JUNC(IJUNC,1)
        XK2(IOR) = 0.25*(K2(IOR-1)+K2(NN)+2.*K2(IOR))*THETA(3)**TC
800     CONTINUE
7049  CONTINUE
C3.0
C3.0      INITIALIZE ALGAE BIOMASS FF'S
C3.0
      IF(IPASS.NE.0.OR.MODOPT(4).EQ.0) GO TO 7059
      NHW=0
      NWS=0
      DO 7050 I=1,NREACH
      NCELR = NCELRH(I)
      ALGI(I) = ALGI(I)/ALPHAO(I)
      DO 7050 J=1,NCELR
      IFL = IFLAG(I,J)
      IF(IFL.NE.1) GO TO 7051
      NHW = NHW+1
      HWALG(NHW) = HWALG(NHW)/ALPHAO(I)
7051  CONTINUE
      IF(IFL.LT.6) GO TO 7050
      NWS = NWS + 1
      WSALG(NWS) = WSALG(NWS)/ALPHAO(I)
7050  CONTINUE
      ALGLB = ALGLB/ALPHAO(NREACH)
7059  CONTINUE
C3.0
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y') CALL CLRSCR
      IF(ISS.EQ.2.AND.ITER.LE.1.AND.DISPYN.EQ.'Y')
     1   CALL GETMSG(24,MSGFIL)
      CALL QCALC2
C + + + + + + + +
CCC
CCC                     G.14 Test print counter for
CCC                           reinitialization.
CCC
      IF (TPRINT.LT.PTIME) GO TO 997
      JPASS = 0
      TPRINT=0.0
  997 CONTINUE
CCC
CCC                     G.15 Test for steady state modeling.
CCC                           (QUAL2 Step 7-3)
CCC
      IF(ISS.LE.0) GO TO 9996
C
C + + + + + + + +
C
      IF(ITER.LE.1.AND.DISPYN.EQ.'Y') CALL CLRSCR
      IF(ITER.LE.1.AND.DISPYN.EQ.'Y') CALL GETMSG(25,MSGFIL)
      CALL SSCONV
C
C + + + + + + + +
C
      IF(JTER.LE.1) GO TO 7059
      TIME = ITER+ITERN+ITERO
CQ2U
      DO 850 I=1,NCELLS
      SUMN(I)=CNH2(I)+CNH3(I)+CNO2(I)+CNO3(I)
      SUMP(I) = PORG(I)+PHOS(I)
      IF(MODOPT(4).EQ.0) GO TO 850
      APR(I)=(ALPHA3/ALPHA4)*(GROWTH(I)/RESPRR(I))
      APMR(I)=(ALPHA3*GROWTH(I)-ALPHA4*RESPRR(I))*ALGAE(I)
850   CONTINUE
CQ2U
        IF(MODOPT(4).EQ.0) GO TO 2001
CQ2U
C     RESTORE ALGAE TO INPUT FF'S UNITS
C
      NHW=0
      NWS=0
      DO 860 I=1,NREACH
      ALGI(I) = ALGI(I)*ALPHAO(I)
      NCELR = NCELRH(I)
      DO 860 J=1,NCELR
      IFL = IFLAG(I,J)
      IF(IFL.NE.1) GO TO 861
      NHW = NHW+1
      HWALG(NHW) = HWALG(NHW)*ALPHAO(I)
861   CONTINUE
      IF(IFL.LT.6) GO TO 860
      NWS = NWS+1
      WSALG(NWS) = WSALG(NWS)*ALPHAO(I)
860   CONTINUE
      ALGLB = ALGLB*ALPHAO(NREACH)
CQ2U
C
C + + + + + + + +
C
      IF(INTOUT.EQ.2) THEN
        IF(DISPYN.EQ.'Y') CALL CLRSCR
        IF(DISPYN.EQ.'Y') CALL GETMSG(26,MSGFIL)
        CALL WRPT1
      ENDIF
C
C + + + + + + + +
C
      GO TO 2001
 9996 IF (TIME.LT.TMAX) GO TO 999
 2001 CONTINUE
CCC
CCC             NCASI Commentary, MAIN - Section I.
CCC                     I. Test for dynamic/steady mode for writing
CCC                         intermediate report.
CCC
      IF(ISS.LE.0.OR.IRPT1.LE.0) GO TO 9998
C
C + + + + + + + +
C
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(27,MSGFIL)
      CALL WRPTI
C
C + + + + + + + +
C
        JPASS = 0
 9998 CONTINUE
CCC
CCC             NCASI Commentary, MAIN - Section J. (QUAL2 Step 8-0)
CCC                     J. Test for flow augmentation option.
CCC
      IF (IAUGOP.EQ.0) GO TO 9999
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(28,MSGFIL)
      CALL FLOAUG
C +++++
      IF (ABS(TIME).LT.R0MIN) GO TO 998
C
C      IF (TIME.EQ.0.0) GO TO 998
C +++++
 9999 CONTINUE
CCC
CCC             NCASI Commentary, MAIN - Section K.
CCC                     K. Write final summary.
CCC
      RETURN
C
      END
