      PROGRAM Q2U3P1
C
C3P1        PROGRAM QUAL2E-UNCAS, UNCERTAINTY ANALYSIS WITH QUAL2E-V3.1
C3P12       PROGRAM QUAL2EU, VERSION 3.12 EPA ENHANCED VERSION 01/11/91
C3P22       PROGRAM QUAL2EU, VERSION 3.22 EPA ENHANCED VERSION 05/01/96
C3P1
C3P1         DEVELOPMENT VERSION 1/1/90 BY LCB.  GENERATES OUTPUT PLOT
C3P1         FILE (OSIM.DPL) AND INCLUDES MODIFICATIONS BY B. RODRIGUEZ
C3P1         LCB AND OTHERS.
C3PU
C3PU        PROGRAM QUAL2E-UNCAS, UNCERTAINTY ANALYSIS WITH QUAL2E-V3.0
CQ2E
CQ2E        PROGRAM QUAL-2E, VERSION 3.0   EPA/NCASI ENHANCED VERSION
CQ2E
C                             QUAL-2 IS A SET OF INTERRELATED STREAM
C                             QUALITY ROUTING MODELS. IT HAS THE
C                             CAPABILITY TO ROUTE TEMP.,BOD/DO,
C                             NITROGEN SERIES, PHOSPHATE, ALAGE,
C                             COLIFORMS, ARBITRARY NON CONSERVATIVE, AND
C                             UP TO THREE CONSERVATIVE MINERALS
C                             THROUGH A FULLY-MIXED STREAM SYSTEM.
C                             THESE PARAMETERS CAN BE ROUTED ON AN
C                             INDIVIDUAL BASIS OR SIMULTANEOUSLY IN
C                             SUCH A COMBINATION AS THE USER MAY
C                             DESIRE. QUAL-2 ALSO HAS THE CAPABILITY
C                             TO COMPUTE THE FLOW AUGMENTATION REQED.
C                             TO MEET PRESELECTED MIMIMUM DO LEVELS.
C                             HYDRAULICS ARE CONSIDERED STEADY-STATE.
C
C3.0  QUAL2E, VERSION 3.0 (FEBRUARY 1987) INCORPORATES THE FOLLOWING MAJOR
C3.0  ENHANCEMENTS OVER VERSION 2.2 (AUGUST 1985).
C3.0      1. TEMPERATURE SIMULATIONS.
C3.0         A. STEADY STATE MODE: REACH VARIABLE LOCAL CLIMATOLOGY
C3.0            DATA CAN BE INPUT VIA A NEW DATA TYPE 5A.
C3.0         B. DYNAMIC (DIURNAL) MODE: LOCAL CLIMATOLOGICAL DATA
C3.0            MUST BE READ FROM A SEPARATE INPUT FILE.
C3.0         C. VERSION 3.0 WILL CORRECTLY READ VERSION 2.2 DATA
C3.0            FILES FOR STEADY STATE SIMULATIONS.
C3.0      2. DISSOLVED OXYGEN SIMULATIONS.  OBSERVED DO DATA CAN BE READ
C3.0         FROM A SEPARATE DATA FILE AND PLOTTED WITH THE SIMULATED
C3.0         DO VALUES IN SUBROUTINE PRPLOT.
C3.0      3. STEADY STATE CONVERGENCE CRITERION.  THIS CONVERGENCE 
C3.0         CRITERION HAS BEEN CHANGED FROM AN ABSOLUTE ERROR TO A 
C3.0         RELATIVE ERROR (1.0E-03).
CC
C3.4 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 03/01/90
C3.4 - QUAL2EU UPDATE                                                   03/01/90
C3.4   D. Disney, CSC                                                   03/01/90
C3.1   Version 3.10                                                     03/01/90
C3.1                                                                    03/01/90
C3.1   All VAX installation specific statements are indicated by the    03/01/90
C3.1   characters CVAX in columns 1 through 4.  Version 3.1 implements  03/01/90
C3.1   code restructure and file CONFIG.FIL.  This file is read by      03/01/90
C3.1   QUAL2EU and contains the file storage path for files MSGFILE.DAT 03/01/90
C3.1   and UCODE.DAT.  These files can be used by multiple users in a   03/01/90
C3.1   shared installation of QUAL2EU on VAX or networked PC systems.   03/01/90
C3.1   Version 3.1 implements the use of the FORTRAN INCLUDE file       03/01/90
C3.1   IOUNIT.INC.  This file contains all declarations for file I/O    03/01/90
C3.1   unit numbers.  All unit numbers are initialized in BLOCKUNC.FOR. 03/01/90
C3.1   CHARCT.VAR was also modified to declare file storage path        03/01/90
C3.1   varialbles MFPATH and UCPATH.                                    03/01/90
C3.1 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 03/01/90
C
C3.1 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 01/09/91
C3.1 - QUAL2E UPDATE                                                    01/09/91
C3.1   D. Disney, CSC                                                   01/09/91
C3.1   Version 3.12                                                     01/09/91
C3.1                                                                    01/09/91
C3.1   Version 3.12 contains minor correctios to QUAL2E scientific code 01/09/91
C3.1   and corrections and improvements to file handling.  New error    01/09/91
C3.1   trapping routines and run time error messages were added to      01/09/91
C3.1   to OPEN statements to assist the user in identifying and         01/09/91
C3.1   correcting problems with file input and output (e.g. file not    01/09/91
C3.1   found, incorrect file name used).  Prompt for previously hard    01/09/91
C3.1   coded plot data file name (OSIM.DPL) added 01/11/91.             01/09/91
C3.1 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 01/09/91
C
C3.1 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 07/01/92
C3.1 - QUAL2E UPDATE                                                    07/01/92
C3.1   D. Disney, CSC                                                   07/01/92
C3.1   Version 3.15                                                     07/01/92
C3.1                                                                    07/01/92
C3.1   Added SVS FORTRAN specific statements (CSVS, etc.).              07/01/92
C3.1 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 07/01/92
C
        EXTERNAL BLKINI
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
C3PU
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'CONST.INC'
C
C +++++
C      CHARACTER*15 INAME2
C +++++
C3PU
      CHARACTER*64 DONAME
      CHARACTER*4 LTITLE(20),DTITLE(20)
C +++++
C +   The following declaration statements added by D. Disney, CSC
C +   01/06/86 to correct Ryan-McFarland FORTRAN 77 compile error
C +   and to implement logic and code for MSGFILE.DAT and UCODE.DAT
C +   file path names.
C +
      CHARACTER*1  ANS, BLANK, ASTRIK
C +++++
C      CHARACTER*4  ENDT,ENDA,YES
C +++++
      CHARACTER*70 DUMNAM
C +++++
C      CHARACTER*40 ENDMSG
C +++++
C +
C +   End of change.
C +++++
C3P1    OUTPUT INTERFACE
      CHARACTER*13 OTITL(85)
      CHARACTER*8 BODU
      CHARACTER*7 UNITS
      CHARACTER*4 UBOD
C3P1
C +++++
C      DIMENSION DATA(ML,25)
C +++++
C +++++
C      DATA ENDT/'ENDT'/ , ENDA/'ENDA'/ , YES/' YES'/, BLANK/' '/,
C     *     ASTRIK/'*'/
      DATA BLANK/' '/, ASTRIK/'*'/
      DATA DONAME / '                                                   
     1             ' /
C +++++
C
C3P1    OUTPUT INTERFACE  6/89  (LCB)
      DATA UBOD,UNITS,BODU / ' 5-D','ENGLISH','ULTIMATE'/
      DATA OTITL(1),OTITL(2),OTITL(3),OTITL(4),OTITL(5),OTITL(6) /
     1 '  ELE ORD NUM','    REACH NUM','  ELEMENT NUM','     PLOT NUM',
     2 '  ELE BGN LOC','  ELE END LOC' /
      DATA OTITL(7),OTITL(8),OTITL(9),OTITL(10),OTITL(11),OTITL(12) /
     1 '         FLOW','   POINT SRCE', '    INCR FLOW','     VELOCITY',
     2 '  TRAVEL TIME','        DEPTH' /
      DATA OTITL(13),OTITL(14),OTITL(15),OTITL(16),OTITL(17),OTITL(18) /
     1 '    TOP WIDTH','       VOLUME','  BOTTOM AREA','  X-SECT AREA',
     2 '  DSPRSN COEF','       DO SAT' /
      DATA OTITL(19),OTITL(20),OTITL(21),OTITL(22),OTITL(23),OTITL(24) /
     1 '   REAIR OPTN','  OXYGN REAIR','    BOD DECAY','     BOD SETT',
     2 '     SOD RATE','   ORGN DECAY' /
      DATA OTITL(25),OTITL(26),OTITL(27),OTITL(28),OTITL(29),OTITL(30) /
     1 '    ORGN SETT','    NH3 DECAY','     NH3 SRCE','    NO2 DECAY',
     2 '   ORGP DECAY','    ORGP SETT' /
      DATA OTITL(31),OTITL(32),OTITL(33),OTITL(34),OTITL(35),OTITL(36) /
     1 '    DISP SRCE','   COLI DECAY','    ANC DECAY','     ANC SETT',
     2 '     ANC SRCE','  TEMPERATURE' /
      DATA OTITL(37),OTITL(38),OTITL(39),OTITL(40),OTITL(41),OTITL(42) /
     1 '   CONS MIN-1','   CONS MIN-2','   CONS MIN-3','  DISS OXYGEN',
     2 '          BOD','    ORGANIC-N' /
      DATA OTITL(43),OTITL(44),OTITL(45),OTITL(46),OTITL(47),OTITL(48) /
     1 '    AMMONIA-N','    NITRITE-N','    NITRATE-N','        SUM-N',
     2 '    ORGANIC-P','    DISSLVD-P' /
      DATA OTITL(49),OTITL(50),OTITL(51),OTITL(52),OTITL(53),OTITL(54) /
     1 '        SUM-P','     COLIFORM','  ARBTRY NCON','   CHLRPHYL-A',
     2 '  ALGY GROWTH','    ALGY RESP' /
      DATA OTITL(55),OTITL(56),OTITL(57),OTITL(58),OTITL(59),OTITL(60) /
     1 '    ALGY SETT','  A-P/R RATIO','  AGY NET P-R','  NH3 FRC NUP',
     2 '  LITE EXT CO','   AGY L-FACT' /
      DATA OTITL(61),OTITL(62),OTITL(63),OTITL(64),OTITL(65),OTITL(66) /
     1 '   AGY N-FACT','   AGY P-FACT','   DO DEFICIT','   DAM DO INP',
     2 '  N-INHB FACT','  DOMB-F FUNC' /
      DATA OTITL(67),OTITL(68),OTITL(69),OTITL(70),OTITL(71),OTITL(72) /
     1 '   DOMB-REAIR','    DOMB-CBOD','     DOMB-SOD','   DOMB - P-R',
     2 '    DOMB-NH3N','    DOMB-NO2N' /
      DATA OTITL(73),OTITL(74),OTITL(75),OTITL(76),OTITL(77),OTITL(78) /
     1 '  RCH ELEVATN','  D-ATTN COEF','   CLOUD FACT','  D-BULB TEMP',
     2 '  W-BULB TEMP','  AT-PRESSURE' /
      DATA OTITL(79),OTITL(80),OTITL(81),OTITL(82),OTITL(83),OTITL(84) /
     1 '     WIND VEL','    SOLAR RAD','   L WAVE RAD','   W SURF RAD',
     2 '   CONDUCTION','  EVAPORATION' /
      DATA OTITL(85) / '  NET H-BLNCE' /
C3P1
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C +++++ End declarations and data initialization. ++++++++++++++++++++++
C +++++ Begin executable statement area. +++++++++++++++++++++++++++++++
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
CVAX - DWD for US EPA (CVAX and CSAL)
CVAX   Date: Friday, 25 May 1990.  Time: 08:45:58.
CVAX   Remove and the following OPEN statement for
CVAX   VAX, Salford, SVS, AND F7L FORTRAN.
CPC
CPC      OPEN(UNIT=CONOUT,STATUS='UNKNOWN',FILE='CON')
CPC
      CALL CLRSCR
      WRITE(CONOUT,5)
    5 FORMAT(///////////,
     1 '                 Performing QUAL2E program initialization.')
C
C +++++
      CALL INIT
C +++++
C
C +++++
C +   Configuration file CONFIG.FIL logic and code added by
C +   D. Disney, CSC, for storage of MFGFILE.DAT and
C +   UCODE.DAT files.  These files can be shared by multiple
C +   QUAL2EU users from a common subdirectory and drive.
C +   This option applies to VAX and networked PC systems.
C +   Date: Monday, 26 February 1990.  Time: 12:51:58.
C +
C +   NOTE: The following variables are initialized by DATA
C +         statements in the file BLOCKUNC.FOR:
C +
C +         Variable Name   Initial Value   Type Declaration
C +         -------------   -------------   ----------------
C +         IM, IU          1               Integer
C +         MFPATH          64 spaces       Character
C +         UCPATH          64 spaces       Character
C +
      OPEN(UNIT=CFGFIL,FILE='CONFIG.FIL',ERR=17,STATUS='OLD',
     1     FORM='FORMATTED',ACCESS='SEQUENTIAL')                      
C
      READ(UNIT=CFGFIL,END=16,ERR=16,FMT=5000)MFPATH
      DO 10 I = 64,1,-1
         IF (MFPATH(I:I).EQ.BLANK) GO TO 10
         IM = I
         GO TO 11
   10 CONTINUE
C
   11 READ(UNIT=CFGFIL,END=16,ERR=993,FMT=5000)UCPATH
      DO 14 I = 64,1,-1
         IF (UCPATH(I:I).EQ.BLANK) GO TO 14
         IU = I
         GO TO 16
   14 CONTINUE
C
 5000 FORMAT(1X,A64)
C
   16 CLOSE(UNIT=CFGFIL,ERR=995)
   17 CONTINUE
C
      IF (IM.EQ.1.AND.MFPATH(1:1).EQ.BLANK) THEN
          OPEN(UNIT=MSGFIL,FILE='MSGFILE.DAT',STATUS='OLD',
     1         ERR=997,FORM='FORMATTED',ACCESS='SEQUENTIAL')
      ELSE
          OPEN(UNIT=MSGFIL,FILE=MFPATH(1:IM)//'MSGFILE.DAT',
     1         ERR=997,STATUS='OLD',FORM='FORMATTED',
     2         ACCESS='SEQUENTIAL')
      ENDIF
C +
C +   End of change.
C +++++
C
C       CALL CLRSCR
C       INCLUDE 'ANNOUNU.INC'
C
C +++++
C +   Code to open and process run supervisor file added by
C +   D. Disney, CSC.
C +   Date: Wednesday, 7 March 1990.  Time: 09:01:17.
C +   Date: Friday, 11 January 1991.  Time: 09:11:22.
C +   Array CHARACTER*64 FILNAM(10) holds file names to be
C +   processed - FILNAM declared in CHARCT.VAR.  Array
C +   FILNAM initialized to blanks in BLOCK.FOR or BLOCKUNC.FOR.
C +   File name storage locations are:
C +
C +   FILNAM(1) - input data file name                             
C +   FILNAM(2) - output results file name                         
C +   FILNAM(3) - observed DO input data file for plotting         
C +   FILNAM(4) - uncertainty (UNCAS) input specification file name
C +   FILNAM(5) - uncertainty (UNCAS) input variance file          
C +   FILNAM(6) - local climatology input file name (dynamic simul)
C +   FILNAM(7) - scratch BASE.DAT file created by program         
C +   FILNAM(8) - scratch STORE.DAT file created by program        
C +   FILNAM(9) - output plot data file (previously hard coded as OSIM.DPL)
C +   FILNAM(10)- not used; can be used for future expansion
C +
C
      OPEN(UNIT=SUPFIL,FILE='QUAL2E.SUP',ERR=240,STATUS='OLD',
     1     FORM='FORMATTED',ACCESS='SEQUENTIAL')                      
C
      CALL CLRSCR
      CALL GETMSG(51,MSGFIL)
C      
   21 CONTINUE
      READ(UNIT=SUPFIL,END=23,ERR=22,FMT=4999)DUMNAM
 4999 FORMAT(A70)
      IF(DUMNAM(1:1).EQ.ASTRIK) GO TO 21
      IF(DUMNAM(1:1).EQ.BLANK)  GO TO 21
      IF(DUMNAM(1:5).EQ.'INPUT') THEN
         FILNAM(1) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'OUTPT') THEN
         FILNAM(2) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'OBSDO') THEN
         FILNAM(3) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'UNCAS') THEN
         FILNAM(4) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'VARIA') THEN
         FILNAM(5) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'CLIMT') THEN
         FILNAM(6) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'BASED') THEN
         FILNAM(7) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'STORE') THEN
         FILNAM(8) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'OSIMO') THEN
         FILNAM(9) = DUMNAM(7:70)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'DISYN') THEN
         DISPYN    = DUMNAM(7:7)
         GO TO 21
      ENDIF
      IF(DUMNAM(1:5).EQ.'RETRN') THEN
         RETURN    = DUMNAM(7:7)
         GO TO 21
      ENDIF
C
      GO TO 23
C
   22 CALL CLRSCR
      CALL GETMSG(49,MSGFIL)
      CLOSE(UNIT=SUPFIL)
      GO TO 9999
C      
   23 CLOSE(UNIT=SUPFIL)
  240 CALL CLRSCR
      INCLUDE 'ANNOUNU.INC'
      CALL CLRSCR
      WRITE(CONOUT,2200)
 2200 FORMAT(////////////////////////)
C
C   23 CLOSE(UNIT=SUPFIL)
C
   24 CONTINUE
C
      IF(FILNAM(1)(1:1).EQ.BLANK) THEN
         WRITE(CONOUT,2345)
2345     FORMAT('** Enter name of QUAL2EU input data file:  ',\)
CSAL2345     FORMAT('** Enter name of QUAL2EU input data file:  ')
CVAX2345     FORMAT('$','** Enter name of QUAL2EU input data file:  ')
         READ(CONIN,5432) FILNAM(1)
5432     FORMAT(A64)
      ENDIF
C
      OPEN (UNIT=NI,FILE=FILNAM(1),STATUS='OLD',ERR=996)
C
   25 CONTINUE
C
      IF(FILNAM(2)(1:1).EQ.BLANK) THEN
         WRITE(CONOUT,3456)
3456     FORMAT(/,'** Enter name of QUAL2EU output file or LPT1:  ',\)
CSAL3456     FORMAT(/,'** Enter name of QUAL2EU output file or LPT1:  ')
CVAX3456     FORMAT(/,'$','** Enter name of QUAL2EU output file:  ')
         READ(CONIN,5432) FILNAM(2)
      ENDIF
C
      IF(FILNAM(2)(1:1).EQ.BLANK) GOTO 9961
CPC
      OPEN(UNIT=NJ,FILE=FILNAM(2),STATUS='UNKNOWN',ERR=9961)
CPC
CSVS
CSVS      OPEN(UNIT=NJ,FILE=FILNAM(2),STATUS='UNKNOWN',ERR=9961,
CSVS     -     FORM='PRINTER')
CSVS
CF7L
      OPEN(UNIT=NJ,FILE=FILNAM(2),STATUS='UNKNOWN',ERR=9961,
     -     CARRIAGECONTROL='FORTRAN')
CF7L
CSAL
CSAL      OPEN(UNIT=NJ,FILE=FILNAM(2),STATUS='UNKNOWN',ERR=9961,
CSAL     -     FORM='PRINTER')
CSAL
C
C +++++
C +   Code and logic added by D. Disney, CSC to prompt
C +   user for option to display detailed run time
C +   status message on monitor screen.
C
      IF(DISPYN.EQ.BLANK) THEN
3458     WRITE(CONOUT,3459)
3459     FORMAT(/,'** Display detailed run-time status',
     *              ' messages on monitor screen? (Y/N):  ',\)
CSAL3459     FORMAT(/,'** Display detailed run-time status',
CSAL     *              ' messages on monitor screen? (Y/N):  ')
CVAX3459     FORMAT(/,'$','** Display detailed run-time status',
CVAX     *                  ' messages on monitor screen? (Y/N):  ')
         READ(CONIN,3460) DISPYN
3460     FORMAT(A1)
         IF(DISPYN.EQ.'Y'.OR.DISPYN.EQ.'y'.OR.
     1      DISPYN.EQ.'N'.OR.DISPYN.EQ.'n')   GOTO 3469
         WRITE(CONOUT,3462)
3462     FORMAT(/,'** ERROR ON INPUT',/,
     1            '   Please enter Y, y, N, or n only - Try again.')
         GOTO 3458
3469     CONTINUE
      ENDIF
C
      IF(DISPYN.EQ.'y') DISPYN='Y'
      IF(DISPYN.EQ.'n') DISPYN='N'
C +
C +   End of change.
C +++++
C3.0
       INTOUT=2
C3.0
CCC             NCASI Commentary, MAIN - Section B. (QUAL2 Steps 2-0,
CCC                 3-0, and 4-0).
CCC                     B. CALL INDATA.  Return with all required
CCC                         input data, except local climatology,
CCC                         and plot data.
C3PU
      IF(DISPYN.EQ.'N') CALL CLRSCR
      IF(DISPYN.EQ.'N') CALL GETMSG(1,MSGFIL)
C3PU
      CALL INDATA
C3.0
C3.0     READ INPUT FILE NAME CONTAINING THE LOCAL CLIMATOLOGY DATA FOR
C3.0        DYNAMIC(DIURNAL) SIMULATIONS.
C3.0
      IF(ISS.GT.0) GO TO 41
      IF(MODOPT(2).EQ.0.AND.MODOPT(4).EQ.0) GO TO 41
C
C      IF(ISS.GT.0.OR.(MODOPT(2).EQ.0.AND.MODOPT(4).EQ.0)) GO TO 41
C
      CALL CLRSCR
C
      ANS = BLANK
   29 CONTINUE
C
      IF(FILNAM(6)(1:1).EQ.BLANK) THEN
         IF (ANS .EQ. BLANK) THEN
             WRITE(CONOUT,30)
30           FORMAT(//////////////////////,
     *        '** Enter name of file containing local climatology',
     *      /,'             data for dynamic (DIURNAL) simulation:  ',\)
CSAL30           FORMAT(//////////////////////,
CSAL     *        '** Enter name of file containing local climatology',
CSAL     *      /,'             data for dynamic (DIURNAL) simulation:  ')
CVAX30           FORMAT(//////////////////////,
CVAX     *    '$','** Enter name of file containing local climatology',
CVAX     *  /,'$','             data for dynamic (DIURNAL) simulation:  ')
         ENDIF
         IF (ANS .EQ. 'E') THEN
             WRITE(CONOUT,31)
31           FORMAT(/,
     *        '** Enter name of file containing local climatology',
     *      /,'             data for dynamic (DIURNAL) simulation:  ',\)
CSAL31           FORMAT(/,
CSAL     *        '** Enter name of file containing local climatology',
CSAL     *      /,'             data for dynamic (DIURNAL) simulation:  ')
CVAX31           FORMAT(/,
CVAX     *    '$','** Enter name of file containing local climatology',
CVAX     *  /,'$','             data for dynamic (DIURNAL) simulation:  ')
         ENDIF
C
         READ(CONIN,5432) FILNAM(6)
C         IF (DISPYN.EQ.'Y') CALL CLRSCR
      ENDIF
C
C      NI2=2
      IF(FILNAM(6)(1:1).EQ.BLANK) GOTO 998
      OPEN(UNIT=NI2,STATUS='OLD',ERR=998,FILE=FILNAM(6))
      ANS = BLANK
C
      READ(NI2,39) (LTITLE(J),J=1,20)
39    FORMAT(20A4)
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,40) (LTITLE(J),J=1,20)
40    FORMAT(//////////,
     * 13X,'Reading LCD data for dynamic (DIURNAL) simulation:',/,
     * 5X,20A4)
41    CONTINUE
C3PU
C     PERFORM SIMULATION FOR BASE CASE
C3.0
      IF(DISPYN.EQ.'N') CALL GETMSG(42,MSGFIL)
C
C      IF(DISPYN.EQ.'N'.AND.
C     *  (ISS.GT.0.OR.(MODOPT(2).EQ.0.AND.MODOPT(4).EQ.0)))
C     *   CALL GETMSG(42,MSGFIL)
C
      CALL Q2EZ
C3.0
      IF(ISS.GT.0) GO TO 555
      IF(MODOPT(2).EQ.0.OR.MODOPT(4).EQ.0) GO TO 555
      CLOSE(UNIT=NI2)
555   CONTINUE
C3.0
CCC             NCASI Commentary, MAIN - Section K.
CCC                     K. Write final summary.
C +++++
      CALL CLRSCR
      IF(DISPYN.EQ.'N') CALL GETMSG(43,MSGFIL)
      IF(DISPYN.EQ.'Y') CALL GETMSG(29,MSGFIL)
C +++++
      CALL WRPT3A (NPAGE)
      CALL WRPT3B (NPAGE)
C3.0
      IF(IPLOT.EQ.0) GO TO 556
C3.0
C3.0     TEST WHETHER DO DATA ARE AVAILABLE FOR PLOTTING
C3.0
      ANS = BLANK
      IF(FILNAM(3).EQ.'NUL') THEN
         KDATA=0
         GO TO 353
      ENDIF
   42 CONTINUE
      IF(FILNAM(3)(1:1).EQ.BLANK) THEN
         IF (ANS .EQ. BLANK) THEN
             CALL CLRSCR
C +++++
C335          WRITE(CONOUT,336)
             WRITE(CONOUT,336)
C +++++
336          FORMAT(///////////////////////,
     1             '** Enter name of file containing',
     2             ' observed DO data: (Enter=none) ',\)
CSAL336          FORMAT(///////////////////////,
CSAL     1             '** Enter name of file containing',
CSAL     2             ' observed DO data: (Enter=none) ')
CVAX336          FORMAT(///////////////////////,
CVAX     1             '$','** Enter name of file containing',
CVAX     2                 ' observed DO data: (Enter=none) ')
         ENDIF
         IF (ANS .EQ. 'E') THEN
             WRITE(CONOUT,337)
337          FORMAT(/,
     1              '** Enter name of file containing',
     2              ' observed DO data: (Enter=none) ',\)
CSAL337          FORMAT(/,
CSAL     1              '** Enter name of file containing',
CSAL     2              ' observed DO data: (Enter=none) ')
CVAX337          FORMAT(/,
CVAX     1              '$','** Enter name of file containing',
CVAX     2                  ' observed DO data: (Enter=none) ')
         ENDIF
C
         READ(CONIN,5432) FILNAM(3)
C         NI2 = 2
      ENDIF
C
      IF(FILNAM(3)(1:1).EQ.BLANK) THEN
         KDATA=0
         GO TO 353
      ENDIF
C
      OPEN(UNIT=NI2,STATUS='OLD',ERR=999,FILE=FILNAM(3))
      ANS = BLANK
C
      KDATA = 1
      READ(NI2,339) (DTITLE(J),J=1,20)
339   FORMAT(20A4)
      DONAME = FILNAM(3)
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,340) DONAME,(DTITLE(J),J=1,20)
340   FORMAT(//////////,17X,'Reading observed DO data file: ',A12,
     1       /,5X,20A4)
353   CONTINUE
      CALL CLRSCR
      CALL GETMSG(30,MSGFIL)
      CALL PRPLOT(KDATA)
      IF(KDATA.EQ.1) CLOSE(UNIT=NI2)
556   CONTINUE
C
      CALL CLRSCR
      CALL GETMSG(31,MSGFIL)
C3.0
      CLOSE(UNIT=NI)
C3P1
C3P1   OUTPUT INTERFACE - WRITE DATA FILE
C3P1   OPEN statement syntax changed DWD
C3P1   Date: Monday, 4 June 1990.  Time: 07:58:31.
C3P12  Date: Friday, 11 January 1991.  Time: 09:13:06.
C3P12
C
      ANS = BLANK
      IF(FILNAM(9)(1:3).EQ.'NUL') GO TO 753
   50 CONTINUE
      IF(FILNAM(9)(1:1).EQ.BLANK) THEN
         IF (ANS .EQ. BLANK) THEN
             CALL CLRSCR
             WRITE(CONOUT,3457)
3457         FORMAT(///////////////////////,
     1              '** Enter name of QUAL2EU output plot file:  ',\)
CSAL3457         FORMAT(///////////////////////,
CSAL     1              '** Enter name of QUAL2EU output plot file:  ')
CVAX3457         FORMAT(///////////////////////,
CVAX     1             '$','** Enter name of QUAL2EU output plot file:  ')
         ENDIF
         IF (ANS .EQ. 'E') THEN
             WRITE(CONOUT,3461)
3461         FORMAT(/,
     1              '** Enter name of QUAL2EU output plot file:  ',\)
CSAL3461         FORMAT(/,
CSAL     1              '** Enter name of QUAL2EU output plot file:  ')
CVAX3461         FORMAT(/,
CVAX     1             '$','** Enter name of QUAL2EU output plot file:  ')
         ENDIF
C
         READ(CONIN,5432) FILNAM(9)
      ENDIF
C3P12
C
      IF(FILNAM(9)(1:1).EQ.BLANK) GOTO 9991
      OPEN(UNIT=NI,FILE=FILNAM(9),STATUS='UNKNOWN',
     1     FORM='FORMATTED',ACCESS='SEQUENTIAL',ERR=9991)
CVAX
CVAX      OPEN(UNIT=NI,FILE=FILNAM(9),STATUS='UNKNOWN',
CVAX     1     FORM='FORMATTED',ACCESS='SEQUENTIAL',
CVAX     2     CARRIAGECONTROL='LIST')
CVAX
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(52,MSGFIL)
      ANS = BLANK
C3P1
C3P1      OPEN(UNIT=NI,FILE='OSIM.DPL',STATUS='UNKNOWN')
C3P1
      DO 700 I=1,2
700   WRITE(NI,701) (TITLE(I,J),J=1,20)
701   FORMAT(2X,20A4)
      IF(METOUT.GT.0) UNITS = 'METRIC '
      IF(TITLE(7,6).EQ.UBOD) BODU = '5-DAY   '
      WRITE(NI,710) UNITS,BODU
710   FORMAT(2X,'OUTPUT UNITS = ',A7,'  ;  BOD = ',A8)
      WRITE(NI,721) (OTITL(J),J=1,85)
721   FORMAT(9(10A13/))
      DO 750 I=1,NCELLS
      WRITE(NI,751) I
751   FORMAT(I6)
750   WRITE(NI,752) (OSIM(I,J),J=1,85)
752   FORMAT(9(10E13.5/))
      CLOSE(UNIT=NI)
753   CONTINUE
C3P1
C3PU    
C      BEGIN UNCERTAINTY ANALYSIS SECTION
C3PU
C
      ANS = BLANK
  800 CONTINUE
C
      IF(FILNAM(4)(1:1).EQ.BLANK) THEN
         IF (ANS .EQ. BLANK) THEN
             CALL CLRSCR
             WRITE(CONOUT,12)
12           FORMAT(///////////////////////,
     1       '** Enter name of UNCAS input specification file:  ',\)
CSAL12           FORMAT(///////////////////////,
CSAL     1       '** Enter name of UNCAS input specification file:  ')
CVAX12           FORMAT(///////////////////////,
CVAX     1       '$','** Enter name of UNCAS input specification file:  ')
         ENDIF
         IF (ANS .EQ. 'E') THEN
             WRITE(CONOUT,13)
13           FORMAT(/,
     1       '** Enter name of UNCAS input specification file:  ',\)
CSAL13           FORMAT(/,
CSAL     1       '** Enter name of UNCAS input specification file:  ')
CVAX13           FORMAT(/,
CVAX     1       '$','** Enter name of UNCAS input specification file:  ')
         ENDIF
C         
         READ(CONIN,5432) FILNAM(4)
      ENDIF
C
      OPEN(UNIT=NI,STATUS='OLD',ERR=1000,FILE=FILNAM(4))
      ANS = BLANK
C
  820 CONTINUE
C
      IF(FILNAM(5)(1:1).EQ.BLANK) THEN
         WRITE(CONOUT,1122)
1122     FORMAT(/,'** Enter name of UNCAS input variance file:  ',\)
CSAL1122     FORMAT(/,'** Enter name of UNCAS input variance file:  ')
CVAX1122     FORMAT(/,'$','** Enter name of UNCAS input variance file:  ')
         READ(CONIN,5432) FILNAM(5)
      ENDIF
C
      NI4 = 14
      OPEN(UNIT=NI4,STATUS='OLD',ERR=1001,FILE=FILNAM(5))
      CLOSE(UNIT=NI4)
C
      IRPT1=0
C3PU
C3PU    PERFORM UNCERTAINTY ANALYSIS
C3PU
      CALL UNCAS
C3PU
C      BRANCH FOR FINAL SIMULATION TO CHECK SWAPPING IN MEMORY
C
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(32,MSGFIL)
      CALL CLRSCR
      CALL GETMSG(33,MSGFIL)
      INTOUT=2
C
      CALL Q2EZ
C
      CALL CLRSCR
      CALL GETMSG(29,MSGFIL)
      CALL WRPT3A(NPAGE)
      CALL WRPT3B(NPAGE)
C
      CLOSE(UNIT=NI)
C      IF(NJ.EQ.5) CLOSE(UNIT=NJ)
C +++++
      CLOSE(UNIT=NJ)
C +++++
      CALL CLRSCR
      CALL GETMSG(34,MSGFIL)
C
      CLOSE(UNIT=MSGFIL)
C
      GO TO 9999
C +++++
C +
C +   Statements 991 through 995 added by D. Disney
C +   Date: Tuesday, 27 February 1990.  Time: 09:27:03.
C +   These statments display error or warning messages
C +   on the monitor concerning the opening or reading of
C +   the file storage configuration file CONFIG.FIL.
C +
C 991  CALL CLRSCR
C      WRITE(CONOUT,9912)
C 9912 FORMAT(/////////////////////,
C     1       'Error opening file storage configuration file',
C     2     /,'                 CONFIG.FIL',
C     3     /,'Contact CEAM technical support (706/546-3549)',/)
C      GO TO 9999
C
C 992  CALL CLRSCR
C      WRITE(CONOUT,9921)
C 9921 FORMAT(/////////////////////,
C     1       'Error reading file storage configuration file',
C     2     /,'                 CONFIG.FIL',
C     3     /,'Error reading MSGFILE.DAT storage path record.',
C     4     /,'Contact CEAM technical support (706/546-3549)',/)
C      GO TO 9999
C
 993  CALL CLRSCR
      WRITE(CONOUT,9931)
 9931 FORMAT(/////////////////////,
     1       'Error reading file storage configuration file',
     2     /,'                 CONFIG.FIL',
     3     /,' Error reading UCODE.DAT storage path record.',
     4     /,'Contact CEAM technical support (706/546-3549)',/)
      GO TO 9999
C
C 994  CALL CLRSCR
C      WRITE(CONOUT,9941)
C 9941 FORMAT(/////////////////////,
C     1       'Error reading file storage configuration file',
C     2     /,'                 CONFIG.FIL',
C     3     /,' End of file CONFIL.FIG reached prematurely.',
C     4     /,'Contact CEAM technical support (706/546-3549)',/)
C      GO TO 9999
C
 995  CALL CLRSCR
      WRITE(CONOUT,9951)
 9951 FORMAT(/////////////////////,
     1       'Error closing file storage configuration file',
     2     /,'                 CONFIG.FIL',
     3     /,'Contact CEAM technical support (706/546-3549)',/)
      GO TO 9999
C +++++
C +
C +   Statements 996 through 1001 added by D. Disney
C +   Date: Wednesday, 9 January 1991.  Time: 09:17:50.
C +   These statments display error messages on the
C +   monitor concerning the opening of the data, run
C +   time message, DO, and DIURNL input files.
C +
C
 996  WRITE(CONOUT,9952)FILNAM(1)
 9952 FORMAT(/,
     1       '** ERROR OPENING INPUT DATA FILE',
     2     /,'   ',A64,
     3     /,'   Try another file name or press <Ctrl>',
     4           '<Break> to stop.',/)
      FILNAM(1)(1:1)=BLANK
      GO TO 24
C
 9961 WRITE(CONOUT,9956)FILNAM(2)
 9956 FORMAT(/,
     1       '** ERROR OPENING OUTPUT DATA FILE',
     2     /,'   ',A64,
     3     /,'   Enter file name or LPT1 at present cursor position.',
     4     /,'   Try another file name or LPT1 or press <Ctrl>',
     5           '<Break> to stop.',/)
      FILNAM(2)(1:1)=BLANK
      GO TO 25
C
 9991 WRITE(CONOUT,9957)FILNAM(9)
 9957 FORMAT(/,
     1       '** ERROR OPENING OUTPUT PLOT DATA FILE',
     2     /,'   ',A64,
     3     /,'   Enter file name at present cursor position.',
     4     /,'   Try another file name or press <Ctrl>',
     5           '<Break> to stop.',/)
      ANS = 'E'
      FILNAM(9)(1:1)=BLANK
      GO TO 50
C
 997  CALL CLRSCR
      WRITE(CONOUT,9953)
 9953 FORMAT(/////////////////////,
     1       '** ERROR OPENING RUN TIME MESSAGE FILE',
     2     /,'   MSGFILE.DAT',
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      GO TO 9999
C
 998  WRITE(CONOUT,9954)FILNAM(6)
 9954 FORMAT(/,
     1       '** ERROR OPENING LOCAL CLIMATOLOGY INPUT DATA FILE',
     2     /,'   for dynamic (DIURNAL) simulation',
     3     /,'   ',A64,
     4     /,'   Try another file name or press <Ctrl><Break> to',
     5           ' stop.',/)
      ANS = 'E'
      FILNAM(6)(1:1)=BLANK
      GO TO 29
C
 999  WRITE(CONOUT,9955)FILNAM(3)
 9955 FORMAT(/,
     1       '** ERROR OPENING OBSERVED DO INPUT DATA FILE',
     2     /,'   ',A64,
     3     /,'   Try another file name or press <Ctrl><Break> to',
     4           ' stop.',/)
      ANS = 'E'
      FILNAM(3)(1:1)=BLANK
      GO TO 42
C
 1000 WRITE(CONOUT,9958)FILNAM(4)
 9958 FORMAT(/,
     1       '** ERROR OPENING UNCAS INPUT SPECIFICATION FILE',
     2     /,'   ',A64,
     3     /,'   Try another file name or press <Ctrl><Break> to',
     4           ' stop.',/)
      ANS = 'E'
      FILNAM(4)(1:1)=BLANK
      GO TO 800
C
 1001 WRITE(CONOUT,9959)FILNAM(5)
 9959 FORMAT(/,
     1       '** ERROR OPENING UNCAS INPUT VARIANCE FILE',
     2     /,'   ',A64,
     3     /,'   Try another file name or press <Ctrl><Break> to',
     4           ' stop.',/)
      FILNAM(5)(1:1)=BLANK
      GO TO 820
C +
C +   End of change.
C +++++
C
 9999 CONTINUE
CSAL
CSAL      CLOSE(UNIT=CONOUT)
CSAL
      STOP
C
      END
