      SUBROUTINE QCALC2
C
C + + + + + + + + +
C
C      THIS SUBROUTINE PERFORMS QUALITY CONSTITUENT ROUTING FOR
C       LINKED WATER QUALITY VARIABLES IN A QUAL2E SIMULATION.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
C
      GO TO (7741,704,847,7070) ITCODE
CQ2E
CQ2E            STEADY STATE ITERATIONS
CQ2E
7741    CONTINUE
        IF(ISS.LE.0) GO TO 7044
        IF(MODOPT(4).EQ.0.AND.MODOPT(6).EQ.0.AND.MODOPT(7).
     1 EQ.0) GO TO 7044
      IF(MODOPT(4).EQ.0.AND.MODOPT(6).EQ.0.AND.NDAM.EQ.0) GO TO 7044
      IF(MODOPT(4).EQ.0.AND.KNITRF.GE.10..AND.MODOPT(7).EQ.0)
     * GO TO 7044
      IF(MODOPT(4).EQ.0.AND.KNITRF.GE.10..AND.NDAM.EQ.0) GO TO 7044
C3.0
      IF(INTOUT.EQ.2)  WRITE(NJ,7043)
7043    FORMAT(1H1//2X,'STEADY STATE ALGAE/NUTRIENT/DISSOLVED',
     1' OXYGEN SIMULATION; CONVERGENCE SUMMARY:'/2X,77('-')//
     1 52X,'NUMBER OF'/
     2 13X,'VARIABLE',14X,'ITERATION      NONCONVERGENT'/
     3 52X,'ELEMENTS'/)
7044    CONTINUE
CCC
CCC                     G.8 Algae (Chlorophyll a).
CCC
C +++++
C7040  IF (MODOPT(4).EQ.0) GO TO 705
      IF (MODOPT(4).EQ.0) GO TO 705
C +++++
C
C               INITIALIZE / COMPUTE  GROWTH RATES
C
        CALL GROW
        IPASS = 1
        DO 7041 I=1,NREACH
        NCELR = NCELRH(I)
        DO 7041 J=1,NCELR
        IOR = ICLORD(I,J)
7041    GROWTH(IOR) = Z(IOR)
704   IF(MODOPT(4).EQ.0) GO TO 705
      NT = 8
      CALL ALGAES
      CALL SOVMAT
      DO 804 I=1,NCELLS
      ALGAE(I) = Z(I)
      IF (ALGAE(I).GT.50.) ALGAE(I)=50.
      IF (ALGAE(I).LE.0.0) ALGAE(I)=0.00001
  804 CONTINUE
CCC
CCC                     G.9 Phospohrus.
CCC
  705 IF (MODOPT(5).EQ.0) GO TO 706
        NT=22
        CALL PORGS
        CALL SOVMAT
        DO 8050 I=1,NCELLS
        PORG(I) = Z(I)
8050    CONTINUE
      NT = 9
      CALL PO4S
      CALL SOVMAT
      DO 805 I=1,NCELLS
      PHOS(I) = Z(I)
  805 CONTINUE
CCC
CCC                     G.10 Nitrogens (Ammonia, Nitrite, and
CCC                           Nitrate).
CCC
  706 IF (MODOPT(6).EQ.0) GO TO 707
        NT=21
        CALL NH2S
        CALL SOVMAT
        DO 8060 I=1,NCELLS
        CNH2(I) = Z(I)
8060    CONTINUE
      NT = 10
CQ2E
CQ2E            NITRIFICATION INHIBITION AT LOW DO
CQ2E
        DO 846 I=1,NREACH
        NCELR = NCELRH(I)
        DO 846 J=1,NCELR
        IOR = ICLORD(I,J)
      CORDO(IOR) = 1.0
      IF(KNITRF.GE.10.) GO TO 8460
      EXPNIT = KNITRF*DO2(IOR)
      IF(EXPNIT.LT.10.) CORDO(IOR) = 1.-EXP(-EXPNIT)
8460  CONTINUE
        TC=0.556*(T(IOR)-68.0)
        KNH3(IOR) = CKNH3(I)*CORDO(IOR)*THETA(7)**TC
846     KNO2(IOR) = CKNO2(I)*CORDO(IOR)*THETA(9)**TC
847     CONTINUE
      CALL NH3S
      CALL SOVMAT
      DO 806 I=1,NCELLS
      CNH3(I) = Z(I)
  806 CONTINUE
      NT = 11
      CALL NO2S
      CALL SOVMAT
      DO 816 I=1,NCELLS
      CNO2(I) = Z(I)
  816 CONTINUE
      NT = 12
      CALL NO3S
      CALL SOVMAT
      DO 826 I=1,NCELLS
      CNO3(I) = Z(I)
  826 CONTINUE
CCC
CCC                     G.11 Dissolved oxygen.
CCC
  707 IF (MODOPT(7).EQ.0) GO TO 7999
      NT = 13
7070  CONTINUE
      CALL DOS
      CALL SOVMAT
      DO 803 I=1,NCELLS
      DO2(I)=Z(I)
  803 CONTINUE
 7999 CONTINUE
C
C + + + + + ++ +
C
      RETURN
      END
