CC 		This file contains the program for the mathematical
CC	water quality model QUAL-2, SEMCOG Version (QL2SMG).  The
CC	program was obtained from the Southeast Michigan Council
CC	of Governments with the assistance of EPA Region V.
CC	The reader is referred to the NCASI report on QL2SMG and
CC	to the SEMCOG documentation report for detailed information
CC	on the model.
CC
CC		QL2SMG is one of the current(1979) versions of the
CC	mathematical water quality model QUAL-2.  The QL2SMG model will
CC	will predict both the temporal and spatial variations in a
CC	river of the following water quality variables: temperature,
CC	conservative mineral, carbonaceous BOD, algae, phosphorus,
CC	ammonia, nitrite, nitrate, dissolved oxygen, coliform, and
CC	an arbitrary non-conservative.
CC
CC		QL2SMG can simulate either the steady-state or pseudo
CC	dynamic response of a river system to a set of specified
CC	input conditions.  In the steady mode, all of the varibles
CC	listed above can be solved directly for the steady solution.
CC	In the dynamic mode, the model routes the water quality
CC	variables on an hourly basis.  The primary use of the dynamic
CC	mode is for the simulation of system response to diurnal
CC	changes in temperature and solar radiation.  In all cases,
CC	a numerical implicit finite difference procedure is used to
CC	solve the advective dispersion equations.  In addition, the
CC	program has the capability to determine the streamflow
CC	required to maintain a preselected target dissolved oxygen
CC	level.
CC
CC		The program has been modified by NCASI from the
CC	version obtained from SEMCOG to correct errors and omissions.
CC	The modifications are listed here, identified where they
CC	occur in the program listing, and described in the 
CC	NCASI report on QL2SMG.
CC
CC		1. MAIN Program.  Add a test for the units of CKL
CC		    and SONET. Delete adjustment of the units of
CC		    TINIT. Move re-entry position of the flow
CC		    augmentation loop.  Add write statements
CC		    to print out the solar radiation values for
CC		    algae and temperature simulations.
CC
CC		2. Subroutine HEATER. Revamp the logic used to
CC		    calulate a daily average value of solar
CC		    radiation.  Add a test for reflectivity.
CC		    Replace TAN function with SIN/COS.
CC
CC		3. Subroutine INDATA.  Adjust initialization of
CC		    the IRCHNO and CK2 arrays.  Modify the default
CC		    manning roughness coefficient.
CC
CC		4. Subroutine SOVMAT.  Add print flag, IRPT1, to
CC		    the subroutine argument.
CC
CC		5. Subroutine TEMPSS.  Modify the units of solar
CC		    radiation term and Bowen's ratio.
CC
CC		6. Subroutine HEATEX.  Add a test for reflectivity. 
CC		    Replace TAN function with SIN/COS.
CC	
CC		7. Subroutine TRIMAT.  Adjust the value of the
CC		    main diagonal term, X(IOR), for junction
CC		    elements.
CC
CC		8. Subroutine HYDRAU.  Adjust the value of the
CC		    volume factor, DTOVCL(IOR) for junction
CC		    elements.  Add a dummy index to CALL CHANL
CC		    statements.
CC
CC		9. Subroutine DOS.  Delete the DO saturation
CC		    constraint.
CC
CC	       10. Subroutine REAERC.  Correct units on Tsivoglou-
CC		    Wallace K2 option.  Incorporate base 10 
CC		    natural log into coefficient term.
CC
CC
CC		
CC	Key to the comment statements in the program.
CC
CC		C = Original comments in QUAL-2 SEMCOG.
CC		CC = NCASI corrections and/or additions.
CC		CCC = NCASI commentary references.
CC
C        PROGRAM QUAL-2
C
C                            QUAL-2 IS A SET OF INTERRELATED STREAM
C                             QUALITY ROUTING MODELS. IT HAS THE
C                             CAPABILITY TO ROUTE TEMP.,BOD/DO,
C                             NITROGEN SERIES, PHOSPHATE, ALAGE,
C                             COLIFORMS, RADIO NUCLIDE, AND
C                             UP TO THREE CONSERVATIVE MINERALS
C                             THROUGH A FULLY-MIXED STREAM SYSTEM.
C                             THESE PARAMETERS CAN BE ROUTED ON AN
C                             INDIVIDUAL BASIS OR SIMULTANEOUSLY IN
C                             SUCH A COMBINATION AS THE USER MAY
C                             DESIRE. QUAL-1 ALSO HAS THE CAPABILITY
C                             TO COMPUTE THE FLOW AUGMENTATION REQED.
C                             TO MEET PRESELECTED MIMIMUM DO LEVELS.
C                             HYDRAULICS ARE CONSIDERED STEADY-STATE.
C
      COMMON/TITRCH/TITLE(20,20),RCHID(75,5),RMTHOR(75),RMTEOR(75),
     *       NHWWAR(15),TARGDO(75),IAUGOR(75,6),NCELRH(75),IFLAG(75,20),
     *       ICLORD(75,20),COEFQV(75),EXPOQV(75),COEFQH(75),EXPOQH(75),
     *       CMANN(75),CK1(75),CK3(75),K2OPT(75),CK2(75),COEQK2(75),
     *       EXPQK2(75),TINIT(75),DOINIT(75),BOINIT(75),COINIT(75,3),
     *       QI(75),TI(75),DOI(75),BODI(75),CONSI(75,3),JUNCID(15,5),
     *       JUNC(15,3),HWTRID(15,5),HWFLOW(15),HWTEMP(15),HWDO(15),
     *       HWBOD(15),HWCONS(15,3),WASTID(90,5),TRFACT(90),WSFLOW(90),
     *       WSTEMP(90),WSDO(90),WSBOD(90),WSCONS(90,3),QATOT(15),
     *       A(500),B(500),C(500),D(15),S(500),Z(500),W(500),G(500),
     *       FLOW(500),DEPTH(500),VEL(500),DTOVCL(500),K2(500),K1(500),
     *       HSNET(500),DL(500),VHW(15),DEPHW(15),DLHW(15),T(500),
     *       DO(500),BOD(500),CONS(500,3),PTIME,TPRINT,DELX,
     *       NHWTRS,NREACH,NWASTE,NJUNC,DELT,D1LT,D2LT,DTODX2,DT2ODX,
     *       LAT,LSM,LLM,ELEV,DAT,AE,BE,DAYOFY,DRYBLB,WETBLB,DEWPT,
     *       ATMPR,WIND,CLOUD,SONET,NI,NJ,TRLCD,TOFDAY,NT,NC,TIME,NCS
C
      COMMON/MODIF/ CK4(75),CK5(75),CKNH3(75),CKNO2(75),CKNO3(75),
     *       CKN,CKP,CKL,ALPHAO(75),ALPHA1,ALPHA2,ALPHA3,ALPHA4,
     *       ALPHA5,ALPHA6,GROMAX,RESPRT,ALGSET(75),SPHOS(75),
     *       SNH3(75),KNH3(500),KNO2(500),RESPRR(500),COLI(500),
     *       ALGAE(500),PHOS(500),CNH3(500),CNO2(500),CNO3(500),
     *       COLIR(75),ALGI(75),PHOSI(75),CNH3I(75),CNO2I(75),
     *       CNO3I(75),COLIIT(75),ALGIT(75),PHOSIT(75),CNH3IT(75),
     *       CNO2IT(75),CNO3IT(75),WSCOLI(90),WSALG(90),WSPHOS(90),
     *       WSNH3(90),WSNO2(90),WSNO3(90),HWCOLI(15),HWALG(15),
     *       HWPHOS(15),HWNH3(15),HWNO2(15),HWNO3(15),GROWTH(500),
     *       MODOPT(10),IRCHNO(750),EXCOEF(75)
C
      COMMON/SSTATE/ X(500),ISS
      COMMON/SSTEMP/JT(500),SOLRCH(75),CLDRCH(75),PATRCH(75),TDBRCH(75),
     *TWBRCH(75),WINRCH(75)
C
      COMMON/RADION/ CK6(75),RADNIT(75),RADNI(75),HWRADN(15),WSRADN(90),
     *               RADIO(500)
      SAVE /TITRCH/,/MODIF/,/SSTATE/,/SSTEMP/,/RADION/
C
      DIMENSION TJ1(500)
      DIMENSION TITL19(15),TITL20(15)
      REAL K1,K2,LAT,LLM,LSM,JUNCID
      DATA TITL19              /4H ALG,4HAE G,4HROWT,4HH RA,4HTES ,4HIN 
     *P,4HER D,4HAY A,4HRE  ,4H    ,4H    ,4H    ,4H    ,4H    ,4H    /
      DATA TITL20              /4H PHO,4HTOSY,4HNTHE,4HSIS-,4HRESP,4HIRA
     *T,4HION ,4HRATI,4HOS A,4HRE  ,4H    ,4H    ,4H    ,4H    ,4H    /
CCC
CCC		NCASI Commentary, MAIN - Section A. (QUAL2 Step 1-0)
CCC			A.  Complete definition of TITLE(I,J) array.
CCC
      DO 10 J=6,20
      I=J-5
      TITLE(19,J)=TITL19(I)
      TITLE(20,J)=TITL20(I)
   10 CONTINUE
CCC
CCC		NCASI Commentary, MAIN - Section B. (QUAL2 Steps 2-0,
CCC		    3-0, and 4-0).
CCC			B. CALL INDATA.  Return with all required
CCC			    input data, except local climatology.
CCC
      CALL INDATA(ILIST,IRPT1,IAUGOP,TMAX,NCELLS)
CCC
CCC		NCASI Commentary, MAIN - Section C. (QUAL2 Step 5-0)
CCC			C. Calculate routing constants.
CCC
      DELX=DELX*5280.0
      IF (ISS) 901,901,900
  900 D1LT = 1.0/24.0
      D2LT = 1.0
      DELT = 3600.0
      IF (PTIME.LE.0.) PTIME=TMAX
      GO TO 902
  901 D1LT = DELT/24.0
      D2LT=DELT
      DELT=DELT*3600.0
      TMAX=TMAX-0.01
  902 CONTINUE
      DTODX2=DELT/(DELX*DELX)
      DT2ODX=2.0*DELT/DELX
CC
CC	    Move the call to HYDRAU and TRIMAT to statement 111+1
CC	      below so that the flow augmentation option can be
CC	      used with the steady state algae simulation.
CC
CCC
CCC		NCASI Commentary, MAIN - Section D.
CCC			D. Compute average light intensity for
CCC			    steady state algae computations.
CCC
CCC			D.1  Convert CKL to langleys per hour.
CCC
      CKL=CKL*60.
CCC
CCC			D.2  Convert CKL and SONET to BTU/ft2-hr and
CCC			      BTU/ft2 if temperature is being 
CCC			      simulated.
CCC
      IF(MODOPT(2).GT.0) CKL=CKL*3.685
CC
CC	    Add statements to change the units of SONET to BTU/ft2
CC	     to agree with those of CKL, if temperature is
CC	     being simulated.
CC
	IF(MODOPT(2).GT.0) SONET = SONET*3.685
CC
CC	     At this point the units of SONET and CKL are 
CC	      BTU/ft2 and BTU/ft2-hr, if temperature is being
CC	      simulated.  The units are langleys and langleys/hr
CC	      if temperature is not being simulated.  The units 
CC	      of SONET and CKL must agree for SONNEN, the
CC	      average light intensity over 24 hours, to be
CC	      calculated correctly.
CC	     SONNEN is computed and used in the steady state
CC	      algae simulation only.
CC
CCC
CCC			D.3  Test for steady/dynamic simulation.
CCC
      IF (ISS.LE.0) GO TO 110
CCC
CCC			D.4  Test for algae simulation.
CCC
CC
CC	     Add a test for MODOPT(4) - Algae.
CC
	IF(MODOPT(4).LE.0) GO TO 110
CC
CCC
CCC			D.5  Calculation of average light
CCC			      intensity (SONNEN) for steady
CCC			      state routing.
CCC
      FUNCT=0.0
      IF (SONET.LT.1.0E-4) GO TO 51
      NDLH=14
      DLH=FLOAT(NDLH)
	SOAVE = SONET/DLH
      DO 50 M=1,NDLH
      FM=M
      TOT=SOAVE*(1.0-COS(6.28*FM/DLH))
      FUNCT=FUNCT+(TOT/(CKL+TOT))
50	CONTINUE
   51 CONTINUE
      FUNCT=FUNCT/24.
	SONNEN = CKL*FUNCT/(1.-FUNCT)
CC
CC	     Add a write statements to print the values of 
CC	      light intensity used in the steady state
CC	      algae simulation.
CC
	WRITE(NJ,20)
20	FORMAT(//'  VALUES USED TO COMPUTE LIGHT INTENSITY',
	1' FOR STEADY STATE ALGAL SIMULATION.'/)
	IF(MODOPT(2).GT.0) GO TO 25
	WRITE(NJ,21) CKL,SONET,SONNEN,DLH
21	FORMAT(//'  ALGAL LIGHT HALF SAT CONSTANT (CKL) = ',
	1E12.4,'  LANGLEYS/HR'/'  TOTAL SOLAR RADIATION',
	2' (SONET) =  ',E12.4,'  LANGLEYS'/'  AVG LIGHT',
	3' INTENSITY OVER 24 HRS (SONNEN) =  ',E12.4,
	4' LANGLEYS/HR'/'  NUMBER OF DAY LIGHT HOURS (DLH) =  ',
	5F5.1//)
	GO TO 26
25	WRITE(NJ,22) CKL,SONET,SONNEN,DLH
22	FORMAT(//'  ALGAL LIGHT HALF SAT CONSTANT (CKL) = ',
	1E12.4,'  BTU/FT2-HR'/'  TOTAL SOLAR RADIATION',
	2' (SONET) =  ',E12.4,'  BTU/FT2'/'  AVG LIGHT',
	3' INTENSITY OVER 24 HRS (SONNEN) =  ',E12.4,
	4' BTU/FT2-HR'/'  NUMBER OF DAY LIGHT HOURS (DLH) =  ',
	5F5.1//)
26	CONTINUE
CC
CC	     Add statements to set the value of SONNEN 
CC	      equal to zero for the dynamic simulation mode.
CC
	GO TO 111
110	CONTINUE
	SONNEN = 0.0
111	CONTINUE
CCC
CCC		NCASI Commentary, MAIN - Section E. (QUAL2 Step 7-1)
CCC			E. Complete system hydraulics and set up
CCC			    hydrodynamic part of tridiagonal 
CCC			    matrix.
CCC
CC
CC	     Insert the call to HYDRAU and TRIMAT here for
CC	      compatability with the flow augmentation option.
CC
  998 CALL HYDRAU
      CALL TRIMAT
CC
CC
CCC
CCC		NCASI Commentary, MAIN - Section F. (QUAL2 Step 6-0)
CCC			F. Set initial conditions for all
CCC			    computational elements.
CCC
      DO 915 I=1,NREACH
      NCELR=NCELRH(I)
      DO 915 J=1,NCELR
      IOR=ICLORD(I,J)
      T(IOR)=TINIT(I)
CC
CC	     Delete the following statement, because TINIT has
CC	      already been corrected for metric units in
CC	      SUBROUTINE INDATA.
CC
C	IF(METRIC.GT.0)T(IOR)=1.8*T(IOR)+32.0
CC
CC
      DO(IOR)=DOINIT(I)
      BOD(IOR)=BOINIT(I)
      CONS(IOR,1)=COINIT(I,1)
      CONS(IOR,2)=COINIT(I,2)
      CONS(IOR,3)=COINIT(I,3)
      ALGAE(IOR)=ALGIT(I)
      PHOS(IOR)=PHOSIT(I)
      CNH3(IOR)=CNH3IT(I)
      CNO2(IOR)=CNO2IT(I)
      CNO3(IOR)=CNO3IT(I)
      COLI(IOR)=COLIIT(I)
      RADIO(IOR)=RADNIT(I)
      IF(MODOPT(4).EQ.0)  GO TO 915
      TC=0.556*(T(IOR)-68.0)
      EXPT=EXP(-EXCOEF(I)*DEPTH(IOR))
      TLOG=ALOG((CKL+SONNEN)/(CKL+SONNEN*EXPT))
      GROWTH(IOR)=GROMAX*TLOG/(EXCOEF(I)*DEPTH(IOR))
      GROWTH(IOR)=GROWTH(IOR)*1.047**TC
  915 CONTINUE
      DO 922 NWS=1,NWASTE
      EFLBOD=1.0-TRFACT(NWS)
      WSBOD(NWS)=EFLBOD*WSBOD(NWS)
  922 CONTINUE
CCC
CCC		NCASI Commentary, MAIN - Section G. (QUAL2 Step 7-0)
CCC			G. Begin computations.
CCC
CCC			G.1 Initialize iteration counters for
CCC			     steady state simulations.
CCC
      NITER=0
      ITER=0
CCC
CCC			G.2 Advance time counters for dynamic
CCC			     simulations.
CCC
  999 TIME=TIME+D2LT
      TPRINT=TPRINT+D2LT
CCC
CCC			G.3 Route water quality constituents
CCC			     according to the value of
CCC			     MODOPT(I). (QUAL2 Step 7-2)
CCC
C                                       MODOPT(1)   CONSERVATIVE
C                                       MODOPT(2)   TEMPERATURE
C                                       MODOPT(3)   BOD
C                                       MODOPT(4)   CHLOROPHYLL A
C                                       MODOPT(5)   PHOSPHOROUS
C                                       MODOPT(6)   NH3,NO2,NO3
C                                       MODOPT(7)   OXYGEN
C                                       MODOPT(8)   COLIFORMS
C                                       MODOPT(9)   NON-CONSERVATIVE
CC
CC	     Add the flag IRPT1 to the argument of SOVMAT so that
CC	      intermediate output will be printed in the dynamic
CC	      simulations, if desired.
CC
CCC
CCC			G.4 Conservative mineral.
CCC
      IF (MODOPT(1).EQ.0) GO TO 702
  701 NT=3
      DO 777 NC=1,NCS
      CALL CONSVT
      CALL SOVMAT(IRPT1)
      NT=NT+1
      DO 808 I=1,NCELLS
      CONS(I,NC)=Z(I)
  808 CONTINUE
  777 CONTINUE
CCC
CCC			G.5 Temperature - Dynamic simulation.
CCC
  702 IF (MODOPT(2).EQ.0) GO TO 703
      NT=6
      IF (ISS.GT.0.) GO TO 7702
      CALL TEMPS
      CALL SOVMAT(IRPT1)
      DO 800 I=1,NCELLS
      T(I)=Z(I)
  800 CONTINUE
      GO TO 703
CCC
CCC			G.6 Temperature - Steady state simulation.
CCC
 7702 IF (NITER.GT.0) GO TO 703
 7703 DO 7706 I=1,NCELLS
      TJ1(I)=(T(I)-35.)/5.
 7706 CONTINUE
      CALL TEMPSS(NITER)
      CALL SOVMAT(IRPT1)
      MM=0
      DO 7704 I=1,NCELLS
      T(I)=Z(I)
      TJ=(T(I)-35.)/5.
      M=TJ+1
      IF (JT(I).EQ.M.AND.M.GT.0.AND.M.LE.21) GO TO 7704
      IF (JT(I).NE.M.AND.ABS(TJ-TJ1(I)).LE.0.10) GO TO 7704
      MM=MM+1
 7704 CONTINUE
      NITER=NITER+1
      WRITE (NJ,7705) MM,NITER
 7705 FORMAT (15X,9H*** MM= ,I5,13H *** NITER = I5)
      IF (NITER.GT.10) CALL EXIT
      IF (MM.GT.0) GO TO 7703
CCC
CCC			G.7 Carbonaceous BOD.
CCC
  703 IF (MODOPT(3).EQ.0) GO TO 704
      NT = 7
      CALL BODS
      CALL SOVMAT(IRPT1)
      DO 802 I=1,NCELLS
      BOD(I)=Z(I)
  802 CONTINUE
CCC
CCC			G.8 Algae (Chlorophyll a).
CCC
  704 IF (MODOPT(4).EQ.0) GO TO 705
      NT = 8
      CALL ALGAES
      CALL SOVMAT(IRPT1)
      DO 804 I=1,NCELLS
      ALGAE(I) = Z(I)
      IF (ALGAE(I).GT.50.) ALGAE(I)=50.
      IF (ALGAE(I).LE.0.0) ALGAE(I)=0.00001
  804 CONTINUE
CCC
CCC			G.9 Phospohrus.
CCC
  705 IF (MODOPT(5).EQ.0) GO TO 706
      NT = 9
      CALL PO4S
      CALL SOVMAT(IRPT1)
      DO 805 I=1,NCELLS
      PHOS(I) = Z(I)
  805 CONTINUE
CCC
CCC			G.10 Nitrogens (Ammonia, Nitrite, and
CCC			      Nitrate).
CCC
  706 IF (MODOPT(6).EQ.0) GO TO 707
      NT = 10
      CALL NH3S
      CALL SOVMAT(IRPT1)
      DO 806 I=1,NCELLS
      CNH3(I) = Z(I)
  806 CONTINUE
      NT = 11
      CALL NO2S
      CALL SOVMAT(IRPT1)
      DO 816 I=1,NCELLS
      CNO2(I) = Z(I)
  816 CONTINUE
      NT = 12
      CALL NO3S
      CALL SOVMAT(IRPT1)
      DO 826 I=1,NCELLS
      CNO3(I) = Z(I)
  826 CONTINUE
CCC
CCC			G.11 Dissolved oxygen.
CCC
  707 IF (MODOPT(7).EQ.0) GO TO 708
      NT = 13
      CALL REAERC
      CALL DOS
      CALL SOVMAT(IRPT1)
      DO 803 I=1,NCELLS
      DO(I)=Z(I)
  803 CONTINUE
CCC
CCC			G.12 Coliform.
CCC
  708 IF (MODOPT(8).EQ.0) GO TO 799
      NT = 14
      CALL COLIS
      CALL SOVMAT(IRPT1)
      DO 807 I=1,NCELLS
      COLI(I) = Z(I)
  807 CONTINUE
  799 CONTINUE
CCC
CCC			G.13 Arbitrary non-conservative.
CCC
      IF(MODOPT(9).EQ.0) GO TO 7999
      NT=15
      CALL RADIOS
      CALL SOVMAT(IRPT1)
      DO 809 I=1,NCELLS
      RADIO(I)=Z(I)
  809 CONTINUE
 7999 CONTINUE
CCC
CCC			G.14 Test print counter for 
CCC			      reinitialization.
CCC
      IF (TPRINT.LT.PTIME) GO TO 997
      TPRINT=0.0
  997 CONTINUE
CCC
CCC			G.15 Test for steady state modeling.
CCC			      (QUAL2 Step 7-3)
CCC
      IF(ISS) 9996,9996,9990
CCC
CCC		NCASI Commentary, MAIN - Section H. 
CCC			H. Adjustment/check of algal growth rate,
CCC			    N, and P concentrations in steady 
CCC			     state simulations.
CCC
CCC			H.1 Test whether algae are being simulated.
CCC
 9990 IF (MODOPT(4)) 1001,1001,9992
CCC
CCC			H.2 Initialize and increment counters.
CCC
 9992 NUM = 0
      ITER = ITER + 1
      WRITE (NJ,7779) ITER
 7779 FORMAT (12H ITERATION  ,I5)
CCC
CCC			H.3 Set up loop on reaches and elements.
CCC
      DO 9994 JJ=1,NREACH
      NCELR=NCELRH(JJ)
      DO 9994 KK=1,NCELR
      I=ICLORD(JJ,KK)
CCC
CCC			H.4 Calculate that part of the algal 
CCC			    growth constant affected by light
CCC			    intensity.
CCC
      TC=0.556*(T(I)-68.0)
      EXPT=EXP(-EXCOEF(JJ)*DEPTH(I))
      TLOG=ALOG((CKL+SONNEN)/(CKL+SONNEN*EXPT))
      XGROW=GROMAX*TLOG/(EXCOEF(JJ)*DEPTH(I))
      XGROW=XGROW*1.047**TC
      TT = DELX/(VEL(I)*86400.)
      TGROW = XGROW
CCC
CCC			H.7 Test for phosphorus routing and compute
CCC			     correction to phosphorus concentration
CCC			     to match algal growth constant.
CCC
      IF (MODOPT(5).EQ.0) GO TO 9820
      DGDP = -1.0/(ALPHA2*ALGAE(I)*TT)
      XA = DGDP
      XB = GROWTH(I)+(CKP+PHOS(I))*DGDP-XGROW
      XC = GROWTH(I)*(CKP+PHOS(I))-XGROW*PHOS(I)
      ROOT = SQRT(XB*XB-4.0*XA*XC)
      DPHOS=-0.5*XB/XA + 0.5*ROOT/ABS(XA)
      PHOS(I) = PHOS(I)+DPHOS
      IF (PHOS(I).LT.0.0) PHOS(I) = 0.0
      TGROW = XGROW*PHOS(I)/(CKP+PHOS(I))
CCC
CCC			H.8 Test for nitrate routing and compute
CCC			     correction to nitrate concentration
CCC			     to match algal growth constant.
CCC
 9820 IF (MODOPT(6).EQ.0) GO TO 9840
      DGDN = -1.0/(ALPHA1*ALGAE(I)*TT)
      XA = DGDN
      XB = GROW
