CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC 
C                    DOCUMENTATION FOR SUBROUTINE 
C 
C                                RAND 
C 
C    *  IDENTIFICATION 
C 
C        . FILE NAME:  RAND.FTN 
C 
C        . SOURCE LANGUAGE:  FORTRAN IV 
C 
C        . AUTHOR:  F.G. Lether after L. Schrage (see referenc below) 
C 
C        . DATE: April 27,1985 
C 
C        . LATEST REVISION: April 28,1985 
C 
C        . MACHINE: DEC PDP 11/70 
C 
C    *  PURPOSE  
C 
C          Function RAND returns a pseudo-random decimal number 
C          in the open interval (0,1) . 
C 
C    *  USAGE 
C 
C        . CALLING SEQUENCE:  FX = RAND(IX) 
C 
C        . INPUT ARGUMENT 
C 
C               NAME    TYPE    DESCRIPTION 
C               -----   ----    ----------- 
C               IX      I*4     Seed value for random number 
C                               generator.  IX can be any 
C                               integer that satisfies : 
C                               0 < IX < 2147483647 = 2**31 -1 
C 
C        . OUTPUT ARGUMENT 
C 
C               NAME    TYPE    DESCRIPTION 
C               ----    ----    ----------- 
C               RAND    R*4     Random decimal number in (0,1) 
C 
C    *  RESTRICTIONS 
C 
C        . MACHINE DEPENDENCY: Machine must be able to represent all 
C                              integers in the interval : 
C                              [-2**31 + 1 , 2**31 - 1] 
C 
C        . OTHER ROUTINES REQUIRED: None 
C 
C        . COMMON STORAGE: None 
C 
C    *  ALGORITHM OR METHOD 
C 
C          Given the seed IX(i) = IX, the random number generator 
C          produces a positive integer IX(i+1) by the recursion 
C                       IX(i+1) = A*IX(i) mod P  , 
C          where P = Mersenne prime number 2**31 -1 = 2147483647 and 
C          A = 7**5 = 16807.  Thus all integers IX will satisfy the 
C          inequality 0 < IX < 2**31 - 1.  Most large computers and 
C          many minicomputers can represent integers in this latter 
C          range with the native INTEGER arithmetic format. (However, 
C          many microcomputers cannot and this program will not work 
C          correctly on such machines.)  RAND converts IX to a decimal 
C          number in (0,1) by dividing the "random" integer IX by 
C          2**31 - 1 prior to returning the value of  
C                     RAND = IX(i+1) / (2**31 - 1) . 
C 
C          The user may check the correctness of the implementation 
C          on his or her machine cpmputer by verifying that if 
C          IX(0) = 1, then IX(1000) = 522329230 . 
C 
C    *  REFERENCES 
C 
C          Schrage,L., A More Portable FORTRAN Random Number Generator 
C          ACM Transactions on Mathematical Software, v.5, no. 2, 
C          June 1979, pp. 132-138. 
C 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC 
C
        FUNCTION RAND(IX) 
        INTEGER A,P,IX,B15,B16,XHI,XALO,LEFTLO,FHI,K
C        INTEGER*4 A,P,IX,B15,B16,XHI,XALO,LEFTLO,FHI,K
C 
        DATA A,B15,B16,P / 16807 , 32768 , 65536 , 2147483647 / 
C 
        XHI = IX / B16 
        XALO = (IX - XHI * B16) * A 
        LEFTLO = XALO / B16 
        FHI = XHI * A + LEFTLO 
        K = FHI / B15 
        IX = (((XALO-LEFTLO*B16) - P) + (FHI-K*B15)*B16) + K 
        IF (IX .LT. 0) IX = IX + P
        RAND = FLOAT(IX) * 4.656612875E-10
        RETURN
        END
