      SUBROUTINE REAERC
C
C                             REAERC CAN EITHER READ IN REAERATION
C                             COEFFICIENTS (OPTION1), COMPUTE THEM
C                             USING A SELECTED EQUATION (OPTION 2,3,
C                             4,5, AND 6), OR COMPUTE THEM BASED ON
C                             K2=A*Q**B.  ALL K2'S  ARE TO THE BASE E.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
C
CCC
CCC             NCASI Commentary, REAERC - Section A. (QUAL2 Step 1-0)
CCC                     A. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      KOPT=K2OPT(I)
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
      IFL=IFLAG(I,J)
CCC
CCC                     A.7 Calculate K2 for each element,
CCC                          according to KOPT option.
CCC                          (QUAL2 Step 1-1)
C
C                                       KOPT = 1  K2 IS READ IN.
C                                       KOPT = 2  CHURCHILL (1962)
C                                       KOPT = 3  O'CONNER - DOBBINS (19
C                                       KOPT = 4  OWENS, EDWARDS, - GIBB
C                                       KOPT = 5  THACKSTON - KRENKEL (1
C                                       KOPT = 6  LANGBIEN - DURUM (1967
C                                       KOPT = 7  K2 = A * Q ** B
C                                       KOPT = 8  TSIVOGLOU - WALLACE (1
C
      GO TO (101,102,103,104,105,106,107,108), KOPT
CC
CC              The following changes have been made to the
CC               K2 equations.
CC
CC                      1. Incorporate the correct ln(10) = 2.3026
CC                          into the coefficient of the K2
CC                          equations.  This change affects
CC                          options 2, 4, 5, and 6.
CC
CC                      2. Incorporate the numerical value of
CC                          Dm into the coefficient of the
CC                          O'Connor-Dobbins equation.
CC
CC                      3. Change the exponent on depth in the
CC                          Langbein-Durum equation to 1.33 as
CC                          originally given in their paper.
CC
CC                      4. Correct units of K2 from per hour to
CC                          per day for Tsivoglou-Wallace option.
CC
  101 K2(IOR)=CK2(I)
CCC
CCC             NCASI Commentary, REAERC - Section B.
CCC                     B. Option 1: K2 read in (base e, 20 C).
CCC
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section C.
CCC                     C. Option 2: Churchill.
CCC
  102 K2(IOR)=11.57*VEL(IOR)**0.969/DEPTH(IOR)**1.673
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section D.
CCC                     D. Option 3: O'Connor-Dobbins.
CCC
103     K2(IOR) = 12.96*SQRT(VEL(IOR))/DEPTH(IOR)**1.5
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section E.
CCC                     E. Option 4: Owens, Edwards, and Gibbs.
CCC
  104 K2(IOR)=21.64*VEL(IOR)**0.67/DEPTH(IOR)**1.85
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section F.
CCC                     F. Option 5: Thackston-Krenkel.
CCC
  105 F=0.176*VEL(IOR)/SQRT(DEPTH(IOR))
      SHRVEL=5.675*VEL(IOR)*CMANN(I)/(1.49*DEPTH(IOR)**1.167)
      K2(IOR)=24.88*(1.0+SQRT(F))*SHRVEL
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section G.
CCC                     G. Option 6: Langbein-Durum.
CCC
  106 K2(IOR)=7.60*VEL(IOR)/DEPTH(IOR)**1.33
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section H.
CCC                     H. Option 7: Correlation with flow.
CCC
  107 K2(IOR)=COEQK2(I)*FLOW(IOR)**EXPQK2(I)
      GO TO 100
CCC
CCC             NCASI Commentary, REAERC - Section I.
CCC                     I. Option 8: Tsivoglou-Wallace.
CCC
  108 CC2 = COEQK2(I)
      SLOPE1 = EXPQK2(I)
      IF(SLOPE1.GT.0.0) GO TO 81
      IF(CMANN(I).GT.0.0) GO TO 82
      WRITE(NJ,999)
  999 FORMAT(1H1,10X,54H***IMPROPER PARAMETER SPECIFICATION FOR K2 OPTIO
     1N 8 -- /11X,42H***MUST SPECIFY CHANNEL SLOPE OR ROUGHNESS )
C//   CALL EXIT
      STOP
C  CALCULATE DELTA H FROM CHANNEL SLOPE
   81 K2(IOR) = SLOPE1 * VEL(IOR) * CC2 * 3600. * 24.
      GO TO 100
C  CALCULATE DELTA H FROM MANNING EQ.
   82 XK2T = CMANN(I)*CMANN(I)*VEL(IOR)**3/DEPTH(IOR)**(4./3.)
      K2(IOR) = CC2*XK2T*1630.3*24.0
CCC
CCC             NCASI Commentary, REAERC - Section J.
CCC                     J. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, REAERC - Section K.
CCC                     K. Return to MAIN.
CCC
      RETURN
      END
