      SUBROUTINE SENS
C
C      THIS SUBROUTINE WRITES THE UNCAS FINAL REPORT FOR THE SENSITIVITY
C      OPTION.  THE REPORT CONSISTS OF THE CHANGE IN THE VALUE OF THE 
C      OUTPUT VARIABLE (SENSITIVITY) RESULTING FROM THE GIVEN INPUT
C      PERTURBATION.  THIS SUBROUTINE IS MODELED AFTER THE QUAL2E 
C      SUBROUTINES WRPT3A AND WRPT3B.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
        INCLUDE 'QUNCAS.VAR'
C
      DIMENSION Y(36),SAVG(20),SMAX(20),SMIN(20),LOCMN(20),LOCMX(20)
C     DATA NPAGE/0/
      NPAGE=0
C
C      OPEN BASE CASE OUTPUT FROM STORAGE AND INITIALIZE
C      COUNTERS AND CONSTANTS.
C
C      NJ2=2
C      OPEN(UNIT=NJ2,STATUS='OLD',FILE='BASE.DAT')
C
C3P1    CHANGE NJ2 TO NJ4 FOR BASE.DAT READS/WRITES.
C3P1
C3P1      NJ4=4
      OPEN(UNIT=NJ4,FILE=FILNAM(7),STATUS='OLD',ERR=990)
      NHW = 0
      NWS = 0
      LP=100
      DELM = DELX / 5280.0
      IF( METOUT .GT. 0 ) DELM = DELM * 1.609
C
C      OUTPUT FOR HYDRAULIC VARIABLES
C
      IF(KFLHYD.EQ.0) GO TO 320
      DO 300 I = 1, NREACH
      DO 310 K=1,11
      SMAX(K)=0.0
      SMIN(K)=1.0E+10
      SAVG(K)=0.0
      LOCMN(K)=0
      LOCMX(K)=0
310   CONTINUE
      WRITE(NJ,6000)
      LP = LP + 2
      RLTHOR = RMTHOR(I)
      IF( METOUT .GT. 0 ) RLTHOR=RLTHOR*1.609
      NCELR = NCELRH(I)
      CNCELR = NCELR
      QINC = QI(I) / CNCELR
      IF( METOUT .GT. 0 ) QINC = QINC / 35.3133
      LPMX = 96-NCELR
      IF(LP.LE.LPMX)GO TO 288
      LP=0
      NPAGE = NPAGE + 1
      WRITE(NJ,6005) NPAGE,VERNUM
      IF( ISS .EQ. 0 ) WRITE(NJ,6007) TIME
      IF( ISS .GT. 0 ) WRITE(NJ,6008)
      WRITE(NJ,6009)
      IF(METOUT.EQ.0) WRITE(NJ,6010)
      IF(METOUT.GT.0) WRITE(NJ,6011)
288   CONTINUE
      DO 280 J = 1, NCELR
      LP = LP + 1
      IOR = ICLORD(I,J)
C
C     READ BASE CASE INFORMATION.
C
      READ(NJ4,6001) L
6001  FORMAT(I5)
      IF(L.NE.IOR) GO TO 700
      READ(NJ4,6002) (Y(K),K=1,36)
6002  FORMAT(8E14.6/)
C
C      COMPUTE SENSITIVITIES
C
C +++++
C  296 XMH = RLTHOR - FLOAT( J - 1 ) * DELM
      XMH = RLTHOR - FLOAT( J - 1 ) * DELM
C +++++
      XME = XMH - DELM
      Y(1)=FLOW(IOR)-Y(1)
      Y(2)=VEL(IOR)-Y(2)
      Y(3)=TRVTM(IOR)-Y(3)
      Y(4)=DEPTH(IOR)-Y(4)
      Y(5)=EWIDTH(IOR)-Y(5)
      Y(6)=VOLSEG(IOR)-Y(6)
      Y(7)=BAREA(IOR)-Y(7)
      Y(8)=XAREA(IOR)-Y(8)
      Y(9)=DL(IOR)-Y(9)
      Y(10)=XK2(IOR)-Y(10)
      Y(11)=CORDO(IOR)-Y(11)
      IF( METOUT .EQ. 0 ) GO TO 297
      Y(1) = Y(1) / 35.3133
      Y(2)= Y(2)/3.2808
      Y(4) = Y(4)/3.2808
      Y(5)= Y(5)/3.2808
      Y(6) = Y(6)/35.3133
      Y(7) = Y(7)/10.7636
      Y(8) = Y(8)/10.7636
      Y(9) = Y(9)/10.7636
  297 CONTINUE
C
C      SEARCH FOR MIN AND MAX, COMPUTE AVERAGE IN REACH
C
      Y(6) = Y(6)/1000.
      Y(7) = Y(7)/1000.
      DO 220 K=1,11
      SAVG(K)=SAVG(K)+Y(K)/CNCELR
      IF(ABS(Y(K)).GT.ABS(SMIN(K))) GO TO 222
      SMIN(K)=Y(K)
      LOCMN(K)=J
222   IF(ABS(Y(K)).LE.ABS(SMAX(K))) GO TO 220
      SMAX(K)=Y(K)
      LOCMX(K)=J
220   CONTINUE
C
C      WRITE HYDRAULIC SENSITIVITIES.
C
      WRITE(NJ,6015)IOR,I,J,XMH,XME,(Y(K),K=1,11)
  280 CONTINUE
      WRITE(NJ,6102) I
6102  FORMAT(/' SENSITIVITY SUMMARY FOR REACH:',I4)
      WRITE(NJ,6103) (SAVG(K),K=1,11)
6103  FORMAT(/4X,'AVERAGE SENSITIVITY',5X,1F8.2,2F8.3,2F9.3,2F12.2,
     * F12.2,F9.2,2F8.2)
      WRITE(NJ,6104) (SMAX(K),K=1,11),(LOCMX(KI),KI=1,11)
6104  FORMAT(/4X,'MAXIMUM SENSITIVITY',5X,1F8.2,2F8.3,2F9.3,2F12.2,
     * F12.2,F9.2,2F8.2/8X,'IN ELEMENT',9X,3I8,2I9,3I12,I9,2I8)
      WRITE(NJ,6105) (SMIN(K),K=1,11),(LOCMN(KI),KI=1,11)
6105  FORMAT(/4X,'MINIMUM SENSITIVITY',5X,1F8.2,2F8.3,2F9.3,2F12.2,
     * F12.2,F9.2,2F8.2/8X,'IN ELEMENT',9X,3I8,2I9,3I12,I9,2I8/)
      LP = LP + 11
300   CONTINUE
      REWIND NJ4
C
C      WATER QUALITY VARIABLES
C
320   CONTINUE
        LP=100
        DO 500 I=1,NREACH
      DO 510 K=1,20
      SMAX(K)=0.0
      SMIN(K)=1.0E+10
      SAVG(K)=0.0
      LOCMN(K)=0
      LOCMX(K)=0
510   CONTINUE
      NCELR = NCELRH(I)
        CNCELR = NCELR
        WRITE(NJ,6000)
        LP = LP + 2
      LPMX = 96-NCELR
        IF(LP.LE.LPMX) GO TO 450
      LP=0
        NPAGE = NPAGE + 1
        WRITE(NJ,6005) NPAGE,VERNUM
        IF(ISS.EQ.0) WRITE(NJ,6007) TIME
        IF(ISS.NE.0) WRITE(NJ,6008)
        WRITE(NJ,6029) (TITLE(II,13),II=3,5),TITLE(15,13)
        IF(METOUT.EQ.0) WRITE(NJ,6030)(TITLE(II,15),II=3,5)
     1 ,TITLE(15,15)
        IF(METOUT.GT.0) WRITE(NJ,6031) (TITLE(II,15),II=3,5)
     1 ,TITLE(15,15)
450   CONTINUE
        DO 480 J=1,NCELR
        LP = LP + 1
      IOR = ICLORD(I,J)
C
C      READ BASE CASE INFORMATION.
C
      READ(NJ4,6001) L
      IF(L.NE.IOR) GO TO 700
       READ(NJ4,6002) (Y(K),K=1,36)
        SUMN(IOR) = CNH2(IOR) + CNH3(IOR) + CNO2(IOR) + CNO3(IOR)
        SUMP(IOR) = PORG(IOR) + PHOS(IOR)
C
C      COMPUTE SENSITIVITIES.
C
      Y(1)=T(IOR)-Y(12)
      Y(2)=CONS(IOR,1)-Y(13)
      Y(3)=CONS(IOR,2)-Y(14)
      Y(4)=CONS(IOR,3)-Y(15)
      Y(5)=DO2(IOR)-Y(16)
      Y(6)=BOD(IOR)-Y(17)
      Y(7)=CNH2(IOR)-Y(18)
      Y(8)=CNH3(IOR)-Y(19)
      Y(9)=CNO2(IOR)-Y(20)
      Y(10)=CNO3(IOR)-Y(21)
      Y(11)=SUMN(IOR)-Y(22)
      Y(12)=PORG(IOR)-Y(23)
      Y(13)=PHOS(IOR)-Y(24)
      Y(14)=SUMP(IOR)-Y(25)
      Y(15)=COLI(IOR)-Y(26)
      Y(16)=ANC(IOR)-Y(27)
      Y(17)=ALGAE(IOR)-Y(28)
      Y(17) = Y(17)*ALPHAO(I)
        IF(METOUT.GT.0) Y(1) = Y(1)/1.8
C
C      SEARCH FOR MAX AND MIN, COMPUTE AVERAGE IN REACH.
C
      DO 420 K=1,17
      SAVG(K)=SAVG(K)+Y(K)/CNCELR
      IF(ABS(Y(K)).GT.ABS(SMIN(K))) GO TO 422
      SMIN(K)=Y(K)
      LOCMN(K)=J
422   IF(ABS(Y(K)).LE.ABS(SMAX(K))) GO TO 420
      SMAX(K)=Y(K)
      LOCMX(K)=J
420   CONTINUE
C
C      WRITE WATER QUALITY SENSITIVITIES.
C
        WRITE(NJ,6035) I,J,(Y(K),K=1,17)
480     CONTINUE
      WRITE(NJ,6112) I
6112  FORMAT(/' SENSITIVITY SUMMARY FOR REACH:',I4)
      WRITE(NJ,6113) (SAVG(K),K=1,17)
6113  FORMAT(/'  AVERAGE   ',17F7.2)
      WRITE(NJ,6114) (SMAX(K),K=1,17),(LOCMX(KI),KI=1,17)
6114  FORMAT(/'  MAXIMUM   ',17F7.2/'   IN ELMT  ',17(I6,1X))
      WRITE(NJ,6115) (SMIN(K),K=1,17),(LOCMN(KI),KI=1,17)
6115  FORMAT(/'  MINIMUM   ',17F7.2/'   IN ELMT  ',17(I6,1X)/)
      LP = LP + 11
500   CONTINUE
      REWIND NJ4
C
C      SENSITIVITY OUTPUT FOR ALGAE DATA.
C
        IF(MODOPT(4).EQ.0) GO TO 750
      IF(KFLAGY.EQ.0) GO TO 750
          LP=100
        COEF = ALPHA3/ALPHA4
        DO 600 I=1,NREACH
      DO 610 K=1,20
      SMAX(K)=0.0
      SMIN(K)=1.0E+10
      SAVG(K)=0.0
      LOCMN(K)=0
      LOCMX(K)=0
610   CONTINUE
        NCELR = NCELRH(I)
      CNCELR = NCELR
        WRITE(NJ,6000)
        LP = LP + 2
      LPMX = 96-NCELR
        IF(LP.LE.LPMX) GO TO 550
      LP=0
        NPAGE = NPAGE + 1
        WRITE(NJ,6005) NPAGE,VERNUM
        IF(ISS.EQ.0) WRITE(NJ,6007) TIME
        IF(ISS.NE.0) WRITE(NJ,6008)
        WRITE(NJ,6039)
        IF(METOUT.EQ.0) WRITE(NJ,6040)
        IF(METOUT.GT.0) WRITE(NJ,6041)
550   CONTINUE
        DO 580 J=1,NCELR
        LP = LP + 1
      IOR = ICLORD(I,J)
C
C      READ BASE CASE INFORMATION.
C
      READ(NJ4,6001) L
      IF(L.NE.IOR) GO TO 700
      READ(NJ4,6002) (Y(K),K=1,36)
      APR(IOR) = COEF*GROWTH(IOR)/RESPRR(IOR)
      APMR(IOR) = (ALPHA3*GROWTH(IOR)-ALPHA4*RESPRR(IOR))*ALGAE(IOR)
C
C      COMPUTE SENSITIVITIES.
C
      Y(1)=ALGAE(IOR)-Y(28)
      Y(1)=Y(1)*ALPHAO(I)
      Y(2)=GROWTH(IOR)-Y(29)
      Y(3)=APR(IOR)-Y(30)
      Y(4)=APMR(IOR)-Y(31)
      Y(5)=PRF(IOR)-Y(32)
      Y(6)=EXTC(IOR)-Y(33)
      IF(METOUT.GT.0) Y(6)=Y(6)*3.2808
      Y(7)=AGFL(IOR)-Y(34)
      Y(8)=AGFN(IOR)-Y(35)
      Y(9)=AGFP(IOR)-Y(36)
C
C      SEARCH FOR MIN AND MAX, COMPUTE AVERAGE IN REACH.
C
      DO 620 K=1,11
      SAVG(K)=SAVG(K)+Y(K)/CNCELR
      IF(ABS(Y(K)).GT.ABS(SMIN(K))) GO TO 622
      SMIN(K)=Y(K)
      LOCMN(K)=J
622   IF(ABS(Y(K)).LE.ABS(SMAX(K))) GO TO 620
      SMAX(K)=Y(K)
      LOCMX(K)=J
620   CONTINUE
C
C      WRITE ALGAE/NUTRIENT SENSITIVITIES.
C
      WRITE(NJ,6045) IOR,I,J,(Y(K),K=1,9)
580   CONTINUE
      WRITE(NJ,6112) I
      WRITE(NJ,6133) (SAVG(K),K=1,9)
6133  FORMAT(/'  AVERAGE ',5X,4F8.2,4X,2F8.2,4X,3F9.2)
      WRITE(NJ,6134) (SMAX(K),K=1,9),(LOCMX(KI),KI=1,9)
6134  FORMAT(/'  MAXIMUM ',5X,4F8.2,4X,2F8.2,4X,3F9.2/,
     * '   IN ELMT',5X,4I8,4X,2I8,4X,3I9)
      WRITE(NJ,6135) (SMIN(K),K=1,9),(LOCMN(KI),KI=1,9)
6135  FORMAT(/'  MINIMUM ',5X,4F8.2,4X,2F8.2,4X,3F9.2/,
     * '   IN ELMT',5X,4I8,4X,2I8,4X,3I9/)
      LP = LP + 11
600     CONTINUE
      GO TO 750
700   CONTINUE
      WRITE(NJ,6060) L
6060  FORMAT(//' ERROR IN READING STORED DATA, ELEMENT:',I4//)
750   CONTINUE
      CLOSE(UNIT=NJ4)
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)FILNAM(7)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING UNCERTAINTY SCRATCH I/O DATA FILE',
     2     /,'   ',A64,
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
CQ2E
CQ2E            FORMAT STATEMENTS
CQ2E
6000    FORMAT(/)
 6005 FORMAT( 1H1 /
     * 10X, 25HSTREAM QUALITY SIMULATION, 70X, 19HOUTPUT PAGE NUMBER ,I5
     *   /  10X, 36HQUAL-2E STREAM QUALITY ROUTING MODEL, 51X, A26)
C     *  'EPA/NCASI VERSION')
 6007 FORMAT( / 10X, 'SYSTEM STATUS AFTER', F8.2, ' HOURS OF DYNAMIC',
     1'OPERATION'  )
 6008 FORMAT(/40X,'***** STEADY STATE SIMULATION - ',
     1 'OUTPUT SENSITIVITIES',
     2 ' (DELTA Y) *****' )
6009    FORMAT( / 55X,'** HYDRAULICS SUMMARY **'//
     1 ' ELE RCH ELE   BEGIN',5X,'END',6X,
     1 14X,'TRVL',35X,' BOTTOM',6X,'X-SECT   DSPRSN   OXYGN     NIT'/,
     2 ' ORD NUM NUM',2(5X,'LOC'),4X,'FLOW',5X,
     3 'VEL',4X,'TIME',4X,'DEPTH',4X,'WIDTH',6X,'VOLUME',
     4 2(8X,'AREA'),5X,'COEF   REAIR   INHIB')
6011    FORMAT(12X,2(4X,'KILO'),1(5X,'CMS'),5X,'MPS',5X,'DAY',
     1 2(8X,'M'),6X,'K-CU-M',6X,'K-SQ-M',
     2  8X,'SQ-M',3X,'SQ-M/S   1/DAY   FACT'/)
6010    FORMAT(12X,2(4X,'MILE'),1(5X,'CFS'),5X,'FPS',5X,'DAY',
     2 2(7X,'FT'),6X,'K-FT-3',6X,'K-FT-2',
     2  8X,'FT-2',3X,'FT-2/S   1/DAY    FACT'/)
6015    FORMAT(3I4,3F8.2,2F8.3,2F9.3,3F12.2,F9.2,2F8.2)
6029    FORMAT( / 53X,'** WATER QUALITY VARIABLES **'//' RCH ELE',
     1 14X,'CM-1   CM-2   CM-3',81X,'ANC'/' NUM NUM',7X,'TEMP',
     1 3(3X,A4),'     DO    BOD   ORGN   NH3N   NO2N   NO3N',
     2'  SUM-N   ORGP  DIS-P  SUM-P   COLI',3X,A4,'   CHLA')
6031    FORMAT(14X,'DEG-C',3(3X,A4),10(3X,'MG/L'),
     1' #/100ML',2X,A4,'   UG/L'/)
6030    FORMAT(14X,'DEG-F',3(3X,A4),10(3X,'MG/L'),
     1' #/100ML',2X,A4,'   UG/L'/)
6035    FORMAT(2I4,4X,14F7.2,E7.2,2F7.2)
6039    FORMAT( / 59X,'** ALGAE DATA **'//
     1 54X,'NH3-N',12X,'ALGAE GROWTH RATE ATTEN FACTORS'/
     2 ' ELE RCH ELE',11X,1(4X,'ALGY'),3X,'A P/R',5X,'NET',
     3 7X,'FRACT   LIGHT'/
     4 ' ORD NUM NUM',7X,'CHLA   GRWTH   ',
     5 'RATIO     P-R',6X,'N-UPTKE  EXTCO',8X,
     6 'LIGHT   NITRGN   PHSPRS')
6040    FORMAT(19X,'UG/L',1(3X,'1/DAY'),6X,
     1 '*   MG/L-D',3X,1(7X,'*'),5X,'1/FT',3X,3(8X,'*')/)
6041    FORMAT(19X,'UG/L',1(3X,'1/DAY'),6X,
     1 '*   MG/L-D',3X,1(7X,'*'),6X,'1/M',3X,3(8X,'*')/)
6045    FORMAT(3I4,3X,4F8.2,4X,2F8.2,4X,3F9.2)
        END
