      SUBROUTINE SETUP(NP,KSIM)
C
C      THIS SUBROUNITE SETS UP THE INPUT CONDITION FOR THE CURRENT UNCERTAINTY
C      SIMULATION.  USING THE LIST OF SCREENED INPUTS (AS DETERMINED IN
C      INSENS OR IFOAMC), EACH IS PERTURBED OR RANDOMIZED AS FOLLOWS:
C          SENS    ONE OR MULTIPLE VARIABLES, LOOP CONTROLLED IN UNCAS,
C          FOEA    ONE VARIABLE AT A TIME, LOOP CONTROLLED IN UNCAS,
C          MCS     ALL RELEVANT INPUTS RANDOMIZED IN EACH SIMULATION.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C
      CHARACTER*1 BLANK
      DIMENSION MDATA(10)
C
      DATA BLANK/' '/
C
C      OPEN UCODE.DAT FILE AND EXTRACT INFORMATION ON INPUT PERTURBED VARIABLE
C      (NAME, TYPE, INDEX NUMBER, MODEL OPTION LINKAGE VECTOR)
C
      NI3 = 3
      IF (IU.EQ.1.AND.UCPATH(1:1).EQ.BLANK) THEN
          OPEN(UNIT=NI3,FILE='UCODE.DAT',STATUS='OLD',ERR=990)
      ELSE
          OPEN(UNIT=NI3,FILE=UCPATH(1:IU)//'UCODE.DAT',
     1         STATUS='OLD',ERR=990)
      ENDIF
C
      GO TO (100,150,200) INTYPE
100   CONTINUE
C
C    SENSITIVITY ANALYSIS SECTION
C
20    CONTINUE
C                                    SENS SEARCH
      IF(KNITRF.LT.10.0) GO TO 27
      READ(NI3,21,END=25) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(J1),J1=1,10)
21    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,14X,10I1)
      GO TO 28
27    READ(NI3,26,END=25) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(J1),J1=1,10)
26    FORMAT(1X,A2,F2.0,2(2X,A4),F4.0,1X,2(2X,2A4),2A4,A2,7A4,2X,10I1)
28    CONTINUE
C                                    SENS MATCH
      IF(UDATAC(1).NE.'IN') GO TO 20
      IF(VCODE(JSENS,NP,1).NE.UDATAC(4)) GO TO 20
      IF(VCODE(JSENS,NP,2).NE.UDATAC(5)) GO TO 20
C                                    SENS EXTRACT
      INDEX = UDATAR(2)
      INDXI(JSENS,NP) = INDEX
      KTYPE(NP) = UDATAR(1)
      IF(MDATA(10).EQ.1) KFLHYD=1
      IF(MDATA(4).EQ.1) KFLAGY=1
      DO 33 J=1,7
      J1 = J + 10
      VARIN(J,NP) = UDATAC(J1)
33    CONTINUE
      MTYPE = KTYPE(NP)
C                                     SWAP CURRENT/BASE VALUE(S)
      CALL SWAP(NP,INDEX,MTYPE,LUP)
      GO TO 400
150   CONTINUE
C
C      FIRST ORDER ERRROR ANALYSIS SECTION
C
120   CONTINUE
C                                    FOEA SEARCH
      IF(KNITRF.LT.10.0) GO TO 127
      READ(NI3,21,END=25) UDATAC(1),UDATAR(1),(UDATAC(J),J=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(J1),J1=1,10)
      GO TO 128
127   CONTINUE
      READ(NI3,26,END=25) UDATAC(1),UDATAR(1),(UDATAC(I),I=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17),(MDATA(J1),J1=1,10)
128   CONTINUE
C                                    FOEA MATCH
      IF(UDATAC(1).NE.'IN') GO TO 120
      IF(VCODE(JSENS,NP,1).NE.UDATAC(4)) GO TO 120
      IF(VCODE(JSENS,NP,2).NE.UDATAC(5)) GO TO 120
C                                    FOEA EXTRACT
      INDEX = UDATAR(2)
      INDXI(JSENS,NP) = INDEX
      KTYPE(NP) = UDATAR(1)
      DO 133 J=1,7
      J1 = J + 10
      VARIN(J,NP) = UDATAC(J1)
133   CONTINUE
      MTYPE = KTYPE(NP)
C                                    SWAP CURRENT/BASE VALUE(S)
      CALL SWAP(NP,INDEX,MTYPE,LUP)
      GO TO 400
200   CONTINUE
C
C      MONTE CARLO SECTION
C
C3P1     CHANGE NJ2 TO NJ4=4 FOR BASE.DAT READS/WRITES.
C3P1
C3P1      NJ4=4
C
C     OPEN DISK FILE BASE.DAT ON THE FIRST MC SIMULATION AND SAVE
C     THE BASE CASE VALUES OF ALL INPUTS BEING RANDOMIZED.
C
      IF(KSIM.GT.1) GO TO 201
      OPEN(UNIT=NJ4,STATUS='UNKNOWN',FILE=FILNAM(7))
C      OPEN(UNIT=NJ2,STATUS='UNKNOWN',FILE='BASE.DAT')
201   CONTINUE
C
C     GENERATE RANDOM NUMBERS FOR EACH INPUT BEING RANDOMIZED
C
      CALL NRGEN
C
C     LOOP THROUGH ALL INPUTS
C
      DO 250 I=1,NSIM
      JSENS=I
C                                   MCS SEARCH
220   READ(NI3,21,END=25) UDATAC(1),UDATAR(1),(UDATAC(J),J=2,3),
     * UDATAR(2),(UDATAC(II),II=4,17)
C                                   MCS MATCH
      IF(UDATAC(1).NE.'IN') GO TO 220
      IF(VCODE(JSENS,NP,1).NE.UDATAC(4)) GO TO 220
      IF(VCODE(JSENS,NP,2).NE.UDATAC(5)) GO TO 220
C                                   MCS EXTRACT
      INDEX = UDATAR(2)
      INDXI(JSENS,NP) = INDEX
      KTYPE(NP) = UDATAR(1)
      MTYPE=KTYPE(NP)
      SVALUE(JSENS,1)=SVALUE(JSENS,2)*RV(JSENS)
C                                   MCS SWAP
      CALL SWAP(NP,INDEX,MTYPE,LUP)
      IF(KSIM.GT.1) GO TO 250
C
C      WRITE/SAVE BASE CASE INPUTS
C
      WRITE(NJ4,251) JSENS,INDEX,MTYPE
251   FORMAT(3I5)
      WRITE(NJ4,252) (VSAVE(IK,1),IK=1,LUP)
252   FORMAT(8E14.6/)
250   CONTINUE
C
C      MCS INPUT RANDOMIZATION CONSTRAINTS.
C
C     IF(WETBLB.GT.DRYBLB) WETBLB=DRYBLB
      IF(KSIM.EQ.1) CLOSE(UNIT=NJ4)
      GO TO 400
C
C      SETUP ERROR TRAP IF THERE IS NO INPUT MATCH IN UCODE
C
25    WRITE(NJ,22) (VCODE(JSENS,NP,L),L=1,2)
22    FORMAT(//' **** ',2A4,' IS NOT A RECOGNIZABLE PARAMETER',
     *' CODE FOR SENSITIVITY INPUT'/)
C      CALL EXIT
C +++++
      CLOSE(UNIT=NJ4)
      CLOSE(UNIT=NI3)
C +++++
      STOP
400   CONTINUE
      REWIND NI3
      CLOSE(UNIT=NI3)
C +++++
      CLOSE(UNIT=NJ4)
      RETURN
C
 990  CALL CLRSCR
      WRITE(CONOUT,9950)
 9950 FORMAT(/////////////////////,
     1       '** ERROR OPENING UNCERTAINTY INPUT DATA FILE',
     2     /,'   UCODE.DAT',
     3     /,'   Contact CEAM technical support (706/546-3549)',/)
      STOP
C
      END
