      SUBROUTINE SOVMAT
C
CCC
CCC             NCASI Commentary, SOVMAT - Section A.
CCC                     A. Subroutine argument.
CC
CC              IRPT1 has been added to the argument of SOVMAT
CC               to pass the flag for printing intermediate
CC               output in the dynamic mode.
CC
C                             SOVMAT SOLVES A SYSTEM OF SIMULTANEOUS
C                             LINEAR EQUATIONS WHOSE COEFFICIENT
C                             MATRIX IS OF TRIDIAGONAL FORM USING
C                             A MODIFIED GAUSSIAN ELIMINATION TYPE OF
C                             ALGORITHM.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
C
      DIMENSION IFLG(MC)
CCC
CCC             NCASI Commentary, SOVMAT - Section B. (QUAL2 Step 1-0)
CCC                     B. Initialize counter.
CCC
      IJUNC=0
CCC
CCC             NCASI Commentary, SOVMAT - Section C. (QUAL2 Step 2-0)
CCC                     C. Set up loop on the number of reaches
CCC                         and elements for Gaussian eleimination.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
      IFL=IFLAG(I,J)
      IFLG(IOR)=IFL
      GO TO (101,102,102,103,102,102,102), IFL
CCC
CCC                     C.5 Elimination for Type 1 element.
CCC                          (QUAL2 Step 2-1)
CCC
  101 W(IOR)=C(IOR)/B(IOR)
      G(IOR)=S(IOR)/B(IOR)
      GO TO 100
CCC
CCC                     C.6 Elimination for Type 2, 3, 5, 6, and
CCC                          7 elements. (QUAL2 Step 2-2)
CCC
  102 DENOM=B(IOR)-A(IOR)*W(IOR-1)
      W(IOR)=C(IOR)/DENOM
      G(IOR)=(S(IOR)-A(IOR)*G(IOR-1))/DENOM
      GO TO 100
CCC
CCC                     C.7 Elimination for Type 4 element.
CCC                          (QUAL2 Step 2-3)
CCC
  103 IJUNC=IJUNC+1
      NS=1
      NN=JUNC(IJUNC,NS)
      S(IOR)=S(IOR)-D(IJUNC)*G(NN)
      DENOM=B(IOR)-A(IOR)*W(IOR-1)-D(IJUNC)*W(NN)
      W(IOR)=C(IOR)/DENOM
      G(IOR)=(S(IOR)-A(IOR)*G(IOR-1))/DENOM
CCC
CCC                     C.8 Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, SOVMAT - Section D. (QUAL2 Step 3-0)
CCC                     D. Set up loop on IOR for back
CCC                         substitution.
CCC
CCC                     D.1 Solution for last element.
CCC
      Z(IOR)=G(IOR)
      IF (Z(IOR).LT.0.0.AND.NT.NE.15) Z(IOR) = 0.0
  109 IOR=IOR-1
      IFL=IFLG(IOR)
      GO TO (106,106,107,106,106,106,106), IFL
CCC
CCC                     D.4 Solution for Type 1, 2, 4, 5, 6,
CCC                          and 7 elements. (QUAL2 Step 3-1)
CCC
CCC   The following statement may be needed to correct underflow.
CCC
  106 IF (Z(IOR+1).LT.1.0E-35) Z(IOR+1)=0.0
CCC
      Z(IOR)=G(IOR)-W(IOR)*Z(IOR+1)
      IF (Z(IOR).LT.0.0.AND.NT.NE.15) Z(IOR)=0.0
      GO TO 108
CCC
CCC                     D.5 Solution for Type 3 element.
CCC                          (QUAL2 Step 3-2)
CCC
  107 NS=1
      DO 98 IJ=1,NJUNC
      IF (IOR.EQ.JUNC(IJ,NS)) IJUNC=IJ
   98 CONTINUE
      NS=2
      NN=JUNC(IJUNC,NS)
      Z(IOR)=G(IOR)-W(IOR)*Z(NN)
      IF (Z(IOR).LT.0.0.AND.NT.NE.15) Z(IOR)=0.0
  108 CONTINUE
CCC
CCC                     D.6 Test for last element to be solved.
CCC
      IF (IOR.NE.1) GO TO 109
CCC
CCC             NCASI Commentary, SOVMAT - Section E. (QUAL2 Step 4-0)
CCC                     E. Test for intermediate output.
CCC
      IF (TPRINT.LT.PTIME) GO TO 99
      IF(IRPT1.EQ.1)CALL WRPT2 (Z)
   99 CONTINUE
CCC
CCC             NCASI Commentary, SOVMAT - Section F.
CCC                     F. Return to MAIN.
CCC
      RETURN
      END
