      SUBROUTINE TCALCS
C
C + + + + + + + + +
C
C      THIS SUBROUTINE PERFORMS TEMPERATURE ROUTING FOR A
C       QUAL2E SIMULATION.
C
C + + + + + + + + +
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
        INCLUDE 'CONST.INC'
C
      DIMENSION TJ1(MC)
C
C + + + + + + + + +
C
CQ2E
CQ2E            TEST IF TIME/ITERATION TO READ LCD
CQ2E
        IF(MODOPT(2).EQ.0.AND.MODOPT(4).EQ.0) GO TO 700
        IF(ISS.GT.0) GO TO 550
C +++++
C        IF(TRLCD.NE.0.0) GO TO 515
        IF(ABS(TRLCD).GT.R0MIN) GO TO 515
C +++++
        READ(NI2,510) SOLHR,CLOUD,DRYBLB,WETBLB,ATMPR,WIND
510     FORMAT(30X,F10.0,5F8.0)
        IF(METRIC.EQ.0) GO TO 511
        SOLHR = SOLHR*3.685
        DRYBLB = DRYBLB*1.8 + 32.0
        WETBLB = WETBLB*1.8 + 32.0
        ATMPR = ATMPR*(29.9/1000.)
        WIND = WIND/0.3048
511     CONTINUE
        WIND = WIND*.6818
        IF(ITEMP.EQ.0) GO TO 515
        SOLL = SOLHR/3.685
        WRITE(NJ,512) TIME,SOLHR,SOLL,CLOUD,DRYBLB,WETBLB,ATMPR,WIND
512     FORMAT(1H1,//'  READING LOCAL CLIMATOLOGICAL DATA:'//
     18X,'TIME STEP =  ',F10.3/
     28X,'SOLHR =  ',F10.3,' BTU/FT2-HR  (',F10.3,' LANGLEYS/HR)'/
     38X,'CLOUD =  ',F10.3/
     48X,'DYRBLB =  ',F10.3,'  DEG-F'/
     58X,'WETBLB =  ',F10.3,'  DEG-F'/
     68X,'ATMPR =  ',F10.3,'  IN-HG'/
     78X,'WIND =  ',F10.3,'  MILES/HR'///)
515     TRLCD = TRLCD + D2LT
        IF(TRLCD.LT.2.9) GO TO 599
        TRLCD = 0.0
        GO TO 599
550     IF(MODOPT(2).EQ.0) GO TO 700
C3.0
C3.0     REMOVE LCD READ FOR STEADY STATE (TO INDATA TYPE5A)
C3.0
599     CONTINUE
CCC
CCC                     G.5 Temperature - Dynamic simulation.
CCC
      IF (MODOPT(2).EQ.0) GO TO 700
      NT=6
      IF (ISS.GT.0.) GO TO 7702
C3.0
      CALL HEATEX
C3.0    
      CALL TEMPS
      CALL SOVMAT
      DO 800 I=1,NCELLS
      T(I)=Z(I)
  800 CONTINUE
      GO TO 700
CCC
CCC                     G.6 Temperature - Steady state simulation.
CCC
 7702 IF (NITER.GT.0) GO TO 700
C3.0
      IF(INTOUT.NE.2) GO TO 7703
C +++++
C7721  WRITE(NJ,7723)
      WRITE(NJ,7723)
C +++++
7723  FORMAT(1H1)
C +++++
C7722  CONTINUE
      CONTINUE
C +++++
        WRITE(NJ,7711)
 7711    FORMAT(1H1,/2X,'STEADY STATE TEMPERATURE SIMULATION;',
     1' CONVERGENCE SUMMARY:'/2X,57('-')//
     124X,'NUMBER OF'/10X,'ITERATION   NONCONVERGENT'/
     224X,'ELEMENTS'/)
 7703 DO 7706 I=1,NCELLS
      TJ1(I)=(T(I)-35.)/5.
 7706 CONTINUE
C3.0
      IF(NITER.EQ.0) CALL HEATER
C3.0
      CALL TEMPSS
      CALL SOVMAT
      MM=0
      DO 7704 I=1,NCELLS
      T(I)=Z(I)
      TJ=(T(I)-35.)/5.
      M=TJ+1
      IF (JT(I).EQ.M.AND.M.GT.0.AND.M.LE.21) GO TO 7704
      IF (JT(I).NE.M.AND.ABS(TJ-TJ1(I)).LE.0.10) GO TO 7704
      MM=MM+1
 7704 CONTINUE
      NITER=NITER+1
C3.0 
      IF(INTOUT.NE.2) GO TO 7707
      WRITE(NJ,7705) NITER,MM
 7705 FORMAT(12X,I4,11X,I4)
7707  CONTINUE
C3.0
      IF (NITER.GT.10) STOP
      IF (MM.GT.0) GO TO 7703
CQ2E
CQ2E            ADD STEADY STATE TEMPERATURE OUTPUT SUMMARY
C3.0
      IF(INTOUT.NE.2) GO TO 700
      A1=0.0
      A2=0.0
      XCELLS = NCELLS
      DO 10 I=1,NREACH
      CNCELR = NCELRH(I)
      WT = CNCELR/XCELLS
      A1 = A1+ TSONET(I)*WT
      A2 = A2 + TDLH(I)*WT
10    CONTINUE
      BASNET = A1
      BADLH = A2
      DO 12 L=1,24
      BATSUN(L) = 0.0
      A3 = 0.0
      DO 13 I=1,NREACH
      CNCELR = NCELRH(I)
      WT = CNCELR/XCELLS
13    A3 = A3 + TSUN(I,L)*WT
      BATSUN(L) = A3
12    CONTINUE
        TSLR = A1/3.685
        WRITE(NJ,7712) A1,TSLR,A2
7712    FORMAT(//2X,'SUMMARY OF VALUES FOR STEADY STATE TEMPERATURE',
     1' CALCULATIONS (SUBROUTINE HEATER):'/2X,80('-'),//,
     18X,'DAILY NET SOLAR RADIATION = ',F11.3,
     2' BTU/FT-2',3X,'(',F9.3,' LANGLEYS)'/8X,'NUMBER OF',
     3' DAYLIGHT HOURS = ',F5.1///8X,'HOURLY VALUES OF SOLAR',
     4' RADIATION (BTU/FT-2)'/)
      IF(IFGRVT.EQ.0) GO TO 730
      WRITE(NJ,21) (J,J=1,24)
21    FORMAT(//' RCH   DLH',4I4,16I5,4I4,3X,'TOTAL'/)
      DO 22 I=1,NREACH
22    WRITE(NJ,23) I,TDLH(I),(TSUN(I,KT),KT=1,24),TSONET(I)
23    FORMAT(I4,F6.1,4F4.0,16F5.0,4F4.0,F8.1)
      WRITE(NJ,24) BADLH,(BATSUN(L),L=1,24),BASNET
24    FORMAT(//' AVG',F6.1,4F4.0,16F5.0,4F4.0,F8.1//)
      GO TO 700
730   DO 7713 KH=1,8
      KH1 = KH+8
      KH2 = KH1+8
7713  WRITE(NJ,7714) KH,BATSUN(KH),KH1,BATSUN(KH1),KH2,BATSUN(KH2)
7714  FORMAT(10X,3(I5,F9.2,5X))
C3.0
C
C + + + + + + + +
C
700   CONTINUE
C
C + + + + + + + +
C
      RETURN
      END
