      SUBROUTINE TEMPS
C
CC
        INCLUDE 'MAIN.VAR'
C       INCLUDE 'ARRAYS.VAR'
C       INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
CCC
CCC             NCASI Commentary, TEMPS - Section A.
CCC                     A. Initialize counters and constants.
CCC
      NHW=0
      NWS=0
      IJUNC=0
      RHOCP=62.4
CCC
CCC             NCASI Commentary, TEMPS - Section B.
CCC                     B. Perform heat flux calculations.
CCC
C3P0    Move call to HEATEX to TCALCS.
C     CALL HEATEX
CCC
CCC             NCASI Commentary, TEMPS - Section C.
CCC                     C. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + +  + + + + +
      TPIJI = QI(I)/CNCELR*TI(I)
      TPIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      TPIJI = 0.0
      TPIJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
CCC
CCC             NCASI Commentary, TEMPS - Section D.
CCC                     D. Initialize diagonal and known terms.
CCC
      B(IOR)=X(IOR)-TPIJO*DTOVCL(IOR)
      IFL=IFLAG(I,J)
      GO TO (101,102,102,104,109,103,105), IFL
CCC
CCC             NCASI Commentary, TEMPS - Section E.
CCC                     E. Heat balance for Type 1 element.
CCC
  101 NHW=NHW+1
      ADEPTH=0.5*(DEPHW(NHW)+DEPTH(IOR))
      REACT=HSNET(IOR)/(RHOCP*ADEPTH)
      S(IOR)=T(IOR)+REACT+TPIJI*DTOVCL(IOR)-A(IOR)*HWTEMP(NHW)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPS - Section F.
CCC                     F. Heat balance for Type 2, 3, and 5
CCC                         elements.
CCC
  102 ADEPTH=0.5*(DEPTH(IOR-1)+DEPTH(IOR))
      REACT=HSNET(IOR)/(RHOCP*ADEPTH)
      S(IOR)=T(IOR)+REACT+TPIJI*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPS - Section G.
CCC                     G. Heat balance for Type 6 element.
CCC
  103 NWS=NWS+1
      ADEPTH=0.5*(DEPTH(IOR-1)+DEPTH(IOR))
      REACT=HSNET(IOR)/(RHOCP*ADEPTH)
      S(IOR)=T(IOR)+REACT+(TPIJI+WSFLOW(NWS)*WSTEMP(NWS))*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPS - Section H.
CCC                     H. Heat balance for Type 4 element.
CCC
  104 IJUNC=IJUNC+1
      NS=1
      NN=JUNC(IJUNC,NS)
      ADEPTH=0.25*(DEPTH(IOR-1)+DEPTH(NN)+2.0*DEPTH(IOR))
      REACT=HSNET(IOR)/(RHOCP*ADEPTH)
      S(IOR)=T(IOR)+REACT+TPIJI*DTOVCL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPS - Section I.
CCC                     I. Heat balance for Type 7 element.
CCC
  105 NWS=NWS+1
      ADEPTH=0.5*(DEPTH(IOR-1)+DEPTH(IOR))
      REACT=HSNET(IOR)/(RHOCP*ADEPTH)
      S(IOR)=T(IOR)+REACT+(TPIJI)*DTOVCL(IOR)
      B(IOR)=B(IOR)-WSFLOW(NWS)*DTOVCL(IOR)
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 102
      T(IOR) = T(IOR) - C(IOR)*TEMPLB
      GO TO 102
CCC
CCC             NCASI Commentary, TEMPS - Section J.
CCC                     J. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, TEMPS - Section K.
CCC                     K. Return to MAIN.
CCC
      RETURN
      END
