      SUBROUTINE TEMPSS
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
C       INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
      REAL MU,LAMBDA
CCC
CCC             NCASI Commentary, TEMPSS - Section B.
CCC                     B. Test iteration counter, NITER.
CCC
C3P0     Move the call to HEATER to TCALCS.
C     IF (NITER.EQ.0) CALL HEATER
CCC
CCC             NCASI Commentary, TEMPSS - Section C.
CCC                     C. Initialize counters and constants.
CCC
      NHW=0
      NWS=0
      IJUNC=0
      RHOCP=62.4
CCC
CCC             NCASI Commentary, TEMPSS - Section D.
CCC                     D. Set up loop on number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
CCC
CCC                     D.1 Calculate the terms needed for heat
CCC                          balance based on the average local
CCC                          climatological data and the average
CCC                          net solar radiation.
CCC
      VPWB=0.1001*EXP(0.03*RCHTWB(I))-0.0837
      VPAIR=VPWB
     *     -0.000367*RCHATM(I)*(RCHTDB(I)-RCHTWB(I))*
     *       (1.0+(RCHTWB(I)-32.0)/1571.0)
      CLC=1.0+0.17*RCHCLD(I)**2
      HA=4.85E-15*(RCHTDB(I)+460.0)**6*CLC
      NCELR=NCELRH(I)
      CNCELR=NCELR
CQ2E + + + + + + +
      TPIJI = QI(I)/CNCELR*TI(I)
      TPIJO = 0.0
      IF(QI(I).GE.0.0) GO TO 50
      TPIJI = 0.0
      TPIJO = QI(I)/CNCELR
50    CONTINUE
CQ2E + + + + + + +
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
      IFL=IFLAG(I,J)
CCC
CCC             NCASI Commentary, TEMPSS - Section E.
CCC                     E. Initialize and/or compute known terms.
CCC
      S(IOR)=0.
      TJ=(T(IOR)-35.)/5.
      M=TJ+1
      JT(IOR)=M
      HLAT=1084.-0.5*T(IOR)
      B1=RHOCP*HLAT*(AE+BE*RCHWND(I))
CC
CC              Change constant in statements for B2 and B3 from
CC                0.3342 to 0.01 because the units of P and T
CC                are (in HG) and (deg-F).
CC
      B2=BETA1(M)+0.01
      LAMBDA=BETA2(M)+B1*B2
      B3=ALFA1(M)-VPAIR-0.01*RCHTDB(I)
CC
CC              Redefine HS because the units of RCHSOL(I) are
CC               already BTU/ft2-hr as calculated in HEATER.
CC
      HS =  RCHSOL(I)
CC
      MU=HS+HA-ALFA2(M)-B1*B3
      GO TO (101,102,102,104,109,103,105), IFL
CCC
CCC             NCASI Commentary, TEMPSS - Section F.
CCC                     F. Heat balance for Type 1 element.
CCC
  101 NHW=NHW+1
      ADEPTH=0.5*(DEPHW(NHW)+DEPTH(IOR))
      REACT=MU*D2LT/(RHOCP*ADEPTH)
      ST=TPIJI*DTOVCL(IOR)-A(IOR)*HWTEMP(NHW)
      S(IOR)=S(IOR)+REACT+ST
      B(IOR)=X(IOR)-TPIJO*DTOVCL(IOR)+LAMBDA*D2LT/(RHOCP*ADEPTH)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPSS - Section G.
CCC                     G. Heat balance for Type 2, 3, and 5
CCC                         elements.
CCC
  102 ADEPTH=0.5*(DEPTH(IOR-1)+DEPTH(IOR))
      REACT=MU*D2LT/(RHOCP*ADEPTH)
      S(IOR)=S(IOR)+REACT+TPIJI*DTOVCL(IOR)
      B(IOR)=X(IOR)-TPIJO*DTOVCL(IOR)+LAMBDA*D2LT/(RHOCP*ADEPTH)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPSS - Section H.
CCC                     H. Heat balance for Type 6 element.
CCC
  103 NWS=NWS+1
      ADEPTH=0.5*(DEPTH(IOR-1)+DEPTH(IOR))
      REACT=MU*D2LT/(RHOCP*ADEPTH)
      ST=(TPIJI+WSFLOW(NWS)*WSTEMP(NWS))*DTOVCL(IOR)
      S(IOR)=S(IOR)+REACT+ST
      B(IOR)=X(IOR)-TPIJO*DTOVCL(IOR)+LAMBDA*D2LT/(RHOCP*ADEPTH)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPSS - Section I.
CCC                     I. Heat balance for Type 4 element.
CCC
  104 IJUNC=IJUNC+1
      NS=1
      NN=JUNC(IJUNC,NS)
      ADEPTH=0.25*(DEPTH(IOR-1)+DEPTH(NN)+2.*DEPTH(IOR))
      REACT=MU*D2LT/(RHOCP*ADEPTH)
      S(IOR)=S(IOR)+REACT+TPIJI*DTOVCL(IOR)
      B(IOR)=X(IOR)-TPIJO*DTOVCL(IOR)+LAMBDA*D2LT/(RHOCP*ADEPTH)
      GO TO 100
CCC
CCC             NCASI Commentary, TEMPSS - Section J.
CCC                     J. Heat balance for Type 7 element.
CCC
  105 NWS=NWS+1
      ADEPTH=0.5*(DEPTH(IOR-1)+DEPTH(IOR))
      REACT=MU*D2LT/(RHOCP*ADEPTH)
      S(IOR)=S(IOR)+REACT+TPIJI*DTOVCL(IOR)
      BT=(TPIJO+WSFLOW(NWS))*DTOVCL(IOR)
      B(IOR)=X(IOR)+LAMBDA*D2LT/(RHOCP*ADEPTH)-BT
      GO TO 100
109   IF(LBFLG.EQ.0) GO TO 102
      S(IOR) = S(IOR)-C(IOR)*TEMPLB
      GO TO 102
CCC
CCC             NCASI Commentary, TEMPSS - Section K.
CCC                     K. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, TEMPSS - Section L.
CCC                     L. Return to MAIN.
CCC
      RETURN
      END
