      SUBROUTINE TRIMAT
C
C                             TRIMAT COMPUTES THE COEFFICIENT MATRIX
C                             FOR THE IMPLICIT-FINITE-DIFFERENCE FORM
C                             OF THE ONE-DIMENSIONAL (ADVECTION +
C                             DISPERSION) TRANSPORT EQUATION.
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
CC
CCC
CCC             NCASI Commentary, TRIMAT - Section A. (QUAL2 Step 1-0)
CCC                     A. Initialize counters.
CCC
      NHW=0
      NWS=0
      IJUNC=0
CCC
CCC             NCASI Commentary, TRIMAT - Section B. (QUAL2 Step 2-0)
CCC                     B. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      DO 100 J=1,NCELR
      IOR=ICLORD(I,J)
      X(IOR) = 1.0
      IF (ISS.GT.0) X(IOR) = 0.0
      IFL=IFLAG(I,J)
      GO TO (101,102,102,103,104,102,102), IFL
CCC
CCC             NCASI Commentary, TRIMAT - Section C. (QUAL2 Step 2-1)
CCC                     C. Coefficients for Type 1 element.
CCC
  101 NHW=NHW+1
      A(IOR)=-DTODX2*DLHW(NHW)-HWFLOW(NHW)*DTOVCL(IOR)
      X(IOR)=X(IOR)+DTODX2*(DLHW(NHW)+DL(IOR))+FLOW(IOR)*DTOVCL(IOR)
      C(IOR)=-DTODX2*DL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, TRIMAT - Section D. (QUAL2 Step 2-2)
CCC                     D. Coefficients for Type 2, 3, 6, and 7
CCC                         elements.
CCC
  102 A(IOR)=-DTODX2*DL(IOR-1)-FLOW(IOR-1)*DTOVCL(IOR)
      X(IOR)=X(IOR)+DTODX2*(DL(IOR-1)+DL(IOR))+FLOW(IOR)*DTOVCL(IOR)
      C(IOR)=-DTODX2*DL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, TRIMAT - Section E. (QUAL2 Step 2-3)
CCC                     E. Coefficients for Type 4 element.
CCC
  103 IJUNC=IJUNC+1
      NS=1
      NN=JUNC(IJUNC,NS)
      D(IJUNC)=-DTODX2*DL(NN)-FLOW(NN)*DTOVCL(IOR)
      A(IOR)=-DTODX2*DL(IOR-1)-FLOW(IOR-1)*DTOVCL(IOR)
CC
CC              Change weighting factor on DL(IOR) from 2.0 to 1.0
CC
      X(IOR)=X(IOR)+DTODX2*(DL(IOR-1)+DL(NN)+1.0*DL(IOR))+FLOW(IOR)*
     *       DTOVCL(IOR)
      C(IOR)=-DTODX2*DL(IOR)
      GO TO 100
CCC
CCC             NCASI Commentary, TRIMAT - Section F. (QUAL2 Step 2-4)
CCC                     F. Coefficients for Type 5 element.
CCC
  104 A(IOR)=-DTODX2*(DL(IOR-1)+DL(IOR))-FLOW(IOR-1)*DTOVCL(IOR)
      X(IOR)=X(IOR)+DTODX2*(DL(IOR-1)+DL(IOR))+FLOW(IOR)*DTOVCL(IOR)
      C(IOR)=0.
      IF(LBFLG.EQ.0) GO TO 100
      A(IOR) =-(DTOVCL(IOR)*FLOW(IOR-1)+DTODX2*DL(IOR-1))
      C(IOR)=-DTODX2*DL(IOR)
CCC
CCC             NCASI Commentary, TRIMAT - Section G.
CCC                     G. Loop through all elements and reaches.
CCC
  100 CONTINUE
CCC
CCC             NCASI Commentary, TRIMAT - Section H.
CCC                     H. Return to MAIN.
CCC
      RETURN
      END
