      SUBROUTINE UECHO
C
C      THIS SUBROUTINE PRINTS AS INTERMEDIATE OUTPUT, THE INPUT CONDITIONS
C      OF EACH UNCERTAINTY SIMULATION INCLUDING THE NAME OF THE  INPUT
C      VARIABLE, AND ITS BASE AND PERTURBED VALUE.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C
      DIMENSION DUM(ML)
C +++++
      CHARACTER*4 VNAME,V1,V2,V3,V4,V5
C +++++
      DATA V1,V2,V3,V4,V5/'    ','RCH=','HDW=','PTL=','NDM='/
C
C       WRITE HEADING FOR INTERMEDIATE SIMULATION OUTPUT
C
      WRITE(NJ,101) JSENS
101   FORMAT(1H1//'  1. UNCERTAINTY SIMULATION NUMBER:',I5/)
      WRITE(NJ,103) (TITLE(1,J),J=6,20),(TITLE(2,J1),J1=6,20)
103   FORMAT(/5X,'A. SIMULATION TITLE'//,2(10X,15A4/))
      WRITE(NJ,105)
105   FORMAT(/5X,'B. SENSITIZED INPUT VARIABLES'//
     * 53X,'BASE',8X,'NEW',5X,'PER CENT'/
     * 18X,'VARIABLE',27X,'VALUE',6X,'VALUE',5X,'CHANGE'/)
C
C     TEST FOR GENERIC TYPE OF INPUT VARIABLE AND RECOVER VALUES
C     BEING USED IN CURRENT AND BASE SIMULATION
C
      NV = NVAR(JSENS)
      DO 400 L=1,NV
      INDEX = INDXI(JSENS,L)
CBR
      ITEM=JTEM(JSENS,L)
CBR
C
      GO TO (310,320,330,340,350,360,370) KTYPE(L)
310   NUP = 1
      VNAME = V1
      IF(INDEX.GT.47) GO TO 315
      DUM(1) = GL(INDEX)
      GO TO 390
315   CONTINUE
      JNDEX=INDEX-47
      DUM(1)=IGL(JNDEX)
      GO TO 390
320   NUP = NREACH
      VNAME = V2
      DO 322 IK=1,NUP
322   DUM(IK) = HY(IK,INDEX)
      GO TO 390
330   NUP = NREACH
      VNAME = V2
      IF(INDEX.GE.23) GO TO 335
      DO 332 IK=1,NUP
332   DUM(IK) = RX(IK,INDEX)
      GO TO 390
335   CONTINUE
      DO 337 IK=1,NREACH
337   DUM(IK) = IRX(IK)
      GO TO 390
340   NUP = NREACH
      VNAME = V2
      DO 342 IK=1,NUP
342   DUM(IK) = FI(IK,INDEX)
      GO TO 390
350   NUP = NHWTRS
      VNAME = V3
      DO 352 IK=1,NUP
352   DUM(IK) = FH(IK,INDEX)
      GO TO 390
360   NUP = NWASTE
      VNAME = V4
      DO 362 IK=1,NUP
362   DUM(IK) = FP(IK,INDEX)
      GO TO 390
370   NUP = NDAM
      VNAME = V5
      DO 372 IK=1,NUP
372   DUM(IK) = FD(IK,INDEX)
390   CONTINUE
C
C      PRINT INPUT CONDITIONS FOR UNCAS SIMULATION
C
CBR
      IF(ITEM.EQ.0) THEN
        L1=1
        L2=NUP
      ELSE
        L1=ITEM
        L2=ITEM
      ENDIF
      DO 396 IK=L1,L2
CBR      DO 396 IK=1,NUP
      PC = 0.0
      IF(KTYPE(L).NE.1) GO TO 391
      IF(INDEX.LT.29) GO TO 391
      IF(INDEX.GT.47) GO TO 391
      A1=DUM(IK)-1.0
      A2=VSAVE(IK,L)-1.0
C +++++
C      IF(A2.NE.0.0) PC=((A1-A2)/A2)*100.
      IF(A2.GT.R0MIN) PC=((A1-A2)/A2)*100.
C +++++
      GO TO 392
391   CONTINUE
C +++++
C      IF(VSAVE(IK,L).NE.0.0) PC = (DUM(IK)-VSAVE(IK,L))/
C     * VSAVE(IK,L)*100.
      IF(VSAVE(IK,L).GT.R0MIN) PC = (DUM(IK)-VSAVE(IK,L))/
     * VSAVE(IK,L)*100.
C +++++
392   CONTINUE
      IF(KTYPE(L).NE.1) GO TO 395
      IF(INDEX.EQ.24) GO TO 108
      WRITE(NJ,107) (VARIN(J,L),J=1,7),VSAVE(IK,L),DUM(IK),PC
107   FORMAT(10X,7A4,11X,2F10.5,4X,F6.1)
      GO TO 396
108   WRITE(NJ,109) (VARIN(I,J),J=1,7),VSAVE(IK,L),DUM(IK),PC
109   FORMAT(10X,7A4,11X,2F10.3,4X,F6.1)
      GO TO 396
395   CONTINUE
      WRITE(NJ,397) (VARIN(J,L),J=1,7),VNAME,IK,VSAVE(IK,L),
     *  DUM(IK),PC
397   FORMAT(10X,7A4,2X,A4,I3,2X,2F10.4,4X,F6.1)
396   CONTINUE
      WRITE(NJ,393)
393   FORMAT(/)
400   CONTINUE
      RETURN
      END
