      SUBROUTINE UNCAS
C
C      PROGRAM FOR UNCERTAINTY ANALYSIS WITH QUAL2E.  THIS SUBROUTINE
C      MANAGES THE EXECUTION OF THE UNCERTAINTY ANALYSIS OPTION,
C      COMPUTATIONS, AND OUTPUT FOR QUAL2E-UNCAS.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C
C      READ UNCERTAINTY INFORMATION
C
C +++++
C      INTEGER*2 CONOUT,MSGFIL
C      DATA CONOUT,MSGFIL / 7,9 /
C +++++
C
      CALL CLRSCR
      IF(DISPYN.EQ.'N') CALL GETMSG(44,MSGFIL)
      IF(DISPYN.EQ.'Y') CALL GETMSG(35,MSGFIL)
C      WRITE(CONOUT,32)
C32    FORMAT(/,4X,'Reading uncertainty information.')
      MODOPT(10)=1
C3P1
C3P1    OPEN STORE.DAT FILE FOR WRITING SELECTED OUTPUT
C3P1
C +++++
C      NJ2 = 2
      NJ2 = 14
C +++++
C      OPEN(UNIT=NJ2,STATUS='UNKNOWN',FILE='STORE.DAT')
      OPEN(UNIT=NJ2,FILE=FILNAM(8),STATUS='UNKNOWN')
C3P1
      CALL UNDATA
C
C      BRANCH TO THE APPROPRIATE UNCAS OPTION
C
      IF(INTYPE.EQ.0) STOP
C
      GO TO (100,300,500,700) INTYPE
C
C      THIS BRANCH IS FOR SENSITIVITY ANALYSIS
C
100   CONTINUE
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(36,MSGFIL)
C      WRITE(CONOUT,131)
C131   FORMAT(/,4X,'Beginning sensitivity analysis.')
C
C      SET UP INPUT CONDITIONS
C
      CALL INSENS
C
      DO 190 I=1,NSIM
      KFLHYD=0
      KFLAGY=0
      JSENS = I
      NV = NVAR(I)
C 
C      LOOP THROUGH ALL INPUTS FOR CURRENT SIMULATION
C
      DO 180 J=1,NV
      NP = J
      KSIM=1
      CALL SETUP(NP,KSIM)
180   CONTINUE
C
C      PERFORM SENSITIVITY SIMULATION
C
      IF(INTOUT.NE.1) CALL UECHO
      CALL Q2EZ
      CALL DATSAV
      GO TO (170,150,160) INTOUT
C
C                   COMPLETE QUAL2E OUTPUT
C
150   CONTINUE
      CALL WRPT3A(NPAGE)
      CALL WRPT3B(NPAGE)
      GO TO 170
C
C                   LIMITED UNCAS OUTPUT (FDES ONLY)
C
160   CONTINUE
      CALL URPT3
C
C       RESTORE INPUTS TO BASE VALUE
C 
170   CALL RSTOR
C
C      WRITE SENSITIVITY FINAL OUTPUT
C
      CALL SENS
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,175) I,NSIM
175   FORMAT(///////////,
     1      18X,'Sensitivity simulation',I4,' of',I4,' complete.')
190   CONTINUE
C3P1
      CLOSE(UNIT=NJ2)
C3P1
C
      IF(INCON.EQ.1) GO TO 700
C
C      PERFORM ANALYSIS OF FACTORIALLY DESIGNED SENSITIVITY
C          SIMULATIONS
C
      CALL FDES
      GO TO 700
C
C     THIS BRANCH IS FOR FIRST ORDER ERROR ANALYSIS
C
300   CONTINUE
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(37,MSGFIL)
C      WRITE(CONOUT,331)
C331   FORMAT(/,4X,'Beginning first order error analysis.')
C
C      SET UP INPUT CONDITIONS FOR FOEA.
C
      CALL IFOAMC
      DO 390 I=1,NSIM
      JSENS = I
      NV = NVAR(I)
      DO 380 J=1,NV
      NP = J
      KSIM=1
      CALL SETUP(NP,KSIM)
380   CONTINUE
C
C      PERFORM FOEA SIMULATIONS
C
      IF(INTOUT.NE.1)CALL UECHO
      CALL Q2EZ
      CALL DATSAV
C                            WRITE APPROPRIATE INTERMEDIATE OUTPUT
      GO TO (370,350,360) INTOUT
C                            COMPLETE QUAL2E OUTPUT
350   CONTINUE
      CALL WRPT3A(NPAGE)
      CALL WRPT3B(NPAGE)
      GO TO 370
C                            LIMITED UNCAS OUTPUT
360   CONTINUE
      CALL URPT3
C                            RESTORE INPUTS TO BASE VALUE
370   CALL RSTOR
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,375) I,NSIM
375   FORMAT(///////////,
     1       22X,'FOEA simulation',I4,' of',I4,' complete.')
390   CONTINUE
C3P1
      CLOSE(UNIT=NJ2)
C3P1
C                            PERFORM FOEA ON UNCAS OUTPUT
      CALL FOEA
      GO TO 700
C
C      THIS BRANCH IS FOR MONTE CARLO
C
500   CONTINUE
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') CALL GETMSG(38,MSGFIL)
C      WRITE(CONOUT,531)
C531   FORMAT(/,4X,'Beginning MONTE CARLO simulations.')
C                            INITIALIZE RANDOM NUMBER GENERATOR
      ISEED=43685
      IX=ISEED
      DO 501 I=1,1000
501   DUMMY=RAND(IX)
C                            SET UP INPUT CONDITIONS FOR MCS SIMULATION
      CALL IFOAMC
      DO 590 I=1,NMCS
      NP=1
      KSIM=I
      CALL SETUP(NP,KSIM)
      JSENS=I
C                           PERFORM MCS SIMULATION
      CALL Q2EZ
      CALL DATSAV
C                           WRITE APPROPRIATE INTERMEDIATE OUTPUT
      GO TO (570,550,560) INTOUT
550   CONTINUE
      CALL WRPT3A(NPAGE)
      CALL WRPT3B(NPAGE)
      GO TO 570
560   CONTINUE
C                           RESTORE INPUTS TO BASE VALUES
570   CALL RSTOR
      IF(DISPYN.EQ.'Y') CALL CLRSCR
      IF(DISPYN.EQ.'Y') WRITE(CONOUT,575) I,NMCS
575   FORMAT(///////////,
     1       22X,'MC simulations',I6,' of',I6,' complete.')
590   CONTINUE
C3P1
      CLOSE(UNIT=NJ2)
C3P1
C                           PERFORM MCS ANALYSIS ON UNCAS OUTPUT
      CALL MCSIM
C                           RETURN TO MAIN PROGRAM (Q2U3P0)
700   CONTINUE
      RETURN
      END
