      SUBROUTINE UNDATA
C
C      THIS SUBROUTINE READS UNCERTAINTY INFORMATION AND SETS
C      APPROPRIATE FLAGS FOR THE TYPE OF UNCERTAINTY ANALYSIS
C      TO BE PERFORMED.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C
      CHARACTER*4 UNCAS3(3),UNCAS4(4),UNCIS4(7),UNCAS5(3),UNCAS6(3)
      CHARACTER*4 UNCAS,UNDAT,UNDAT3,UNDAT4,UNDAT5,UNDAT6(3)
      DIMENSION UNCAS7(10)
C
      DATA UNCAS/'UNCA'/
      DATA UNCAS3/'SENS','FIRS','MONT'/
      DATA UNCAS4/'SING','2-LE','GENE','ALL '/
      DATA UNCIS4/'GLBL','HYDR','RXNC','FFIF','FFHW','FFPL','FFDM'/
      DATA UNCAS5/'NONE','COMP','LIMI'/
      DATA UNCAS6/'HYDR','QUAL','INTE'/
C
C      READ/INTERPRET UNCERTAINTY CODES (UNCAS DATA TYPES 1, 2, AND 3)
C
      READ(NI,20) UNDAT,L
20    FORMAT(A4,1X,I1)
      IF(L.NE.1.OR.UNDAT.NE.UNCAS) GO TO 900
      READ(NI,21) UNDAT,L,(UNTITL(I),I=1,13)
21    FORMAT(A4,1X,I1,24X,12A4,A2)
      IF(L.NE.2.OR.UNDAT.NE.UNCAS) GO TO 904
      READ(NI,22) UNDAT,L,UNDAT3,UTEMP
22    FORMAT(A4,1X,I1,24X,A4,24X,F6.0)
      IF(L.NE.3.OR.UNDAT.NE.UNCAS) GO TO 906
      INTYPE = 0
      DO 15 J=1,3
15    IF(UNDAT3.EQ.UNCAS3(J)) INTYPE = J
      IF(INTYPE.EQ.2) PDX = UTEMP/100.
C +++++
C      IF(INTYPE.EQ.2.AND.PDX.EQ.0.0) PDX = 0.05
CCC ----- Percent pertubations tested
CCC ----- Revised 05/07/96 - DWD - DynTel for US EPA.
CCC      IF(INTYPE.EQ.2.AND.PDX.LT.R0MIN) PDX = 0.05
      IF(INTYPE.EQ.2.AND.ABS(PDX).LT.R0MIN) PDX = 0.05
CCC ----- End of 05/07/96 revision.
C
      IF(INTYPE.EQ.3) NMCS = IFIX(UTEMP+0.001)
CCC ----- Number of Monte Carlo simulations tested
CCC ----- Revised 09/03/87 - DWD - CSC for US EPA.
      IF(NMCS.GT.MSIM) THEN
         NMCS=MSIM
         CALL CLRSCR
         CALL GETMSG(45,MSGFIL)
      END IF
CCC ----- End of 09/03/87 revision.
C +++++
CBR
      IF((INTYPE.EQ.3).AND.(NMCS.GT.MSIM)) THEN
        WRITE(CONOUT,26) NMCS,MSIM,MSIM
        NMCS = MSIM
26      FORMAT(//' THE NUMBER OF MONTE CARLO SIMULATIONS SPECIFIED (',
     *         I5,')',/' EXCEEDS THE DIMENSIONS OF THE ARRAYS (',
     *         I5,').',/' THE NUMBER OF SIMULATIONS',
     *         ' HAS BEEN SET EQUAL TO ',I5,'.')
      ENDIF
CBR
      IF(INTYPE.EQ.0) GO TO 910
      IF(INTYPE.EQ.3.AND.NMCS.EQ.0) GO TO 912
C
C      DETERMINE UNCERTAINTY SUBTYPE (UNCAS DATA TYPE 4)
C
      GO TO (100,200,200) INTYPE
C
C      THIS BRANCH IS FOR SENSITIVITY ANALYSIS
C
100   CONTINUE
C
C      READ SENSITIVITY INPUT CONDITION
C
      READ(NI,23) UNDAT,L,UNDAT4,NFVARS
23    FORMAT(A4,1X,I1,24X,A4,27X,I2)
      IF(L.NE.4.OR.UNDAT.NE.UNCAS) GO TO 920
      INCON = 0
      DO 105 J=1,2
105   IF(UNDAT4.EQ.UNCAS4(J)) INCON=J
      IF(INCON.EQ.0) GO TO 922
      IF(NFVARS.EQ.0.AND.INCON.EQ.2) GO TO 924
      GO TO 400
C
C      THIS BRANCH IS FOR FIRST ORDER ERROR ANALYSIS/MONTE CARLO
C
200   CONTINUE
C
C      READ FOEA/MCS INPUT CONDITION
C
      READ(NI,24) UNDAT,L,UNDAT4,(GENINP(I),I=1,7)
24    FORMAT(A4,1X,I1,24X,A4,11X,7(1X,A4))
      IF(L.NE.4.OR.UNDAT.NE.UNCAS) GO TO 920
      INCON = 0
      DO 205 J=1,2
      JP2 = J+2
205   IF(UNDAT4.EQ.UNCAS4(JP2)) INCON=J
      IF(INCON.EQ.2) GO TO 400
      DO 210 J=1,7
      KFLIN(J)=0
      DO 210 K=1,7
      IF(GENINP(K).EQ.UNCIS4(J)) KFLIN(J)=1
210   CONTINUE
      DO 215 J=1,7
      IF(KFLIN(J).EQ.1) GO TO 217
215   CONTINUE
      GO TO 926
217   CONTINUE
      IF(INCON.EQ.0) GO TO 922
      IF(GENINP(1).EQ.'    '.AND.INCON.EQ.1) GO TO 926
C
C     READ INTEMERDIATE OUTPUT CONDITION (UNCAS DATA TYPE 5)
C
400   CONTINUE
      READ(NI,25) UNDAT,L,UNDAT5
25    FORMAT(A4,1X,I1,24X,A4)
      IF(L.NE.5.OR.UNDAT.NE.UNCAS) GO TO 930
      INTOUT = 0
      DO 405 J=1,3
405   IF(UNDAT5.EQ.UNCAS5(J)) INTOUT=J
      IF(INTOUT.EQ.0) GO TO 940
C
C     READ OUTPUT VARIABLES (GENERIC TYPES) (UNCAS DATA TYPE 6)
C
      READ(NI,30) UNDAT,L,(UNDAT6(I),I=1,3)
30    FORMAT(A4,1X,I1,24X,3(A4,11X))
      IF(L.NE.6.OR.UNDAT.NE.UNCAS) GO TO 950
      IERR=0
      DO 371 J=1,3
      KFLOUT(J) = 0
      DO 371 K=1,3
      IF(UNDAT6(K).EQ.UNCAS6(J)) KFLOUT(J)=1
371   CONTINUE
      DO 372 J=1,3
      IF(KFLOUT(J).EQ.1) GO TO 373
372   CONTINUE
      GO TO 952
373   CONTINUE
C
C     READ OUTPUT LOCATIONS (UNCAS DATA TYPE 7)
C
      READ(NI,31) UNDAT,L,(UNCAS7(I),I=1,10)
31    FORMAT(A4,1X,I1,24X,5(2X,2F3.0))
      IF(L.NE.7.OR.UNDAT.NE.UNCAS) GO TO 960
      K=1
      I=1
151   CONTINUE
      IR = UNCAS7(K) + 0.001
      IE = UNCAS7(K+1) + 0.001
      JR(I) = IR
      JE(I) = IE
      IF(IE.EQ.0.OR.IR.EQ.0) GO TO 120
      IF(IR.GT.NREACH.OR.IE.GT.NCELRH(IR)) GO TO 120
      IZ = ICLORD(IR,IE)
      LOC(I) = IZ
      I=I+1
      IF(I.GT.MLOC) GO TO 120
      K=K+2
      GO TO 151
120   NLOC=I-1
      NTLOC = NLOC
C
C     LOC HAS NLOC LOCATIONS
C
C +++++
C500   CONTINUE
      CONTINUE
C +++++
      CALL OMATCH
      ITERT1=NITER
      ITERA1=TIME
C
C      UNCAS8 DATA (INPUT VARIABLES) ARE REQUIRED ONLY FOR SENSITIVITY
C      ANALYSIS AND ARE READ IN SUBROUTINE INSENS
C
      GO TO 998
900   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,901)
901   FORMAT(///////////,24X,'????? INPUT ERROR - UNCAS1 ?????')
      GO TO 999
904   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,905)
905   FORMAT(///////////,24X,'????? INPUT ERROR - UNCAS2 ?????')
      GO TO 999
906   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,907)
907   FORMAT(///////////,24X,'????? INPUT ERROR - UNCAS3 ?????')
      GO TO 999
910   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,911)
911   FORMAT(///////////,
     * 18X,'????? UNCAS3 INPUT TYPE NOT RECOGNIZED ?????')
      GO TO 999
912   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,913)
913   FORMAT(///////////,
     * 9X,'????? UNCAS3 - NUMBER OF MONTE CARLO SIMS NOT',
     *    ' SPECIFIED ?????')
      GO TO 999
920   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,921)
921   FORMAT(///////////,
     * 18X,'????? UNCAS4 INPUT TYPE NOT RECOGNIZED ?????')
      GO TO 999
922   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,923)
923   FORMAT(///////////,
     * 14X,'????? UNCAS4 - INPUT CONDITION NOT RECOGNIZED ?????')
      GO TO 999
924   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,925)
925   FORMAT(///////////,
     * 16X,'????? UNCAS4 - FDES VARIABLES NOT SPECIFIED ?????')
      GO TO 999
926   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,927)
927   FORMAT(///////////,
     * 12X,'????? UNCAS4 - IFOAMC GENERIC GROUPS NOT RECOGNIZED ?????')
      GO TO 999
930   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,931)
931   FORMAT(///////////,
     * 18X,'????? UNCAS5 INPUT TYPE NOT RECOGNIZED ?????')
      GO TO 999
940   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,941)
941   FORMAT(///////////,
     * 10X,'????? UNCAS5 - INTERMEDIATE OUTPUT TYPE NOT',
     * ' RECOGNIZED ?????')
      GO TO 999
950   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,951)
951   FORMAT(///////////,
     * 18X,'????? UNCAS6 INPUT TYPE NOT RECOGNIZED ?????')
      GO TO 999
952   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,953)
953   FORMAT(///////////,
     * 11X,'????? UNCAS6 - OUTPUT VARIABLE CODES NOT RECOGNIZED ?????')
      GO TO 999
960   CONTINUE
      CALL CLRSCR
      WRITE(CONOUT,961)
961   FORMAT(///////////,
     * 18X,'????? UNCAS7 INPUT TYPE NOT RECOGNIZED ?????')
      GO TO 999
998   CONTINUE
      RETURN
C999   CALL EXIT
 999  STOP
      END
