      SUBROUTINE URPT3
C
C      THIS SUBROUTINE WRITES A LIMITED INTERMEDIATE OUTPUT SUMMARY FOR
C      EACH UNCAS SIMULATION, AS SPECIFIED BY UNCAS5 DATA.  IT CONSISTS OF
C      A COMPARISON OF THE STEADY STATE CONVERGENCE SUMMARIES, AS WELL AS 
C      OF THE BASE CASE AND NEW VALUES OF THE OUTPUT VARIABLES AT THE
C      LOCATIONS SPECIFIED IN UNCAS7 DATA.  THIS SUMMARY IS AVAILABLE ONLY
C      FOR SENSITIVITY ANAYSIS USING FACTORIAL DESIGN AND FOR FOEA.
C
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'QUNCAS.VAR'
        INCLUDE 'IOUNIT.INC'
C +++++
        INCLUDE 'CONST.INC'
C +++++
C
      DIMENSION IVAR(MOVAR)
      CHARACTER*4 POVAR(MOVAR)
C
C      TEST FOR UNCERTAINTY ANALYSIS OPTION, URPT3 IS NOT ALLOWED
C      FOR MCS.
C
      IF(INTYPE.NE.3) GO TO 700
      RETURN
700   CONTINUE
C
C       WRITE SENSITIVITY SIMULATION OUTPUT HEADINGS.
C
      WRITE(NJ,109)
109   FORMAT(/5X,'C. STEADY STATE CONVERGENCE SUMMARY'//
     * 15X,'LOOP',25X,'NUMBER OF ITERATIONS'/
     * 47X,'BASE      NEW'/)
      WRITE(NJ,111) ITERT1,ITERT2,ITERA1,ITERA2
111   FORMAT(10X,'TEMPERATURE',24X,I5,5X,I5/
     * 10X,'ALGAE/NUTRIENT/DAMS',16X,I5,5X,I5/)
      WRITE(NJ,113)
113   FORMAT(/5X,'D. OUTPUT VARIABLE SUMMARY'//
     * 38X,'L  O  C  A  T  I  O  N'/)
      GO TO (210,220,230,240,250) NLOC
210   CONTINUE
      WRITE(NJ,212) (JR(K),K=1,NLOC)
212   FORMAT(9X,'OUTPUT ',1(7X,'REACH',I3))
      WRITE(NJ,214) (JE(K),K=1,NLOC)
214   FORMAT(8X,'VARIABLE ',1(5X,'ELEMENT',I3)/
     * 20X,1('  BASE   NEW   ')/)
      GO TO 260
220   CONTINUE
      WRITE(NJ,222) (JR(K),K=1,NLOC)
222   FORMAT(9X,'OUTPUT ',2(7X,'REACH',I3))
      WRITE(NJ,224) (JE(K),K=1,NLOC)
224   FORMAT(8X,'VARIABLE ',2(5X,'ELEMENT',I3)/
     * 20X,1('  BASE   NEW   ')/)
      GO TO 260
230   CONTINUE
      WRITE(NJ,232) (JR(K),K=1,NLOC)
232   FORMAT(9X,'OUTPUT ',3(7X,'REACH',I3))
      WRITE(NJ,234) (JE(K),K=1,NLOC)
234   FORMAT(8X,'VARIABLE ',3(5X,'ELEMENT',I3)/
     * 20X,3('  BASE   NEW   ')/)
      GO TO 260
240   CONTINUE
      WRITE(NJ,242) (JR(K),K=1,NLOC)
242   FORMAT(9X,'OUTPUT ',4(7X,'REACH',I3))
      WRITE(NJ,244) (JE(K),K=1,NLOC)
244   FORMAT(8X,'VARIABLE ',4(5X,'ELEMENT',I3)/
     * 20X,4('  BASE   NEW   ')/)
      GO TO 260
250   CONTINUE
      WRITE(NJ,115) (JR(K),K=1,NLOC)
115   FORMAT(9X,'OUTPUT ',5(7X,'REACH',I3))
      WRITE(NJ,117) (JE(K),K=1,NLOC)
117   FORMAT(8X,'VARIABLE ',5(5X,'ELEMENT',I3)/
     * 20X,5('  BASE   NEW   ')/)
260   CONTINUE
C
C      WRITE BASE AND UNCAS OUTPUT VALUES ONLY IF DIFFERENCES ARE
C      GREATER THAN 0.1%.
C
      JV=0
      DO 120 I=1,NOVAR
      IPF = 0
      JPRT=0
      DO 123 J=1,NLOC
      IF(QSAVE(I,J).GE.100.) IPF=1
      IF(SSAVE(I,J).GE.100.) IPF=1
      IF(QSAVE(I,J).GE.1000.) IPF=2
      IF(SSAVE(I,J).GE.1000.) IPF=2
      DELTA(J) = SSAVE(I,J)-QSAVE(I,J)
      PCNT(J) = 0.0
C +++++
C      IF(QSAVE(I,J).NE.0.0) PCNT(J) = DELTA(J)/QSAVE(I,J)*100.
      IF(QSAVE(I,J).GT.R0MIN) PCNT(J) = DELTA(J)/QSAVE(I,J)*100.
C +++++
      IF(ABS(PCNT(J)).GT.0.1) JPRT=1
123   CONTINUE
      IF(JPRT.EQ.1) GO TO 122
      JV = JV + 1
      IVAR(JV)=I
      GO TO 120
122   CONTINUE
      IF(IPF.EQ.1) GO TO 226
      IF(IPF.EQ.2) GO TO 126
      WRITE(NJ,121) VAROT(I),(QSAVE(I,J),SSAVE(I,J),J=1,NLOC)
121   FORMAT(/10X,A4,5X,5(2F7.2,1X))
      GO TO 128
126   WRITE(NJ,129) VAROT(I),(QSAVE(I,J),SSAVE(I,J),J=1,NLOC)
129   FORMAT(/10X,A4,5X,5(2F7.0,1X))
      GO TO 128
226   WRITE(NJ,229) VAROT(I),(QSAVE(I,J),SSAVE(I,J),J=1,NLOC)
229   FORMAT(/10X,A4,5X,5(2F7.1,1X))
128   CONTINUE
      WRITE(NJ,127) (DELTA(J),J=1,NLOC)
127   FORMAT(12X,'CHANGE  ',5(F9.2,6X))
      WRITE(NJ,227) (PCNT(J),J=1,NLOC)
227   FORMAT(12X,'PER CENT',5(F9.2,6X))
120   CONTINUE
C
C      WRITE NAMES OF OUTPUT VARIABLES AFFECTED BY LESS THAN 0.1%.
C
      IF(JV.EQ.NOVAR) GO TO 350
      IF(JV.EQ.0) GO TO 390
      WRITE(NJ,320)
320   FORMAT(////8X,'  RESPONSE VARIABLES AFFECTED LESS THAN 0.1%',
     * ' BY CHANGES IN THIS INPUT VARIABLE.'//)
      DO 321 K=1,JV,8
      DO 322 I=1,8
      IK = I+K-1
      POVAR(I)='    '
      J=IVAR(IK)
      IF(IK.GT.JV) GO TO 322
      POVAR(I)=VAROT(J)
322   CONTINUE
      WRITE(NJ,325) (POVAR(I),I=1,8)
325   FORMAT(8X,8(5X,A4))
321   CONTINUE
      GO TO 390
350   WRITE(NJ,351)
351   FORMAT(///8X,'  ALL OUTPUT RESPONSES AFFECTED LESS THAN 0.1%',
     * ' BY CHANGES IN THIS INPUT VARIABLE'//)
390   CONTINUE
      RETURN
      END
