      SUBROUTINE WRPT2(CONC)
CCC
CCC             NCASI Commentary, WRPT2 - Section A.
CCC                     A. Subroutine argument.
CCC
C                             WRPT2 WRITES AN INTERMEDIATE SUMMARY
C                             OF THE SELECTED QUALITY CONSTITUENTS.
C                             THESE CONSTITUENTS ARE WRITTEN BY REACH
C                             AND BY ELEMENT.  THIS SUMMARY CAN BE
C                             GIVEN AT A TIME INTERVAL OF DELT OR
C                             SOME MULTIPLE OF DELT.
C
C  UPDATED 6/84 T.WILSON: CORRECTED FORMAT STATEMENTS WHICH
C                         CONTINUED QUOTED STRINGS ACROSS LINES.
C
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
CCC     LEAVE THE COMPRT COMMON COMMENTED OUT. VALUES BEING PASSED IN
CCC     THE CONC ARRAY ARE ARRAYS LOCATED IN THIS COMMON AREA.
CCC     INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
      DIMENSION P(20),CONC(MC)
      IF(JPASS.EQ.0) WRITE(NJ,5)
5     FORMAT(1H1)
      JPASS = 1
CCC
CCC             NCASI Commentary, WRPT2 - Section B.
CCC                     B. Test for dynamic/steady simulation.
CCC
      IF (ISS) 20,20,10
   10 ITIME=TIME
      WRITE (NJ,15) (TITLE(NT,J),J=6,20),ITIME
   15 FORMAT (1H0,19X,15A4,4X,9HITERATION,I3)
      GO TO 55
   20 CONTINUE
      TINDAY=TIME/24.0
      WRITE (NJ,50) (TITLE(NT,J),J=6,20),TINDAY
   50 FORMAT (1H0,19X,15A4,1X,F5.2,5H DAYS,/)
C                                       STEP 1-0
   55 CONTINUE
CCC
CCC             NCASI Commentary, WRPT2 - Section C.
CCC                     C. Test for coliform printing.
CCC
      IF(NT.EQ.14) GO TO  400
CCC
CCC             NCASI Commentary, WRPT2 - Section D.
CCC                     D. Regular print out format.
CCC
      WRITE(NJ,60)
   60 FORMAT (2X,'RCH/CL  1     2     3     4     5     6     7',
     *'     8     9    10    11    12    13    14    15',
     *'    16    17    18    19',
     *'    20',/)
CCC
CCC                     D.1 Set up loop on the number of reaches
CCC                          and elements in the system.
CCC
      DO 100 I=1,NREACH
      NCELR=NCELRH(I)
      DO 200 J=1,NCELR
      IOR=ICLORD(I,J)
      P(J)=CONC(IOR)
CBR
CBR
      IF((NT .EQ. 6).AND.(METOUT.NE.0)) P(J)=(P(J)-32.)/1.8
CBR
CBR
      IF(NT .EQ. 8) P(J)=P(J)*ALPHAO(I)
  200 CONTINUE
CCC
CCC                     D.7 Print out values (intermediate
CCC                          summary). (QUAL2 Step 1-1)
CCC
      WRITE (NJ,300) I,(P(J),J=1,NCELR)
  300 FORMAT (2X,I3,20F6.2)
  100 CONTINUE
CCC
CCC                     D.9 Return to  MAIN or SOVMAT.
CCC
      RETURN
  400 CONTINUE
CCC
CCC             NCASI Commentary, WRPT2 - Section E.
CCC                     E. Special print out for coliform.
CCC
      DO 150 I=1,NREACH
      NCELR=NCELRH(I)
      DO 160 J=1,NCELR
      IOR=ICLORD(I,J)
      P(J)=CONC(IOR)
  160 CONTINUE
      WRITE(NJ,410) I,(P(J),J=1,NCELR)
  410 FORMAT(2X,'RCH/CL     1         2         3         4         5',
     A'         6         7         8         9        10',/,2X,I3,3X,
     B10(1PE10.2),/,2X,'    CL    11        12        13        14',
     C' 15        16        17        18        19        20',/,8X,
     D10(1PE10.2))
  150 CONTINUE
CCC
CCC                     E.5 Return to MAIN or SOVMAT.
CCC
      RETURN
      END
