      SUBROUTINE WRPT3A (NPAGE)
C
C                             WRPT3 WRITES THE FINAL CONCENTRATION
C                             OF THE SELECTED QUALITY CONSTITUENTS.
C                             THESE CONSTITUENTS ARE WRITTEN BY REACH
C                             AND BY ELEMENT.
C  UPDATED 6/84 T.WILSON: CORRECTED FORMAT STATEMENTS WHICH
C                         CONTINUED QUOTED STRINGS ACROSS LINES.
C
C
CC
        INCLUDE 'MAIN.VAR'
        INCLUDE 'ARRAYS.VAR'
        INCLUDE 'CHARCT.VAR'
        INCLUDE 'COMPRT.VAR'
        INCLUDE 'HDWTRS.VAR'
        INCLUDE 'JUNCTS.VAR'
        INCLUDE 'REACHS.VAR'
        INCLUDE 'WASTLD.VAR'
        INCLUDE 'IOUNIT.INC'
CC
C//   DATA NPAGE/0/
      NPAGE = 0
CCC
CCC             NCASI Commentary, WRPT3 - Section A.
CCC                     A. Initialize counters and constants.
CCC
      NHW = 0
      NWS = 0
      LP=LPPG
      DELM = DELX / 5280.0
      IF( METOUT .GT. 0 ) DELM = DELM * 1.609
CCC
CCC             NCASI Commentary, WRPT3 - Section B.
CCC                     B. Set up loop on the number of reaches
CCC                         and elements in the system.
CCC
      DO 300 I = 1, NREACH
      WRITE(NJ,6000)
      LP = LP + 2
      RLTHOR = RMTHOR(I)
      IF( METOUT .GT. 0 ) RLTHOR=RLTHOR*1.609
      NCELR = NCELRH(I)
      CNCELR = NCELR
      QINC = QI(I) / CNCELR
      IF( METOUT .GT. 0 ) QINC = QINC / 35.3133
      DO 300 J = 1, NCELR
      LP = LP + 1
      IF(LP.LT.LPPG)GO TO 288
      LP=0
      NPAGE = NPAGE + 1
CCC
CCC                     B.5 Print page heading.
CCC
      WRITE(NJ,6005) NPAGE,VERNUM
      IF( ISS .EQ. 0 ) WRITE(NJ,6007) TIME
      IF( ISS .GT. 0 ) WRITE(NJ,6008)
CCC
CCC                     B.6 Write units at column headings
CCC                          according to metric/English output.
CCC
      WRITE(NJ,6009)
      IF(METOUT.EQ.0) WRITE(NJ,6010)
      IF(METOUT.GT.0) WRITE(NJ,6011)
  288 IOR = ICLORD(I,J)
CCC
CCC             NCASI Commentary, WRPT3 - Section C.
CCC                     C. Set up to flag headwater flows and
CCC                         point source/withdrawal flows for
CCC                         printing.
CCC
      QHWD = 0.0
      QWSI = 0.0
      IFL = IFLAG(I,J)
      GO TO (290,296,296,296,296,292,294), IFL
  290 NHW = NHW + 1
      QHWD = HWFLOW(NHW)
      GO TO 296
  292 NWS = NWS + 1
      QWSI = WSFLOW(NWS)
      GO TO 296
  294 NWS = NWS + 1
      QWSI = + WSFLOW(NWS)
CCC
CCC             NCASI Commentary, WRPT3 - Section D.
CCC                     D. Define new variables for printing.
CCC
  296 XMH = RLTHOR - FLOAT( J - 1 ) * DELM
      XME = XMH - DELM
      QXX = FLOW(IOR)
      VXX = VEL(IOR)
      DXX = DEPTH(IOR)
      WXX = EWIDTH(IOR)
      VOXX = VOLSEG(IOR)
      BAXX = BAREA(IOR)
      XAXX = XAREA(IOR)
      DLXX = DL(IOR)
      IF( METOUT .EQ. 0 ) GO TO 297
      QWSI = QWSI / 35.3133
      QXX = QXX / 35.3133
      VXX = VXX/3.2808
      DXX = DXX/3.2808
      WXX = WXX/3.2808
      VOXX = VOXX/35.3133
      BAXX = BAXX/10.7636
      XAXX = XAXX/10.7636
      DLXX = DLXX/10.7636
  297 CONTINUE
      VOK = VOXX/1000.
      BAK = BAXX/1000.
CCC
CCC             NCASI Commentary, WRPT3 - Section E.
CCC                     E. Write out primary information,
CCC                         one line per element.
CCC
      WRITE(NJ,6015)IOR,I,J,XMH,XME,QXX,QWSI,QINC,
     1VXX,TRVTM(IOR),DXX,WXX,VOK,BAK,XAXX,DLXX
C3P1   OUTPUT INTERFACE - HYDRAULICS   (LCB-6/89)
      OSIM(IOR,1) = IOR
      OSIM(IOR,2) = I
      OSIM(IOR,3) = J
      OSIM(IOR,5) = XMH
      OSIM(IOR,6) = XME
      OSIM(IOR,7) = QXX
      OSIM(IOR,8) = QWSI
      OSIM(IOR,9) = QINC
      OSIM(IOR,10) = VXX
      OSIM(IOR,11) = TRVTM(IOR)
      OSIM(IOR,12) = DXX
      OSIM(IOR,13) = WXX
      OSIM(IOR,14) = VOK
      OSIM(IOR,15) = BAK
      OSIM(IOR,16) = XAXX
      OSIM(IOR,17) = DLXX
C3P1
  300 CONTINUE
CQET
CQET            WRITE OPTIONAL REACH VARIABLE TEMPERATURE OUTPUT
CQET
      IF(IFGRVT.EQ.0) GO TO 701
      IF(ISS.EQ.0.AND.PTIME.LT.0.0) RETURN
      RHOCP = 62.4
      LP=LPPG
      DELM = DELX/5280.
      IF(METOUT.GT.0) DELM = DELM*1.609
      DO 700 I=1,NREACH
      WRITE(NJ,6000)
      LP = LP + 2
      RLTHOR = RMTHOR(I)
      IF(METOUT.GT.0) RLTHOR = RLTHOR*1.609
      NCELR = NCELRH(I)
      CNCELR = NCELR
      VPWB = 0.1001*EXP(0.03*RCHTWB(I))-0.0837
      VPAIR = VPWB
     *      -0.000367*RCHATM(I)*(RCHTDB(I)-RCHTWB(I))*
     *      (1.0+(RCHTWB(I)-32.)/1571.0)
      CLC = 1.0 + 0.17*RCHCLD(I)**2
      HA = 4.85E-15*(RCHTDB(I)+460.0)**6*CLC
      ELVX = RCHELV(I)
      DBTX = RCHTDB(I)
      WBTX = RCHTWB(I)
      ATMX = RCHATM(I)
      WNDX = RCHWND(I)/0.6818
      HSX = TSONET(I)
      HAX = HA
      IF(METOUT.EQ.0) GO TO 787
      ELVX = ELVX/3.2808
      DBTX = (DBTX-32.0)*(5./9.)
      WBTX = (WBTX-32.0)*(5./9.)
      ATMX = ATMX*1000.0/29.9
      WNDX = WNDX*.3048
      HSX = HSX/3.685
      HAX = HAX/3.685
787   CONTINUE
      DO 700 J=1,NCELR
      LP = LP + 1
      IF(LP.LT.LPPG) GO TO 788
      LP = 0
      NPAGE = NPAGE + 1
      WRITE(NJ,6005) NPAGE,VERNUM
      IF(ISS.EQ.0) WRITE(NJ,6007) TIME
      IF(ISS.GT.0) WRITE(NJ,6008)
      WRITE(NJ,6079)
      IF(METOUT.EQ.0) WRITE(NJ,7080)
      IF(METOUT.GT.0) WRITE(NJ,7081)
      WRITE(NJ,7082)
      IF(METOUT.EQ.0) WRITE(NJ,6080)
      IF(METOUT.GT.0) WRITE(NJ,6081)
788   IOR = ICLORD(I,J)
      TJ = (T(IOR)-35.)/5.
      M=TJ+1
      HLAT = 1084. - 0.5*T(IOR)
      B1=RHOCP*HLAT*(AE+BE*RCHWND(I))
      HB = ALFA2(M)+BETA2(M)*T(IOR)
      HC = B1*0.01*(T(IOR)-RCHTDB(I))
      HE = B1*(ALFA1(M)-VPAIR+BETA1(M)*T(IOR))
      XMH = RLTHOR-FLOAT(J-1)*DELM
      XME = XMH - DELM
      HBX = -HB
      HCX = -HC
      HEX = -HE
      IF(METOUT.EQ.0) GO TO 789
      HBX = HBX/3.685
      HCX = HCX/3.685
      HEX = HEX/3.685
789   CONTINUE
      HNX = HSX+HAX+HBX+HCX+HEX
CQET
CQET       WRITE LCD/HEAT BUDGET DATA
CQET
      IF(METOUT.EQ.0) GO TO 790
      WRITE(NJ,6086) IOR,I,J,XMH,XME,ELVX,RCHDAC(I),
     * RCHCLD(I),DBTX,WBTX,ATMX,WNDX,HSX,HAX,HBX,HCX,
     * HEX,HNX
      GO TO 700
790   WRITE(NJ,6085) IOR,I,J,XMH,XME,ELVX,RCHDAC(I),
     * RCHCLD(I),DBTX,WBTX,ATMX,WNDX,HSX,HAX,HBX,HCX,
     * HEX,HNX
C3P1   OUTPUT INTERFACE - HEAT BUDGET  (LCB-6/89)
      OSIM(IOR,73) = ELVX
      OSIM(IOR,74) = RCHDAC(I)
      OSIM(IOR,75) = RCHCLD(I)
      OSIM(IOR,76) = DBTX
      OSIM(IOR,77) = WBTX
      OSIM(IOR,78) = ATMX
      OSIM(IOR,79) = WNDX
      OSIM(IOR,80) = HSX
      OSIM(IOR,81) = HAX
      OSIM(IOR,82) = HBX
      OSIM(IOR,83) = HCX
      OSIM(IOR,84) = HEX
      OSIM(IOR,85) = HNX
C3P1
700   CONTINUE
701   CONTINUE
CQ2E
CQ2E            WRITE RATE COEFFICIENTS.
CQ2E
      IF( ISS .EQ. 0 .AND. PTIME .LT. 0.0 ) RETURN
      LP=LPPG
      IJUNC = 0
      DO 400 I = 1, NREACH
      WRITE(NJ,6000)
      LP = LP + 2
      NCELR = NCELRH(I)
      DO 400 J = 1, NCELR
      LP = LP + 1
      IF(LP.LT.LPPG)GO TO 350
      LP=0
      NPAGE = NPAGE + 1
      WRITE(NJ,6005) NPAGE,VERNUM
      IF( ISS .EQ. 0 ) WRITE(NJ,6007) TIME
      IF( ISS .NE. 0 ) WRITE(NJ,6008)
      WRITE(NJ,6019)
      IF( METOUT .EQ. 0 ) WRITE(NJ,6020)
      IF( METOUT .GT. 0 ) WRITE(NJ,6021)
  350 IOR = ICLORD(I,J)
CCC
CCC             NCASI Commentary, WRPT3 - Section G.
CCC                     G. Define new variables for printing.
CCC
C 370 XMH = RMTHOR(I) - FLOAT(J-1)*DELM
C     XME = XMH - DELM
      XKC4 = SOD(IOR)
      XSRCN = SRCNH3(IOR)
      XSRCP = SCPHOS(IOR)
      XSRCA = SRANC(IOR)
      IF( METOUT .EQ. 0 ) GO TO 375
      XKC4 = XKC4*10.7636
      XSRCN = XSRCN*10.7636
      XSRCP = XSRCP*10.7636
      XSRCA = XSRCA*10.7636
  375 CONTINUE
CQ2E
CQ2E            WRITE WATER QUALITY VARIABLES
CQ2E
      WRITE(NJ,6025)I,J,DOSAT(IOR),K2OPT(I),XK2(IOR),K1(IOR),
     1  K3(IOR),XKC4,KNH2(IOR),SETNH2(IOR),KNH3(IOR),XSRCN,
     2   KNO2(IOR),KPORG(IOR),STPORG(IOR),XSRCP,K5(IOR),
     3   KANC(IOR),STANC(IOR),XSRCA
C3P1  OUTPUT INTERFACE - RATE COEFFICIENTS  (LCB-6/89)
      OSIM(IOR,18) = DOSAT(IOR)
      OSIM(IOR,19) = K2OPT(I)
      OSIM(IOR,20) = XK2(IOR)
      OSIM(IOR,21) = K1(IOR)
      OSIM(IOR,22) = K3(IOR)
      OSIM(IOR,23) = XKC4
      OSIM(IOR,24) = KNH2(IOR)
      OSIM(IOR,25) = SETNH2(IOR)
      OSIM(IOR,26) = KNH3(IOR)
      OSIM(IOR,27) = XSRCN
      OSIM(IOR,28) = KNO2(IOR)
      OSIM(IOR,29) = KPORG(IOR)
      OSIM(IOR,30) = STPORG(IOR)
      OSIM(IOR,31) = XSRCP
      OSIM(IOR,32) = K5(IOR)
      OSIM(IOR,33) = KANC(IOR)
      OSIM(IOR,34) = STANC(IOR)
      OSIM(IOR,35) = XSRCA
C3P1
  400 CONTINUE
CQ2E
CQ2E            FORMAT STATEMENTS
CQ2E
6000    FORMAT(/)
 6005 FORMAT( 1H1 /
     * 10X, 25HSTREAM QUALITY SIMULATION, 70X, 19HOUTPUT PAGE NUMBER ,I5
     *   /  10X, 36HQUAL-2E STREAM QUALITY ROUTING MODEL, 51X, A26)
C     *  'EPA/NCASI VERSION')
 6007 FORMAT( / 10X, 'SYSTEM STATUS AFTER', F8.2, ' HOURS OF DYNAMIC',
     1'OPERATION'  )
 6008 FORMAT( 50X, 35H***** STEADY STATE SIMULATION *****  )
6009    FORMAT( / 55X,'** HYDRAULICS SUMMARY **'//
     1 ' ELE RCH ELE   BEGIN',5X,'END',11X,'POINT',4X,
     1 'INCR',12X,'TRVL',35X,' BOTTOM',6X,'X-SECT   DSPRSN'/,
     2 ' ORD NUM NUM',2(5X,'LOC'),4X,'FLOW',4X,'SRCE',4X,'FLOW',5X,
     3 'VEL',4X,'TIME',4X,'DEPTH',4X,'WIDTH',6X,'VOLUME',
     4 2(8X,'AREA'),5X,'COEF')
6011    FORMAT(12X,2(4X,'KILO'),3(5X,'CMS'),5X,'MPS',5X,'DAY',
     1  2(8X,'M'),6X,'K-CU-M',6X,
     2  'K-SQ-M',8X,'SQ-M',3X,'SQ-M/S'/)
6010    FORMAT(12X,2(4X,'MILE'),3(5X,'CFS'),5X,'FPS',5X,'DAY',
     2  2(7X,'FT'),6X,'K-FT-3',6X,
     2  'K-FT-2',8X,'FT-2',3X,'FT-2/S'/)
6015    FORMAT(3I4,5F8.2,2F8.3,2F9.3,3F12.2,F9.2)
6019    FORMAT( / 50X,'** REACTION COEFFICIENT SUMMARY **'//
     1' RCH ELE',5X,'DO  K2  OXYGN',2(4X,'BOD'),
     1 4X,'SOD',2(3X,'ORGN'),2(4X,'NH3'),4X,'NO2',
     2 2(3X,'ORGP'),3X,'DISP',3X,'COLI',3(4X,'ANC')/
     3 2(' NUM'),4X,'SAT OPT  REAIR  DECAY   SETT',
     4 '   RATE  DECAY   SETT  DECAY   SRCE',2(2X,'DECAY'),3X,
     5  'SETT   SRCE',2(2X,'DECAY'),3X,'SETT   SRCE')
6020    FORMAT(11X,'MG/L',4X,3(2X,'1/DAY'),2X,'G/F2D',2X,'1/DAY',
     1 '  1/DAY  1/DAY MG/F2D',2(2X,'1/DAY'),2X,'1/DAY MG/F2D',
     2  2(2X,'1/DAY'),2X,'1/DAY MG/F2D'/)
6021    FORMAT(11X,'MG/L',4X,3(2X,'1/DAY'),2X,'G/M2D',2X,'1/DAY',
     1 '  1/DAY  1/DAY MG/M2D',2(2X,'1/DAY'),2X,'1/DAY MG/M2D',
     2  2(2X,'1/DAY'),2X,'1/DAY MG/M2D'/)
6025    FORMAT(2I4,F7.2,I4,16F7.2)
6079  FORMAT(/48X,'**CLIMATOLOGY - HEAT BALANCE SUMMARY**'/)
7080  FORMAT(89X,'COMPONENTS OF SS HEAT BALANCE (BTU/FT-2)')
7081  FORMAT(89X,'COMPONENTS OF SS HEAT BALANCE (LANGLEYS)')
7082  FORMAT(' ELE RCH ELE   BEGIN',5X,'END   ELEV   DUST',
     * '  CLOUD  D BLB  W BLB    ATM   WIND  OTHER',4X,
     * 'SOLAR L WAVE W SURF   COND   EVAP',6X,'NET'/
     * ' ORD NUM NUM',2(5X,'LOC'),21X,2(3X,'TEMP'),3X,'PRSR',
     * 26X,'ATM  BACK R',19X,'HEAT')
6080  FORMAT(12X,2(4X,'MILE'),5X,'FT',14X,2('  DEG-F'),'  IN-HG',
     * '   FT/S',13X,'HS',5X,'HA',5X,'HB',5X,'HC',5X,'HE',7X,
     * 'HN'//)
6081  FORMAT(12X,2(6X,'KM'),6X,'M',14X,2('  DEG-C'),'  M-BAR',
     * '    M/S',13X,'HS',5X,'HA',5X,'HB',5X,'HC',5X,'HE',7X,
     * 'HN'//)
6085  FORMAT(3I4,2F8.2,F7.1,6F7.2,9X,5F7.1,F9.1)
6086  FORMAT(3I4,2F8.2,F7.1,4F7.2,F7.1,F7.2,9X,5F7.1,F9.1) 
        END
